/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.Extension;
import hudson.MarkupText;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.jira.JiraBuildAction;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.model.JiraIssue;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

@Extension
public class JiraChangeLogAnnotator
extends ChangeLogAnnotator {
    private static final Logger LOGGER = Logger.getLogger(JiraChangeLogAnnotator.class.getName());

    public JiraChangeLogAnnotator() {
        LOGGER.fine("JiraChangeLogAnnotator created");
    }

    public void annotate(Run<?, ?> run, ChangeLogSet.Entry change, MarkupText text) {
        JiraSite site = this.getSiteForProject(run.getParent());
        if (site == null) {
            LOGGER.fine("not configured with Jira site");
            return;
        }
        if (site.getDisableChangelogAnnotations()) {
            LOGGER.info("ChangeLog annotations are disabled.\n Due to this also Related Issues won't be visible.");
            return;
        }
        LOGGER.log(Level.FINE, "Using site: {0}", site.getUrl());
        JiraBuildAction a = (JiraBuildAction)run.getAction(JiraBuildAction.class);
        LinkedHashSet<JiraIssue> issuesToBeSaved = new LinkedHashSet<JiraIssue>();
        Pattern pattern = site.getIssuePattern();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Using issue pattern: " + String.valueOf(pattern));
        }
        String plainText = text.getText();
        Matcher m = pattern.matcher(plainText);
        while (m.find()) {
            if (m.groupCount() >= 1) {
                URL url;
                String id = m.group(1);
                if (StringUtils.isNotBlank((String)site.credentialsId) && !this.hasProjectForIssue(id, site, run)) {
                    LOGGER.log(Level.INFO, "No known Jira project corresponding to id: ''{0}''", id);
                    continue;
                }
                LOGGER.log(Level.FINE, "Annotating Jira id: ''{0}''", id);
                try {
                    url = site.getUrl(id);
                }
                catch (MalformedURLException e) {
                    throw new AssertionError((Object)e);
                }
                try {
                    URL alternativeUrl = site.getAlternativeUrl(id);
                    if (alternativeUrl != null) {
                        url = alternativeUrl;
                    }
                }
                catch (MalformedURLException e) {
                    LOGGER.log(Level.WARNING, "Failed to construct alternative URL for Jira link. " + e.getMessage());
                    throw new AssertionError((Object)e);
                }
                JiraIssue issue = null;
                if (a != null) {
                    issue = a.getIssue(id);
                }
                if (issue == null) {
                    try {
                        issue = site.getIssue(id);
                        if (issue != null) {
                            issuesToBeSaved.add(issue);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "Error getting remote issue " + id, e);
                    }
                }
                if (issue == null) {
                    text.addMarkup(m.start(1), m.end(1), "<a href='" + String.valueOf(url) + "'>", "</a>");
                    continue;
                }
                text.addMarkup(m.start(1), m.end(1), String.format("<a href='%s' tooltip='%s'>", url, Util.escape((String)issue.getSummary())), "</a>");
                continue;
            }
            LOGGER.log(Level.WARNING, "The Jira pattern ''{0}'' doesn't define a capturing group!", pattern);
        }
        if (!issuesToBeSaved.isEmpty()) {
            this.saveIssues(run, a, issuesToBeSaved);
        }
    }

    protected boolean hasProjectForIssue(String id, JiraSite site, Run run) {
        int idx = id.indexOf(45);
        if (idx == -1) {
            return false;
        }
        Set<String> keys = site.getProjectKeys((Item)run.getParent());
        return keys.contains(id.substring(0, idx).toUpperCase());
    }

    private void saveIssues(Run<?, ?> build, JiraBuildAction a, Set<JiraIssue> issuesToBeSaved) {
        if (a != null) {
            a.addIssues(issuesToBeSaved);
        } else {
            JiraBuildAction action = new JiraBuildAction(issuesToBeSaved);
            build.addAction((Action)action);
        }
        try {
            build.save();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error saving updated build", e);
        }
    }

    JiraSite getSiteForProject(Job<?, ?> project) {
        return JiraSite.get(project);
    }
}

