/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.atlassian.jira.rest.client.auth.BasicHttpAuthenticationHandler;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.plugins.jira.JiraRestService;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.auth.BearerHttpAuthenticationHandler;
import hudson.plugins.jira.extension.ExtendedJiraRestClient;
import java.net.URI;

public class JiraSessionFactory {
    public static JiraSession create(JiraSite jiraSite, URI uri, StandardUsernamePasswordCredentials credentials) {
        JiraRestService jiraRestService;
        if (jiraSite.isUseBearerAuth()) {
            BearerHttpAuthenticationHandler bearerHttpAuthenticationHandler = new BearerHttpAuthenticationHandler(credentials.getPassword().getPlainText());
            ExtendedJiraRestClient jiraRestClient = new JiraSite.ExtendedAsynchronousJiraRestClientFactory().create(uri, bearerHttpAuthenticationHandler, jiraSite.getHttpClientOptions());
            jiraRestService = new JiraRestService(uri, jiraRestClient, credentials.getPassword().getPlainText(), jiraSite.getReadTimeout());
        } else {
            ExtendedJiraRestClient jiraRestClient = new JiraSite.ExtendedAsynchronousJiraRestClientFactory().create(uri, (AuthenticationHandler)new BasicHttpAuthenticationHandler(credentials.getUsername(), credentials.getPassword().getPlainText()), jiraSite.getHttpClientOptions());
            jiraRestService = new JiraRestService(uri, jiraRestClient, credentials.getUsername(), credentials.getPassword().getPlainText(), jiraSite.getReadTimeout());
        }
        return new JiraSession(jiraSite, jiraRestService);
    }
}

