/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira.extension;

import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.gen.JsonGenerator;
import hudson.plugins.jira.extension.ExtendedVersionInput;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;

public class ExtendedVersionInputJsonGenerator
implements JsonGenerator<ExtendedVersionInput> {
    public JSONObject generate(ExtendedVersionInput version) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)version.getName());
        jsonObject.put("project", (Object)version.getProjectKey());
        if (version.getDescription() != null) {
            jsonObject.put("description", (Object)version.getDescription());
        }
        if (version.getStartDate() != null) {
            jsonObject.put("startDate", (Object)JsonParseUtil.formatDate((DateTime)version.getStartDate()));
        }
        if (version.getReleaseDate() != null) {
            jsonObject.put("releaseDate", (Object)JsonParseUtil.formatDate((DateTime)version.getReleaseDate()));
        }
        jsonObject.put("released", version.isReleased());
        jsonObject.put("archived", version.isArchived());
        return jsonObject;
    }
}

