/*
 * Decompiled with CFR 0.152.
 */
package javaposse.jobdsl.plugin;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.TaskListener;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.tasks.Builder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javaposse.jobdsl.dsl.DslException;
import javaposse.jobdsl.dsl.DslScriptLoader;
import javaposse.jobdsl.dsl.GeneratedConfigFile;
import javaposse.jobdsl.dsl.GeneratedItems;
import javaposse.jobdsl.dsl.GeneratedJob;
import javaposse.jobdsl.dsl.GeneratedUserContent;
import javaposse.jobdsl.dsl.GeneratedView;
import javaposse.jobdsl.dsl.JobManagement;
import javaposse.jobdsl.dsl.ScriptRequest;
import javaposse.jobdsl.plugin.DescriptorImpl;
import javaposse.jobdsl.plugin.InterruptibleJobManagement;
import javaposse.jobdsl.plugin.JenkinsJobManagement;
import javaposse.jobdsl.plugin.LookupStrategy;
import javaposse.jobdsl.plugin.RemovedJobAction;
import javaposse.jobdsl.plugin.RemovedViewAction;
import javaposse.jobdsl.plugin.ScriptRequestGenerator;
import javaposse.jobdsl.plugin.SeedReference;
import javaposse.jobdsl.plugin.actions.GeneratedConfigFilesAction;
import javaposse.jobdsl.plugin.actions.GeneratedConfigFilesBuildAction;
import javaposse.jobdsl.plugin.actions.GeneratedJobsAction;
import javaposse.jobdsl.plugin.actions.GeneratedJobsBuildAction;
import javaposse.jobdsl.plugin.actions.GeneratedObjectsAction;
import javaposse.jobdsl.plugin.actions.GeneratedUserContentsAction;
import javaposse.jobdsl.plugin.actions.GeneratedUserContentsBuildAction;
import javaposse.jobdsl.plugin.actions.GeneratedViewsAction;
import javaposse.jobdsl.plugin.actions.GeneratedViewsBuildAction;
import jenkins.model.Jenkins;
import org.apache.commons.io.FilenameUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class ExecuteDslScripts
extends Builder {
    private static final Logger LOGGER = Logger.getLogger(ExecuteDslScripts.class.getName());
    private final String targets;
    private final String scriptText;
    private final boolean usingScriptText;
    private final boolean ignoreExisting;
    private final RemovedJobAction removedJobAction;
    private final RemovedViewAction removedViewAction;
    private final LookupStrategy lookupStrategy;
    private final String additionalClasspath;

    @DataBoundConstructor
    public ExecuteDslScripts(ScriptLocation scriptLocation, boolean ignoreExisting, RemovedJobAction removedJobAction, RemovedViewAction removedViewAction, LookupStrategy lookupStrategy, String additionalClasspath) {
        this.usingScriptText = scriptLocation == null || scriptLocation.usingScriptText;
        this.targets = scriptLocation == null ? null : scriptLocation.targets;
        this.scriptText = scriptLocation == null ? null : scriptLocation.scriptText;
        this.ignoreExisting = ignoreExisting;
        this.removedJobAction = removedJobAction;
        this.removedViewAction = removedViewAction;
        this.lookupStrategy = lookupStrategy == null ? LookupStrategy.JENKINS_ROOT : lookupStrategy;
        this.additionalClasspath = additionalClasspath;
    }

    public ExecuteDslScripts(ScriptLocation scriptLocation, boolean ignoreExisting, RemovedJobAction removedJobAction, LookupStrategy lookupStrategy) {
        this(scriptLocation, ignoreExisting, removedJobAction, RemovedViewAction.IGNORE, lookupStrategy, null);
    }

    public ExecuteDslScripts(ScriptLocation scriptLocation, boolean ignoreExisting, RemovedJobAction removedJobAction) {
        this(scriptLocation, ignoreExisting, removedJobAction, LookupStrategy.JENKINS_ROOT);
    }

    public ExecuteDslScripts(ScriptLocation scriptLocation, boolean ignoreExisting, RemovedJobAction removedJobAction, RemovedViewAction removedViewAction, LookupStrategy lookupStrategy) {
        this(scriptLocation, ignoreExisting, removedJobAction, removedViewAction, lookupStrategy, null);
    }

    ExecuteDslScripts(String scriptText) {
        this.usingScriptText = true;
        this.scriptText = scriptText;
        this.targets = null;
        this.ignoreExisting = false;
        this.removedJobAction = RemovedJobAction.DISABLE;
        this.removedViewAction = RemovedViewAction.IGNORE;
        this.lookupStrategy = LookupStrategy.JENKINS_ROOT;
        this.additionalClasspath = null;
    }

    ExecuteDslScripts() {
        this(null);
    }

    public String getTargets() {
        return this.targets;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public boolean isUsingScriptText() {
        return this.usingScriptText;
    }

    public boolean isIgnoreExisting() {
        return this.ignoreExisting;
    }

    public RemovedJobAction getRemovedJobAction() {
        return this.removedJobAction;
    }

    public RemovedViewAction getRemovedViewAction() {
        return this.removedViewAction;
    }

    public LookupStrategy getLookupStrategy() {
        return this.lookupStrategy == null ? LookupStrategy.JENKINS_ROOT : this.lookupStrategy;
    }

    public String getAdditionalClasspath() {
        return this.additionalClasspath;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return Arrays.asList(new GeneratedJobsAction(project), new GeneratedViewsAction(project), new GeneratedConfigFilesAction(project), new GeneratedUserContentsAction(project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean bl;
        EnvVars env = build.getEnvironment((TaskListener)listener);
        env.putAll(build.getBuildVariables());
        InterruptibleJobManagement jm = new InterruptibleJobManagement((JobManagement)new JenkinsJobManagement(listener.getLogger(), env, build, this.getLookupStrategy()));
        ScriptRequestGenerator generator = new ScriptRequestGenerator(build, env);
        try {
            Set<ScriptRequest> scriptRequests = generator.getScriptRequests(this.targets, this.usingScriptText, this.scriptText, this.ignoreExisting, this.additionalClasspath);
            LinkedHashSet<GeneratedJob> freshJobs = new LinkedHashSet<GeneratedJob>();
            LinkedHashSet<GeneratedView> freshViews = new LinkedHashSet<GeneratedView>();
            LinkedHashSet<GeneratedConfigFile> freshConfigFiles = new LinkedHashSet<GeneratedConfigFile>();
            LinkedHashSet<GeneratedUserContent> freshUserContents = new LinkedHashSet<GeneratedUserContent>();
            for (ScriptRequest request : scriptRequests) {
                LOGGER.log(Level.FINE, String.format("Request for %s", request.getLocation()));
                GeneratedItems generatedItems = DslScriptLoader.runDslEngine((ScriptRequest)request, (JobManagement)jm);
                freshJobs.addAll(generatedItems.getJobs());
                freshViews.addAll(generatedItems.getViews());
                freshConfigFiles.addAll(generatedItems.getConfigFiles());
                freshUserContents.addAll(generatedItems.getUserContents());
            }
            this.updateTemplates(build, listener, freshJobs);
            this.updateGeneratedJobs(build, listener, freshJobs);
            this.updateGeneratedViews(build, listener, freshViews);
            this.updateGeneratedConfigFiles(build, listener, freshConfigFiles);
            this.updateGeneratedUserContents(build, listener, freshUserContents);
            build.addAction((Action)new GeneratedJobsBuildAction(freshJobs, this.getLookupStrategy()));
            build.addAction((Action)new GeneratedViewsBuildAction(freshViews, this.getLookupStrategy()));
            build.addAction((Action)new GeneratedConfigFilesBuildAction((Collection<GeneratedConfigFile>)freshConfigFiles));
            build.addAction((Action)new GeneratedUserContentsBuildAction((Collection<GeneratedUserContent>)freshUserContents));
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                generator.close();
                throw throwable;
            }
            catch (DslException e) {
                LOGGER.log(Level.FINE, String.format("Exception while processing DSL scripts: %s", e.getMessage()), e);
                throw new AbortException(e.getMessage());
            }
        }
        generator.close();
        return bl;
    }

    private Set<String> updateTemplates(AbstractBuild<?, ?> build, BuildListener listener, Set<GeneratedJob> freshJobs) throws IOException {
        Collection matching;
        Collection seedJobReferences;
        AbstractProject seedJob = build.getProject();
        Set<String> freshTemplates = ExecuteDslScripts.getTemplates(freshJobs);
        Set<String> existingTemplates = ExecuteDslScripts.getTemplates(GeneratedObjectsAction.extractGeneratedObjects(seedJob, GeneratedJobsAction.class));
        Sets.SetView newTemplates = Sets.difference(freshTemplates, existingTemplates);
        Sets.SetView removedTemplates = Sets.difference(existingTemplates, freshTemplates);
        ExecuteDslScripts.logItems(listener, "Existing templates", existingTemplates);
        ExecuteDslScripts.logItems(listener, "New templates", newTemplates);
        ExecuteDslScripts.logItems(listener, "Unreferenced templates", removedTemplates);
        String seedJobName = seedJob.getName();
        DescriptorImpl descriptor = (DescriptorImpl)Jenkins.getInstance().getDescriptorByType(DescriptorImpl.class);
        boolean descriptorMutated = false;
        for (String templateName : removedTemplates) {
            seedJobReferences = descriptor.getTemplateJobMap().get((Object)templateName);
            matching = Collections2.filter((Collection)seedJobReferences, (Predicate)new SeedNamePredicate(seedJobName));
            if (matching.isEmpty()) continue;
            seedJobReferences.removeAll(matching);
            descriptorMutated = true;
        }
        for (String templateName : freshTemplates) {
            seedJobReferences = descriptor.getTemplateJobMap().get((Object)templateName);
            matching = Collections2.filter((Collection)seedJobReferences, (Predicate)new SeedNamePredicate(seedJobName));
            AbstractProject templateProject = this.getLookupStrategy().getItem((Item)seedJob, templateName, AbstractProject.class);
            String digest = Util.getDigestOf((InputStream)new FileInputStream(templateProject.getConfigFile().getFile()));
            if (matching.size() == 1) {
                SeedReference ref = (SeedReference)Iterables.get((Iterable)matching, (int)0);
                if (!digest.equals(ref.getDigest())) continue;
                ref.setDigest(digest);
                descriptorMutated = true;
                continue;
            }
            if (matching.size() > 1) {
                seedJobReferences.removeAll(matching);
            }
            seedJobReferences.add(new SeedReference(templateName, seedJobName, digest));
            descriptorMutated = true;
        }
        if (descriptorMutated) {
            descriptor.save();
        }
        return freshTemplates;
    }

    private void updateGeneratedJobs(AbstractBuild<?, ?> build, BuildListener listener, Set<GeneratedJob> freshJobs) throws IOException, InterruptedException {
        Set generatedJobs = GeneratedObjectsAction.extractGeneratedObjects(build.getProject(), GeneratedJobsAction.class);
        Sets.SetView added = Sets.difference(freshJobs, generatedJobs);
        Sets.SetView existing = Sets.intersection(generatedJobs, freshJobs);
        Sets.SetView unreferenced = Sets.difference(generatedJobs, freshJobs);
        HashSet<GeneratedJob> removed = new HashSet<GeneratedJob>();
        HashSet<GeneratedJob> disabled = new HashSet<GeneratedJob>();
        ExecuteDslScripts.logItems(listener, "Added items", added);
        ExecuteDslScripts.logItems(listener, "Existing items", existing);
        ExecuteDslScripts.logItems(listener, "Unreferenced items", unreferenced);
        for (GeneratedJob unreferencedJob : unreferenced) {
            Item removedItem = this.getLookupStrategy().getItem((Item)build.getProject(), unreferencedJob.getJobName(), Item.class);
            if (removedItem == null || this.removedJobAction == RemovedJobAction.IGNORE) continue;
            if (this.removedJobAction == RemovedJobAction.DELETE) {
                removedItem.delete();
                removed.add(unreferencedJob);
                continue;
            }
            if (!(removedItem instanceof AbstractProject)) continue;
            ((AbstractProject)removedItem).disable();
            disabled.add(unreferencedJob);
        }
        ExecuteDslScripts.logItems(listener, "Disabled items", disabled);
        ExecuteDslScripts.logItems(listener, "Removed items", removed);
        this.updateGeneratedJobMap(build.getProject(), (Set<GeneratedJob>)Sets.union((Set)added, (Set)existing), (Set<GeneratedJob>)unreferenced);
    }

    private void updateGeneratedJobMap(AbstractProject<?, ?> seedJob, Set<GeneratedJob> createdOrUpdatedJobs, Set<GeneratedJob> removedJobs) throws IOException {
        DescriptorImpl descriptor = (DescriptorImpl)Jenkins.getInstance().getDescriptorByType(DescriptorImpl.class);
        boolean descriptorMutated = false;
        Map<String, SeedReference> generatedJobMap = descriptor.getGeneratedJobMap();
        for (GeneratedJob generatedJob : createdOrUpdatedJobs) {
            Item template;
            Item item = this.getLookupStrategy().getItem((Item)seedJob, generatedJob.getJobName(), Item.class);
            if (item == null) continue;
            SeedReference newSeedReference = new SeedReference(seedJob.getFullName());
            if (generatedJob.getTemplateName() != null && (template = this.getLookupStrategy().getItem((Item)seedJob, generatedJob.getTemplateName(), Item.class)) != null) {
                newSeedReference.setTemplateJobName(template.getFullName());
            }
            newSeedReference.setDigest(Util.getDigestOf((File)Items.getConfigFile((Item)item).getFile()));
            SeedReference oldSeedReference = generatedJobMap.get(item.getFullName());
            if (((Object)newSeedReference).equals(oldSeedReference)) continue;
            generatedJobMap.put(item.getFullName(), newSeedReference);
            descriptorMutated = true;
        }
        for (GeneratedJob removedJob : removedJobs) {
            Item removedItem = this.getLookupStrategy().getItem((Item)seedJob, removedJob.getJobName(), Item.class);
            if (removedItem == null) continue;
            generatedJobMap.remove(removedItem.getFullName());
            descriptorMutated = true;
        }
        if (descriptorMutated) {
            descriptor.save();
        }
    }

    private void updateGeneratedViews(AbstractBuild<?, ?> build, BuildListener listener, Set<GeneratedView> freshViews) throws IOException {
        Set generatedViews = GeneratedObjectsAction.extractGeneratedObjects(build.getProject(), GeneratedViewsAction.class);
        Sets.SetView added = Sets.difference(freshViews, generatedViews);
        Sets.SetView existing = Sets.intersection(generatedViews, freshViews);
        Sets.SetView unreferenced = Sets.difference(generatedViews, freshViews);
        HashSet<GeneratedView> removed = new HashSet<GeneratedView>();
        ExecuteDslScripts.logItems(listener, "Added views", added);
        ExecuteDslScripts.logItems(listener, "Existing views", existing);
        ExecuteDslScripts.logItems(listener, "Unreferenced views", unreferenced);
        if (this.removedViewAction == RemovedViewAction.DELETE) {
            for (GeneratedView unreferencedView : unreferenced) {
                String viewName = unreferencedView.getName();
                ItemGroup parent = this.getLookupStrategy().getParent((Item)build.getProject(), viewName);
                if (parent instanceof ViewGroup) {
                    View view = ((ViewGroup)parent).getView(FilenameUtils.getName((String)viewName));
                    if (view == null) continue;
                    ((ViewGroup)parent).deleteView(view);
                    removed.add(unreferencedView);
                    continue;
                }
                if (parent == null) {
                    LOGGER.log(Level.FINE, "Parent ViewGroup seems to have been already deleted");
                    continue;
                }
                LOGGER.log(Level.WARNING, String.format("Could not delete view within %s", parent.getClass()));
            }
        }
        ExecuteDslScripts.logItems(listener, "Removed views", removed);
    }

    private void updateGeneratedConfigFiles(AbstractBuild<?, ?> build, BuildListener listener, Set<GeneratedConfigFile> freshConfigFiles) {
        Set generatedConfigFiles = GeneratedObjectsAction.extractGeneratedObjects(build.getProject(), GeneratedConfigFilesAction.class);
        Sets.SetView added = Sets.difference(freshConfigFiles, generatedConfigFiles);
        Sets.SetView existing = Sets.intersection(generatedConfigFiles, freshConfigFiles);
        Sets.SetView unreferenced = Sets.difference(generatedConfigFiles, freshConfigFiles);
        ExecuteDslScripts.logItems(listener, "Added config files", added);
        ExecuteDslScripts.logItems(listener, "Existing config files", existing);
        ExecuteDslScripts.logItems(listener, "Unreferenced config files", unreferenced);
    }

    private void updateGeneratedUserContents(AbstractBuild<?, ?> build, BuildListener listener, Set<GeneratedUserContent> freshUserContents) {
        Set generatedUserContents = GeneratedObjectsAction.extractGeneratedObjects(build.getProject(), GeneratedUserContentsAction.class);
        Sets.SetView added = Sets.difference(freshUserContents, generatedUserContents);
        Sets.SetView existing = Sets.intersection(generatedUserContents, freshUserContents);
        Sets.SetView unreferenced = Sets.difference(generatedUserContents, freshUserContents);
        ExecuteDslScripts.logItems(listener, "Adding user content", added);
        ExecuteDslScripts.logItems(listener, "Existing user content", existing);
        ExecuteDslScripts.logItems(listener, "Unreferenced user content", unreferenced);
    }

    private static void logItems(BuildListener listener, String message, Collection<?> collection) {
        if (!collection.isEmpty()) {
            listener.getLogger().println(message + ":");
            for (Object item : collection) {
                listener.getLogger().println("    " + item.toString());
            }
        }
    }

    private static Set<String> getTemplates(Collection<GeneratedJob> jobs) {
        Collection templateNames = Collections2.transform(jobs, (Function)new Function<GeneratedJob, String>(){

            public String apply(GeneratedJob input) {
                return input.getTemplateName();
            }
        });
        return new LinkedHashSet<String>(Collections2.filter((Collection)templateNames, (Predicate)Predicates.notNull()));
    }

    private static class SeedNamePredicate
    implements Predicate<SeedReference> {
        private final String seedJobName;

        public SeedNamePredicate(String seedJobName) {
            this.seedJobName = seedJobName;
        }

        public boolean apply(SeedReference input) {
            return this.seedJobName.equals(input.getSeedJobName());
        }
    }

    public static class ScriptLocation {
        private final boolean usingScriptText;
        private final String targets;
        private final String scriptText;

        @DataBoundConstructor
        public ScriptLocation(String value, String targets, String scriptText) {
            this.usingScriptText = value == null || Boolean.parseBoolean(value);
            this.targets = Util.fixEmptyAndTrim((String)targets);
            this.scriptText = Util.fixEmptyAndTrim((String)scriptText);
        }
    }
}

