/*
 * Decompiled with CFR 0.152.
 */
package javaposse.jobdsl.plugin;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javaposse.jobdsl.dsl.helpers.ExtensibleContext;
import javaposse.jobdsl.plugin.ContextExtensionPoint;
import javaposse.jobdsl.plugin.DslEnvironment;
import javaposse.jobdsl.plugin.DslExtensionMethod;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;

class ExtensionPointHelper {
    ExtensionPointHelper() {
    }

    static Set<ExtensionPointMethod> findExtensionPoints(String name, Class<? extends ExtensibleContext> contextType, Object ... args) {
        Class[] parameterTypes = ClassUtils.toClass((Object[])args);
        HashSet<ExtensionPointMethod> candidates = new HashSet<ExtensionPointMethod>();
        for (ExtensionPointMethod candidate : ExtensionPointHelper.findCandidateMethods(name, contextType)) {
            if (!ClassUtils.isAssignable((Class[])parameterTypes, (Class[])candidate.getFilteredParameterTypes(), (boolean)true)) continue;
            candidates.add(candidate);
        }
        return candidates;
    }

    private static List<ExtensionPointMethod> findCandidateMethods(String name, Class<? extends ExtensibleContext> contextType) {
        ArrayList<ExtensionPointMethod> result = new ArrayList<ExtensionPointMethod>();
        for (ContextExtensionPoint extensionPoint : ContextExtensionPoint.all()) {
            for (Method method : extensionPoint.getClass().getMethods()) {
                DslExtensionMethod annotation;
                if (!method.getName().equals(name) || (annotation = method.getAnnotation(DslExtensionMethod.class)) == null || !annotation.context().isAssignableFrom(contextType)) continue;
                result.add(new ExtensionPointMethod(extensionPoint, method));
            }
        }
        return result;
    }

    static class ExtensionPointMethod {
        private final ContextExtensionPoint extensionPoint;
        private final Method method;

        ExtensionPointMethod(ContextExtensionPoint extensionPoint, Method method) {
            this.extensionPoint = extensionPoint;
            this.method = method;
        }

        public Class<?>[] getFilteredParameterTypes() {
            ArrayList result = new ArrayList();
            for (Class<?> parameterType : this.method.getParameterTypes()) {
                if (DslEnvironment.class.isAssignableFrom(parameterType)) continue;
                result.add(parameterType);
            }
            return result.toArray(new Class[result.size()]);
        }

        public String toString() {
            return this.extensionPoint.getClass() + "." + this.method.getName() + "(" + StringUtils.join((Collection)ClassUtils.convertClassesToClassNames(Arrays.asList(this.method.getParameterTypes())), (String)", ") + ")";
        }

        public Object call(DslEnvironment environment, Object[] args) throws InvocationTargetException, IllegalAccessException {
            Class<?>[] parameterTypes = this.method.getParameterTypes();
            Object[] processedArgs = new Object[parameterTypes.length];
            int j = 0;
            for (int i = 0; i < parameterTypes.length; ++i) {
                processedArgs[i] = DslEnvironment.class.isAssignableFrom(parameterTypes[i]) ? environment : args[j++];
            }
            return this.method.invoke((Object)this.extensionPoint, processedArgs);
        }
    }
}

