/*
 * Decompiled with CFR 0.152.
 */
package javaposse.jobdsl.plugin;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import groovy.util.Node;
import groovy.util.XmlParser;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Plugin;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.security.ACL;
import hudson.slaves.Cloud;
import hudson.util.VersionNumber;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javaposse.jobdsl.dsl.AbstractJobManagement;
import javaposse.jobdsl.dsl.ConfigFile;
import javaposse.jobdsl.dsl.ConfigFileType;
import javaposse.jobdsl.dsl.DslException;
import javaposse.jobdsl.dsl.DslScriptException;
import javaposse.jobdsl.dsl.Item;
import javaposse.jobdsl.dsl.JobConfigurationNotFoundException;
import javaposse.jobdsl.dsl.NameNotProvidedException;
import javaposse.jobdsl.dsl.UserContent;
import javaposse.jobdsl.dsl.helpers.ExtensibleContext;
import javaposse.jobdsl.plugin.ConfigFileProviderHelper;
import javaposse.jobdsl.plugin.ContextExtensionPoint;
import javaposse.jobdsl.plugin.DslEnvironment;
import javaposse.jobdsl.plugin.DslEnvironmentImpl;
import javaposse.jobdsl.plugin.ExtensionPointHelper;
import javaposse.jobdsl.plugin.LookupStrategy;
import javaposse.jobdsl.plugin.Messages;
import javaposse.jobdsl.plugin.PermissionsHelper;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import jenkins.model.DirectlyModifiableTopLevelItemGroup;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import org.apache.commons.io.FilenameUtils;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.vSphereCloud;

public final class JenkinsJobManagement
extends AbstractJobManagement {
    private static final Logger LOGGER = Logger.getLogger(JenkinsJobManagement.class.getName());
    private final EnvVars envVars;
    private final AbstractBuild<?, ?> build;
    private final LookupStrategy lookupStrategy;
    private final Map<Item, DslEnvironment> environments = new HashMap<Item, DslEnvironment>();

    public JenkinsJobManagement(PrintStream outputLogger, EnvVars envVars, AbstractBuild<?, ?> build, LookupStrategy lookupStrategy) {
        super(outputLogger);
        this.envVars = envVars;
        this.build = build;
        this.lookupStrategy = lookupStrategy;
    }

    public JenkinsJobManagement(PrintStream outputLogger, EnvVars envVars, AbstractBuild<?, ?> build) {
        this(outputLogger, envVars, build, LookupStrategy.JENKINS_ROOT);
    }

    public String getConfig(String path) throws JobConfigurationNotFoundException {
        String xml;
        LOGGER.log(Level.INFO, String.format("Getting config for Job %s", path));
        if (path.isEmpty()) {
            throw new JobConfigurationNotFoundException(path);
        }
        try {
            xml = this.lookupJob(path);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, String.format("Named Job Config not found: %s", path));
            throw new JobConfigurationNotFoundException(path);
        }
        LOGGER.log(Level.FINE, String.format("Job config %s", xml));
        return xml;
    }

    public boolean createOrUpdateConfig(Item dslItem, boolean ignoreExisting) throws NameNotProvidedException {
        String path = dslItem.getName();
        String config = dslItem.getXml();
        LOGGER.log(Level.INFO, String.format("createOrUpdateConfig for %s", path));
        boolean created = false;
        JenkinsJobManagement.validateUpdateArgs((String)path, (String)config);
        AbstractItem item = this.lookupStrategy.getItem((hudson.model.Item)this.build.getProject(), path, AbstractItem.class);
        String jobName = FilenameUtils.getName((String)path);
        Jenkins.checkGoodName((String)jobName);
        if (item == null) {
            created = this.createNewItem(path, dslItem);
        } else if (!ignoreExisting) {
            created = this.updateExistingItem(item, dslItem);
        }
        return created;
    }

    public void createOrUpdateView(String path, String config, boolean ignoreExisting) {
        JenkinsJobManagement.validateUpdateArgs((String)path, (String)config);
        String viewBaseName = FilenameUtils.getName((String)path);
        Jenkins.checkGoodName((String)viewBaseName);
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(config.getBytes("UTF-8"));
            ItemGroup parent = this.lookupStrategy.getParent((hudson.model.Item)this.build.getProject(), path);
            if (parent instanceof ViewGroup) {
                View view = ((ViewGroup)parent).getView(viewBaseName);
                if (view == null) {
                    if (parent instanceof Jenkins) {
                        ((Jenkins)parent).addView(View.createViewFromXML((String)viewBaseName, (InputStream)inputStream));
                    } else if (parent instanceof Folder) {
                        ((Folder)parent).addView(View.createViewFromXML((String)viewBaseName, (InputStream)inputStream));
                    } else {
                        LOGGER.log(Level.WARNING, String.format("Could not create view within %s", parent.getClass()));
                    }
                } else if (!ignoreExisting) {
                    view.updateByXml((Source)new StreamSource(inputStream));
                }
            } else {
                if (parent == null) {
                    throw new DslException(String.format(Messages.CreateView_UnknownParent(), path));
                }
                LOGGER.log(Level.WARNING, String.format("Could not create view within %s", parent.getClass()));
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.WARNING, "Unsupported encoding used in config. Should be UTF-8.");
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.log(Level.WARNING, String.format("Error writing config for new view %s.", path), e);
        }
    }

    public String createOrUpdateConfigFile(ConfigFile configFile, boolean ignoreExisting) {
        JenkinsJobManagement.validateNameArg((String)configFile.getName());
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins.getPlugin("config-file-provider") == null) {
            throw new DslException(Messages.CreateOrUpdateConfigFile_PluginNotInstalled());
        }
        ConfigProvider configProvider = ConfigFileProviderHelper.findConfigProvider(configFile.getType());
        if (configProvider == null) {
            throw new DslException(String.format(Messages.CreateOrUpdateConfigFile_ConfigProviderNotFound(), configFile.getClass()));
        }
        Config config = ConfigFileProviderHelper.findConfig(configProvider, configFile.getName());
        if (config == null) {
            config = configProvider.newConfig();
        } else if (ignoreExisting) {
            return config.id;
        }
        config = ConfigFileProviderHelper.createNewConfig(config, configFile);
        if (config == null) {
            throw new DslException(String.format(Messages.CreateOrUpdateConfigFile_UnknownConfigFileType(), configFile.getClass()));
        }
        configProvider.save(config);
        return config.id;
    }

    public void createOrUpdateUserContent(UserContent userContent, boolean ignoreExisting) {
        try {
            FilePath file = Jenkins.getInstance().getRootPath().child("userContent").child(userContent.getPath());
            if (!file.exists() || !ignoreExisting) {
                file.getParent().mkdirs();
                file.copyFrom(userContent.getContent());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DslException(String.format(Messages.CreateOrUpdateUserContent_Exception(), userContent.getPath(), e.getMessage()));
        }
    }

    public Map<String, String> getParameters() {
        return this.envVars;
    }

    @Deprecated
    public String getCredentialsId(String credentialsDescription) {
        Jenkins jenkins = Jenkins.getInstance();
        Plugin credentialsPlugin = jenkins.getPlugin("credentials");
        if (credentialsPlugin != null && !credentialsPlugin.getWrapper().getVersionNumber().isOlderThan(new VersionNumber("1.6"))) {
            for (CredentialsProvider credentialsProvider : jenkins.getExtensionList(CredentialsProvider.class)) {
                for (StandardCredentials credentials : credentialsProvider.getCredentials(StandardCredentials.class, (ItemGroup)jenkins, ACL.SYSTEM)) {
                    if (!credentials.getId().equals(credentialsDescription)) continue;
                    return credentials.getId();
                }
            }
        }
        return null;
    }

    public void queueJob(String path) throws NameNotProvidedException {
        JenkinsJobManagement.validateNameArg((String)path);
        BuildableItem project = this.lookupStrategy.getItem((hudson.model.Item)this.build.getParent(), path, BuildableItem.class);
        LOGGER.log(Level.INFO, String.format("Scheduling build of %s from %s", path, ((AbstractProject)this.build.getParent()).getName()));
        project.scheduleBuild((Cause)new Cause.UpstreamCause(this.build));
    }

    public InputStream streamFileInWorkspace(String relLocation) throws IOException, InterruptedException {
        FilePath filePath = this.locateValidFileInWorkspace(this.build.getWorkspace(), relLocation);
        return filePath.read();
    }

    public String readFileInWorkspace(String relLocation) throws IOException, InterruptedException {
        FilePath filePath = this.locateValidFileInWorkspace(this.build.getWorkspace(), relLocation);
        return filePath.readToString();
    }

    public String readFileInWorkspace(String jobName, String relLocation) throws IOException, InterruptedException {
        hudson.model.Item item = Jenkins.getInstance().getItemByFullName(jobName);
        if (item instanceof AbstractProject) {
            FilePath workspace = ((AbstractProject)item).getSomeWorkspace();
            if (workspace != null) {
                try {
                    return this.locateValidFileInWorkspace(workspace, relLocation).readToString();
                }
                catch (DslScriptException e) {
                    this.logWarning(String.format(Messages.ReadFileFromWorkspace_JobFileNotFound(), relLocation, jobName));
                }
            } else {
                this.logWarning(String.format(Messages.ReadFileFromWorkspace_WorkspaceNotFound(), relLocation, jobName));
            }
        } else {
            this.logWarning(String.format(Messages.ReadFileFromWorkspace_JobNotFound(), relLocation, jobName));
        }
        return null;
    }

    public void logPluginDeprecationWarning(String pluginShortName, String minimumVersion) {
        Plugin plugin = Jenkins.getInstance().getPlugin(pluginShortName);
        if (plugin != null && plugin.getWrapper().getVersionNumber().isOlderThan(new VersionNumber(minimumVersion))) {
            this.logDeprecationWarning("support for " + plugin.getWrapper().getDisplayName() + " versions older than " + minimumVersion);
        }
    }

    public void requirePlugin(String pluginShortName) {
        Plugin plugin = Jenkins.getInstance().getPlugin(pluginShortName);
        if (plugin == null) {
            this.markBuildAsUnstable("plugin '" + pluginShortName + "' needs to be installed");
        }
    }

    public void requireMinimumPluginVersion(String pluginShortName, String version) {
        Plugin plugin = Jenkins.getInstance().getPlugin(pluginShortName);
        if (plugin == null) {
            this.markBuildAsUnstable("version " + version + " or later of plugin '" + pluginShortName + "' needs to be installed");
        } else if (plugin.getWrapper().getVersionNumber().isOlderThan(new VersionNumber(version))) {
            this.markBuildAsUnstable("plugin '" + pluginShortName + "' needs to be updated to version " + version + " or later");
        }
    }

    public void requireMinimumCoreVersion(String version) {
        if (Jenkins.getVersion().isOlderThan(new VersionNumber(version))) {
            this.markBuildAsUnstable("Jenkins needs to be updated to version " + version + " or later");
        }
    }

    public VersionNumber getPluginVersion(String pluginShortName) {
        Plugin plugin = Jenkins.getInstance().getPlugin(pluginShortName);
        return plugin == null ? null : plugin.getWrapper().getVersionNumber();
    }

    public VersionNumber getJenkinsVersion() {
        return Jenkins.getVersion();
    }

    public Integer getVSphereCloudHash(String name) {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins.getPlugin("vsphere-cloud") != null) {
            for (Cloud cloud : jenkins.clouds) {
                if (!(cloud instanceof vSphereCloud) || !((vSphereCloud)cloud).getVsDescription().equals(name)) continue;
                return ((vSphereCloud)cloud).getHash();
            }
        }
        return null;
    }

    public String getConfigFileId(ConfigFileType type, String name) {
        Config config;
        ConfigProvider configProvider;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins.getPlugin("config-file-provider") != null && (configProvider = ConfigFileProviderHelper.findConfigProvider(type)) != null && (config = ConfigFileProviderHelper.findConfig(configProvider, name)) != null) {
            return config.id;
        }
        return null;
    }

    public void renameJobMatching(final String previousNames, String destination) throws IOException {
        final ItemGroup context = this.lookupStrategy.getContext((hudson.model.Item)this.build.getProject());
        List items = Jenkins.getInstance().getAllItems(Job.class);
        Collection matchingJobs = Collections2.filter((Collection)items, (Predicate)new Predicate<Job>(){

            public boolean apply(Job topLevelItem) {
                return topLevelItem.getRelativeNameFrom(context).matches(previousNames);
            }
        });
        if (matchingJobs.size() == 1) {
            this.renameJob((Job)matchingJobs.iterator().next(), destination);
        } else if (matchingJobs.size() > 1) {
            throw new DslException(String.format(Messages.RenameJobMatching_MultipleJobsFound(), matchingJobs));
        }
    }

    public Set<String> getPermissions(String descriptorId) {
        return PermissionsHelper.getPermissions(descriptorId);
    }

    public Node callExtension(String name, Item item, Class<? extends ExtensibleContext> contextType, Object ... args) {
        Set<ExtensionPointHelper.ExtensionPointMethod> candidates = ExtensionPointHelper.findExtensionPoints(name, contextType, args);
        if (candidates.isEmpty()) {
            LOGGER.fine("Found no extension which provides method " + name + " with arguments " + Arrays.toString(args));
            return null;
        }
        if (candidates.size() > 1) {
            throw new DslException(String.format(Messages.CallExtension_MultipleCandidates(), name, Arrays.toString(args), Arrays.toString(candidates.toArray())));
        }
        try {
            Object result = ((ExtensionPointHelper.ExtensionPointMethod)Iterables.getOnlyElement(candidates)).call(this.getSession(item), args);
            return new XmlParser().parseText(Items.XSTREAM2.toXML(result));
        }
        catch (Exception e) {
            throw new RuntimeException("Error calling extension", e);
        }
    }

    private void markBuildAsUnstable(String message) {
        this.logWarning(message);
        this.build.setResult(Result.UNSTABLE);
    }

    private FilePath locateValidFileInWorkspace(FilePath workspace, String relLocation) throws IOException, InterruptedException {
        FilePath filePath = workspace.child(relLocation);
        if (!filePath.exists()) {
            throw new DslScriptException(String.format("File %s does not exist in workspace", relLocation));
        }
        return filePath;
    }

    private String lookupJob(String path) throws IOException {
        LOGGER.log(Level.FINE, String.format("Looking up item %s", path));
        AbstractItem item = this.lookupStrategy.getItem((hudson.model.Item)this.build.getProject(), path, AbstractItem.class);
        if (item != null) {
            XmlFile xmlFile = item.getConfigFile();
            String jobXml = xmlFile.asString();
            LOGGER.log(Level.FINE, String.format("Looked up item with config %s", jobXml));
            return jobXml;
        }
        LOGGER.log(Level.WARNING, String.format("No item called %s could be found.", path));
        throw new IOException(String.format("No item called %s could be found.", path));
    }

    private boolean updateExistingItem(AbstractItem item, Item dslItem) {
        boolean created;
        String config = dslItem.getXml();
        try {
            String oldJob = item.getConfigFile().asString();
            Diff diff = XMLUnit.compareXML((String)oldJob, (String)config);
            if (diff.identical()) {
                LOGGER.log(Level.FINE, String.format("Item %s is identical", item.getName()));
                this.notifyItemUpdated((hudson.model.Item)item, dslItem);
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.warning(e.getMessage());
        }
        this.checkItemType(item, dslItem);
        LOGGER.log(Level.FINE, String.format("Updating item %s as %s", item.getName(), config));
        StreamSource streamSource = new StreamSource(new StringReader(config));
        try {
            item.updateByXml((Source)streamSource);
            this.notifyItemUpdated((hudson.model.Item)item, dslItem);
            created = true;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error writing updated item to file.", e);
            created = false;
        }
        return created;
    }

    private void checkItemType(AbstractItem item, Item dslItem) {
        Node oldConfig;
        try {
            oldConfig = new XmlParser().parse(item.getConfigFile().getFile());
        }
        catch (Exception e) {
            throw new DslException(String.format(Messages.UpdateExistingItem_CouldNotReadConfig(), item.getConfigFile().getFile().getAbsolutePath(), item.getFullName()), (Throwable)e);
        }
        if (!oldConfig.name().equals(dslItem.getNode().name())) {
            throw new DslException(String.format(Messages.UpdateExistingItem_ItemTypeDoesNotMatch(), item.getFullName()));
        }
    }

    private boolean createNewItem(String path, Item dslItem) {
        String config = dslItem.getXml();
        LOGGER.log(Level.FINE, String.format("Creating item as %s", config));
        boolean created = false;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes("UTF-8"));
            ItemGroup parent = this.lookupStrategy.getParent((hudson.model.Item)this.build.getProject(), path);
            String itemName = FilenameUtils.getName((String)path);
            if (parent instanceof ModifiableTopLevelItemGroup) {
                TopLevelItem project = ((ModifiableTopLevelItemGroup)parent).createProjectFromXML(itemName, (InputStream)is);
                this.notifyItemCreated((hudson.model.Item)project, dslItem);
                created = true;
            } else {
                if (parent == null) {
                    throw new DslException(String.format(Messages.CreateItem_UnknownParent(), path));
                }
                LOGGER.log(Level.WARNING, String.format("Could not create item within %s", parent.getClass()));
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.WARNING, "Unsupported encoding used in config. Should be UTF-8.");
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, String.format("Error writing config for new item %s.", path), e);
        }
        return created;
    }

    private void notifyItemCreated(hudson.model.Item item, Item dslItem) {
        DslEnvironment session = this.getSession(dslItem);
        for (ContextExtensionPoint extensionPoint : ContextExtensionPoint.all()) {
            extensionPoint.notifyItemCreated(item, session);
        }
    }

    private void notifyItemUpdated(hudson.model.Item item, Item dslItem) {
        DslEnvironment session = this.getSession(dslItem);
        for (ContextExtensionPoint extensionPoint : ContextExtensionPoint.all()) {
            extensionPoint.notifyItemUpdated(item, session);
        }
    }

    private DslEnvironment getSession(Item item) {
        DslEnvironment session = this.environments.get(item);
        if (session == null) {
            session = new DslEnvironmentImpl();
            this.environments.put(item, session);
        }
        return session;
    }

    private void renameJob(Job from, String to) throws IOException {
        LOGGER.info(String.format("Renaming job %s to %s", from.getFullName(), to));
        ItemGroup fromParent = from.getParent();
        ItemGroup toParent = this.lookupStrategy.getParent((hudson.model.Item)this.build.getProject(), to);
        if (toParent == null) {
            throw new DslException(String.format(Messages.RenameJobMatching_UnknownParent(), from.getFullName(), to));
        }
        if (fromParent != toParent) {
            LOGGER.info(String.format("Moving Job %s to folder %s", fromParent.getFullName(), toParent.getFullName()));
            if (toParent instanceof DirectlyModifiableTopLevelItemGroup) {
                DirectlyModifiableTopLevelItemGroup itemGroup = (DirectlyModifiableTopLevelItemGroup)toParent;
                JenkinsJobManagement.move((hudson.model.Item)from, itemGroup);
            } else {
                throw new DslException(String.format(Messages.RenameJobMatching_DestinationNotFolder(), from.getFullName(), toParent.getFullName()));
            }
        }
        from.renameTo(FilenameUtils.getName((String)to));
    }

    private static <I extends AbstractItem> I move(hudson.model.Item item, DirectlyModifiableTopLevelItemGroup destination) throws IOException {
        return (I)Items.move((AbstractItem)((AbstractItem)item), (DirectlyModifiableTopLevelItemGroup)destination);
    }
}

