/*
 * Decompiled with CFR 0.152.
 */
package javaposse.jobdsl.plugin;

import com.cloudbees.hudson.plugins.folder.Folder;
import hudson.model.Item;
import hudson.model.ItemGroup;
import jenkins.model.Jenkins;

public enum LookupStrategy {
    JENKINS_ROOT("Jenkins Root"){

        @Override
        public <T extends Item> T getItem(Item seedJob, String path, Class<T> type) {
            return (T)Jenkins.getInstance().getItemByFullName(path, type);
        }

        @Override
        protected ItemGroup getContext(Item seedJob) {
            return Jenkins.getInstance();
        }
    }
    ,
    SEED_JOB("Seed Job"){

        @Override
        public <T extends Item> T getItem(Item seedJob, String path, Class<T> type) {
            return (T)Jenkins.getInstance().getItem(path, seedJob.getParent(), type);
        }

        @Override
        protected ItemGroup getContext(Item seedJob) {
            return seedJob.getParent();
        }
    };

    private final String displayName;

    private LookupStrategy(String displayName) {
        this.displayName = displayName;
    }

    public abstract <T extends Item> T getItem(Item var1, String var2, Class<T> var3);

    protected abstract ItemGroup getContext(Item var1);

    public ItemGroup getParent(Item seedJob, String path) {
        Jenkins jenkins = Jenkins.getInstance();
        int i = path.lastIndexOf(47);
        switch (i) {
            case -1: {
                return this.getContext(seedJob);
            }
            case 0: {
                return jenkins;
            }
        }
        return (ItemGroup)jenkins.getItem(path.substring(0, i), this.getContext(seedJob), Folder.class);
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

