/*
 * Decompiled with CFR 0.152.
 */
package javaposse.jobdsl.plugin.actions;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import java.util.LinkedHashSet;
import java.util.Set;
import javaposse.jobdsl.plugin.actions.GeneratedObjectsBuildAction;

public abstract class GeneratedObjectsAction<T, B extends GeneratedObjectsBuildAction<T>>
implements Action {
    protected final AbstractProject<?, ?> project;
    private final Class<B> buildActionClass;

    public GeneratedObjectsAction(AbstractProject<?, ?> project, Class<B> buildActionClass) {
        this.project = project;
        this.buildActionClass = buildActionClass;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }

    public Set<T> findLastGeneratedObjects() {
        for (AbstractBuild b = this.project.getLastBuild(); b != null; b = b.getPreviousBuild()) {
            GeneratedObjectsBuildAction action = (GeneratedObjectsBuildAction)b.getAction(this.buildActionClass);
            if (action == null || action.getModifiedObjects() == null) continue;
            return new LinkedHashSet(action.getModifiedObjects());
        }
        return new LinkedHashSet();
    }

    public Set<T> findAllGeneratedObjects() {
        LinkedHashSet result = new LinkedHashSet();
        for (AbstractBuild build : this.project.getBuilds()) {
            GeneratedObjectsBuildAction action = (GeneratedObjectsBuildAction)build.getAction(this.buildActionClass);
            if (action == null || action.getModifiedObjects() == null) continue;
            result.addAll(action.getModifiedObjects());
        }
        return result;
    }

    public static <T, A extends GeneratedObjectsAction<T, ?>> Set<T> extractGeneratedObjects(AbstractProject<?, ?> project, Class<A> actionType) {
        GeneratedObjectsAction action = (GeneratedObjectsAction)project.getAction(actionType);
        return action == null ? new LinkedHashSet() : action.findLastGeneratedObjects();
    }
}

