/*
 * Decompiled with CFR 0.152.
 */
package javaposse.jobdsl.plugin.actions;

import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.View;
import hudson.model.ViewGroup;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javaposse.jobdsl.dsl.GeneratedView;
import javaposse.jobdsl.plugin.LookupStrategy;
import javaposse.jobdsl.plugin.actions.GeneratedObjectsBuildRunAction;
import org.apache.commons.io.FilenameUtils;

public class GeneratedViewsBuildAction
extends GeneratedObjectsBuildRunAction<GeneratedView> {
    private transient Set<GeneratedView> modifiedViews;
    private LookupStrategy lookupStrategy = LookupStrategy.JENKINS_ROOT;

    public GeneratedViewsBuildAction(Collection<GeneratedView> modifiedViews, LookupStrategy lookupStrategy) {
        super(modifiedViews);
        this.lookupStrategy = lookupStrategy;
    }

    public LookupStrategy getLookupStrategy() {
        return this.lookupStrategy == null ? LookupStrategy.JENKINS_ROOT : this.lookupStrategy;
    }

    public Set<View> getViews() {
        LinkedHashSet<View> allGeneratedViews = new LinkedHashSet<View>();
        for (GeneratedView generatedView : this.getModifiedObjects()) {
            View view;
            ItemGroup itemGroup = this.getLookupStrategy().getParent((Item)this.owner.getProject(), generatedView.getName());
            if (!(itemGroup instanceof ViewGroup) || (view = ((ViewGroup)itemGroup).getView(FilenameUtils.getName((String)generatedView.getName()))) == null) continue;
            allGeneratedViews.add(view);
        }
        return allGeneratedViews;
    }

    private Object readResolve() {
        return this.modifiedViews == null ? this : new GeneratedViewsBuildAction(this.modifiedViews, this.lookupStrategy);
    }
}

