/*
 * Decompiled with CFR 0.152.
 */
package javaposse.jobdsl.plugin;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.ExtensionList;
import hudson.ExtensionListListener;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.tasks.Builder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javaposse.jobdsl.dsl.DslException;
import javaposse.jobdsl.dsl.GeneratedConfigFile;
import javaposse.jobdsl.dsl.GeneratedItems;
import javaposse.jobdsl.dsl.GeneratedJob;
import javaposse.jobdsl.dsl.GeneratedUserContent;
import javaposse.jobdsl.dsl.GeneratedView;
import javaposse.jobdsl.dsl.JobManagement;
import javaposse.jobdsl.dsl.ScriptRequest;
import javaposse.jobdsl.plugin.DescriptorImpl;
import javaposse.jobdsl.plugin.InterruptibleJobManagement;
import javaposse.jobdsl.plugin.JenkinsDslScriptLoader;
import javaposse.jobdsl.plugin.JenkinsJobManagement;
import javaposse.jobdsl.plugin.LookupStrategy;
import javaposse.jobdsl.plugin.Messages;
import javaposse.jobdsl.plugin.RemovedConfigFilesAction;
import javaposse.jobdsl.plugin.RemovedJobAction;
import javaposse.jobdsl.plugin.RemovedViewAction;
import javaposse.jobdsl.plugin.SandboxDslScriptLoader;
import javaposse.jobdsl.plugin.ScriptApprovalDslScriptLoader;
import javaposse.jobdsl.plugin.ScriptRequestGenerator;
import javaposse.jobdsl.plugin.SeedReference;
import javaposse.jobdsl.plugin.actions.GeneratedConfigFilesAction;
import javaposse.jobdsl.plugin.actions.GeneratedConfigFilesBuildAction;
import javaposse.jobdsl.plugin.actions.GeneratedJobsAction;
import javaposse.jobdsl.plugin.actions.GeneratedJobsBuildAction;
import javaposse.jobdsl.plugin.actions.GeneratedObjectsAction;
import javaposse.jobdsl.plugin.actions.GeneratedObjectsRunAction;
import javaposse.jobdsl.plugin.actions.GeneratedUserContentsAction;
import javaposse.jobdsl.plugin.actions.GeneratedUserContentsBuildAction;
import javaposse.jobdsl.plugin.actions.GeneratedViewsAction;
import javaposse.jobdsl.plugin.actions.GeneratedViewsBuildAction;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.AccessDeniedException;
import org.apache.commons.io.FilenameUtils;
import org.jenkinsci.plugins.configfiles.GlobalConfigFiles;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.GroovyLanguage;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ExecuteDslScripts
extends Builder
implements SimpleBuildStep {
    private static final Logger LOGGER = Logger.getLogger(ExecuteDslScripts.class.getName());
    private static volatile boolean rebootRequired;
    private String targets;
    private String scriptText;
    private Boolean usingScriptText;
    private boolean sandbox;
    private boolean ignoreExisting;
    private boolean ignoreMissingFiles;
    private boolean failOnMissingPlugin;
    private boolean failOnSeedCollision;
    private boolean unstableOnDeprecation;
    private RemovedJobAction removedJobAction = RemovedJobAction.IGNORE;
    private RemovedViewAction removedViewAction = RemovedViewAction.IGNORE;
    private RemovedConfigFilesAction removedConfigFilesAction = RemovedConfigFilesAction.IGNORE;
    private LookupStrategy lookupStrategy = LookupStrategy.JENKINS_ROOT;
    private String additionalClasspath;
    private Map<String, Object> additionalParameters;

    @DataBoundConstructor
    public ExecuteDslScripts() {
    }

    ExecuteDslScripts(String scriptText) {
        this.usingScriptText = true;
        this.scriptText = scriptText;
        this.targets = null;
        this.ignoreExisting = false;
        this.failOnSeedCollision = false;
        this.removedJobAction = RemovedJobAction.DISABLE;
        this.additionalClasspath = null;
    }

    public String getTargets() {
        return !this.isUsingScriptText() ? this.targets : null;
    }

    @DataBoundSetter
    public void setTargets(String targets) {
        this.targets = Util.fixEmptyAndTrim((String)targets);
    }

    public String getScriptText() {
        return this.isUsingScriptText() ? this.scriptText : null;
    }

    @DataBoundSetter
    public void setScriptText(String scriptText) {
        this.scriptText = Util.fixEmptyAndTrim((String)scriptText);
    }

    public boolean isUsingScriptText() {
        return this.usingScriptText == null ? this.targets == null : this.usingScriptText;
    }

    public Boolean getUseScriptText() {
        return null;
    }

    @DataBoundSetter
    public void setUseScriptText(Boolean value) {
        this.usingScriptText = value;
    }

    public boolean isSandbox() {
        return this.sandbox;
    }

    @DataBoundSetter
    public void setSandbox(boolean sandbox) {
        this.sandbox = sandbox;
    }

    public boolean isIgnoreMissingFiles() {
        return !this.isUsingScriptText() && this.ignoreMissingFiles;
    }

    @DataBoundSetter
    public void setIgnoreMissingFiles(boolean ignoreMissingFiles) {
        this.ignoreMissingFiles = ignoreMissingFiles;
    }

    public boolean isIgnoreExisting() {
        return this.ignoreExisting;
    }

    @DataBoundSetter
    public void setIgnoreExisting(boolean ignoreExisting) {
        this.ignoreExisting = ignoreExisting;
    }

    public boolean isFailOnMissingPlugin() {
        return this.failOnMissingPlugin;
    }

    @DataBoundSetter
    public void setFailOnMissingPlugin(boolean failOnMissingPlugin) {
        this.failOnMissingPlugin = failOnMissingPlugin;
    }

    public boolean isFailOnSeedCollision() {
        return this.failOnSeedCollision;
    }

    @DataBoundSetter
    public void setFailOnSeedCollision(boolean failOnSeedCollision) {
        this.failOnSeedCollision = failOnSeedCollision;
    }

    public boolean isUnstableOnDeprecation() {
        return this.unstableOnDeprecation;
    }

    @DataBoundSetter
    public void setUnstableOnDeprecation(boolean unstableOnDeprecation) {
        this.unstableOnDeprecation = unstableOnDeprecation;
    }

    public RemovedJobAction getRemovedJobAction() {
        return this.removedJobAction;
    }

    @DataBoundSetter
    public void setRemovedJobAction(RemovedJobAction removedJobAction) {
        this.removedJobAction = removedJobAction;
    }

    public RemovedViewAction getRemovedViewAction() {
        return this.removedViewAction;
    }

    @DataBoundSetter
    public void setRemovedViewAction(RemovedViewAction removedViewAction) {
        this.removedViewAction = removedViewAction;
    }

    public RemovedConfigFilesAction getRemovedConfigFilesAction() {
        return this.removedConfigFilesAction;
    }

    @DataBoundSetter
    public void setRemovedConfigFilesAction(RemovedConfigFilesAction removedConfigFilesAction) {
        this.removedConfigFilesAction = removedConfigFilesAction;
    }

    public LookupStrategy getLookupStrategy() {
        return this.lookupStrategy == null ? LookupStrategy.JENKINS_ROOT : this.lookupStrategy;
    }

    @DataBoundSetter
    public void setLookupStrategy(LookupStrategy lookupStrategy) {
        this.lookupStrategy = lookupStrategy;
    }

    public String getAdditionalClasspath() {
        return this.additionalClasspath;
    }

    @DataBoundSetter
    public void setAdditionalClasspath(String additionalClasspath) {
        this.additionalClasspath = Util.fixEmptyAndTrim((String)additionalClasspath);
    }

    public Map<String, Object> getAdditionalParameters() {
        return this.additionalParameters;
    }

    @DataBoundSetter
    public void setAdditionalParameters(Map<String, Object> additionalParameters) {
        this.additionalParameters = additionalParameters;
    }

    void configure(Item ancestor) {
        if (!this.sandbox && this.isUsingScriptText() && this.scriptText != null && ((DescriptorImpl)this.getDescriptor()).isSecurityEnabled()) {
            ScriptApproval.get().configuring(this.scriptText, GroovyLanguage.get(), ApprovalContext.create().withCurrentUser().withItem(ancestor));
        }
    }

    private Object readResolve() {
        this.configure(null);
        return this;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        try {
            EnvVars env = run.getEnvironment(listener);
            if (run instanceof AbstractBuild) {
                env.putAll(((AbstractBuild)run).getBuildVariables());
            }
            HashMap<String, Object> binding = new HashMap<String, Object>((Map<String, Object>)env);
            if (this.additionalParameters != null) {
                binding.putAll(this.additionalParameters);
            }
            JenkinsJobManagement jenkinsJobManagement = new JenkinsJobManagement(listener.getLogger(), binding, run, workspace, this.getLookupStrategy());
            jenkinsJobManagement.setFailOnMissingPlugin(this.failOnMissingPlugin);
            jenkinsJobManagement.setFailOnSeedCollision(this.failOnSeedCollision);
            jenkinsJobManagement.setUnstableOnDeprecation(this.unstableOnDeprecation);
            InterruptibleJobManagement jobManagement = new InterruptibleJobManagement((JobManagement)jenkinsJobManagement);
            if (rebootRequired) {
                listener.getLogger().println(Messages.RestartRequired());
            }
            try (ScriptRequestGenerator generator = new ScriptRequestGenerator(workspace, env);){
                Set<ScriptRequest> scriptRequests = generator.getScriptRequests(this.getTargets(), this.isUsingScriptText(), this.getScriptText(), this.ignoreExisting, this.isIgnoreMissingFiles(), this.additionalClasspath);
                JenkinsDslScriptLoader dslScriptLoader = ((DescriptorImpl)this.getDescriptor()).isSecurityEnabled() ? (this.sandbox ? new SandboxDslScriptLoader(jobManagement, (Item)run.getParent()) : new ScriptApprovalDslScriptLoader(jobManagement, (Item)run.getParent())) : new JenkinsDslScriptLoader(jobManagement);
                GeneratedItems generatedItems = dslScriptLoader.runScripts(scriptRequests);
                Set freshJobs = generatedItems.getJobs();
                Set freshViews = generatedItems.getViews();
                Set freshConfigFiles = generatedItems.getConfigFiles();
                Set freshUserContents = generatedItems.getUserContents();
                this.addJobAction(run, new GeneratedJobsBuildAction(freshJobs, this.getLookupStrategy()));
                this.addJobAction(run, new GeneratedViewsBuildAction(freshViews, this.getLookupStrategy()));
                this.addJobAction(run, new GeneratedConfigFilesBuildAction(freshConfigFiles));
                this.addJobAction(run, new GeneratedUserContentsBuildAction(freshUserContents));
                this.updateTemplates(run.getParent(), listener, new HashSet<GeneratedJob>(((GeneratedJobsBuildAction)run.getAction(GeneratedJobsBuildAction.class)).getModifiedObjects()));
                this.updateGeneratedJobs(run.getParent(), listener, new HashSet<GeneratedJob>(((GeneratedJobsBuildAction)run.getAction(GeneratedJobsBuildAction.class)).getModifiedObjects()));
                this.updateGeneratedViews(run.getParent(), listener, new HashSet<GeneratedView>(((GeneratedViewsBuildAction)run.getAction(GeneratedViewsBuildAction.class)).getModifiedObjects()));
                this.updateGeneratedConfigFiles(run.getParent(), listener, new HashSet<GeneratedConfigFile>(((GeneratedConfigFilesBuildAction)run.getAction(GeneratedConfigFilesBuildAction.class)).getModifiedObjects()));
                this.updateGeneratedUserContents(run.getParent(), listener, new HashSet<GeneratedUserContent>(((GeneratedUserContentsBuildAction)run.getAction(GeneratedUserContentsBuildAction.class)).getModifiedObjects()));
            }
        }
        catch (RuntimeException e) {
            if (!(e instanceof DslException) && !(e instanceof AccessDeniedException)) {
                e.printStackTrace(listener.getLogger());
            }
            LOGGER.log(Level.FINE, String.format("Exception while processing DSL scripts: %s", e.getMessage()), e);
            throw new AbortException(e.getMessage());
        }
    }

    private void addJobAction(Run run, GeneratedObjectsRunAction action) {
        GeneratedObjectsRunAction generatedJobsBuildAction = (GeneratedObjectsRunAction)run.getAction(action.getClass());
        if (generatedJobsBuildAction == null) {
            run.addAction((Action)action);
        } else {
            generatedJobsBuildAction.addModifiedObjects(action.getModifiedObjects());
        }
    }

    private Set<String> updateTemplates(Job seedJob, TaskListener listener, Set<GeneratedJob> freshJobs) throws IOException {
        Collection matching;
        Collection seedJobReferences;
        Set<String> freshTemplates = ExecuteDslScripts.getTemplates(freshJobs);
        Set<String> existingTemplates = ExecuteDslScripts.getTemplates(GeneratedObjectsAction.extractGeneratedObjects(seedJob, GeneratedJobsAction.class));
        Sets.SetView newTemplates = Sets.difference(freshTemplates, existingTemplates);
        Sets.SetView removedTemplates = Sets.difference(existingTemplates, freshTemplates);
        ExecuteDslScripts.logItems(listener, "Existing templates", existingTemplates);
        ExecuteDslScripts.logItems(listener, "New templates", newTemplates);
        ExecuteDslScripts.logItems(listener, "Unreferenced templates", removedTemplates);
        String seedJobName = seedJob.getName();
        DescriptorImpl descriptor = (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
        boolean descriptorMutated = false;
        for (String templateName : removedTemplates) {
            seedJobReferences = descriptor.getTemplateJobMap().get((Object)templateName);
            matching = Collections2.filter((Collection)seedJobReferences, (Predicate)new SeedNamePredicate(seedJobName));
            if (matching.isEmpty()) continue;
            seedJobReferences.removeAll(matching);
            descriptorMutated = true;
        }
        for (String templateName : freshTemplates) {
            seedJobReferences = descriptor.getTemplateJobMap().get((Object)templateName);
            matching = Collections2.filter((Collection)seedJobReferences, (Predicate)new SeedNamePredicate(seedJobName));
            AbstractItem templateProject = this.getLookupStrategy().getItem((Item)seedJob, templateName, AbstractItem.class);
            String digest = Util.getDigestOf((InputStream)new FileInputStream(templateProject.getConfigFile().getFile()));
            if (matching.size() == 1) {
                SeedReference ref = (SeedReference)Iterables.get((Iterable)matching, (int)0);
                if (!digest.equals(ref.getDigest())) continue;
                ref.setDigest(digest);
                descriptorMutated = true;
                continue;
            }
            if (matching.size() > 1) {
                seedJobReferences.removeAll(matching);
            }
            seedJobReferences.add(new SeedReference(templateName, seedJobName, digest));
            descriptorMutated = true;
        }
        if (descriptorMutated) {
            descriptor.save();
        }
        return freshTemplates;
    }

    private void updateGeneratedJobs(Job seedJob, TaskListener listener, Set<GeneratedJob> freshJobs) throws IOException, InterruptedException {
        Set generatedJobs = GeneratedObjectsAction.extractGeneratedObjects(seedJob, GeneratedJobsAction.class);
        Sets.SetView added = Sets.difference(freshJobs, generatedJobs);
        Sets.SetView existing = Sets.intersection(generatedJobs, freshJobs);
        Sets.SetView unreferenced = Sets.difference(generatedJobs, freshJobs);
        HashSet<GeneratedJob> removed = new HashSet<GeneratedJob>();
        HashSet<GeneratedJob> disabled = new HashSet<GeneratedJob>();
        ExecuteDslScripts.logItems(listener, "Added items", added);
        ExecuteDslScripts.logItems(listener, "Existing items", existing);
        ExecuteDslScripts.logItems(listener, "Unreferenced items", unreferenced);
        for (GeneratedJob unreferencedJob : unreferenced) {
            Item removedItem = this.getLookupStrategy().getItem((Item)seedJob, unreferencedJob.getJobName(), Item.class);
            if (removedItem == null || this.removedJobAction == RemovedJobAction.IGNORE) continue;
            if (this.removedJobAction == RemovedJobAction.DELETE) {
                removedItem.delete();
                removed.add(unreferencedJob);
                continue;
            }
            if (!(removedItem instanceof ParameterizedJobMixIn.ParameterizedJob)) continue;
            ParameterizedJobMixIn.ParameterizedJob project = (ParameterizedJobMixIn.ParameterizedJob)removedItem;
            project.checkPermission(Item.CONFIGURE);
            project.makeDisabled(true);
            disabled.add(unreferencedJob);
        }
        ExecuteDslScripts.logItems(listener, "Disabled items", disabled);
        ExecuteDslScripts.logItems(listener, "Removed items", removed);
        this.updateGeneratedJobMap(seedJob, (Set<GeneratedJob>)Sets.union((Set)added, (Set)existing), (Set<GeneratedJob>)unreferenced);
    }

    private void updateGeneratedJobMap(Job seedJob, Set<GeneratedJob> createdOrUpdatedJobs, Set<GeneratedJob> removedJobs) throws IOException {
        DescriptorImpl descriptor = (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
        boolean descriptorMutated = false;
        Map<String, SeedReference> generatedJobMap = descriptor.getGeneratedJobMap();
        for (GeneratedJob generatedJob : createdOrUpdatedJobs) {
            Item template;
            Item item = this.getLookupStrategy().getItem((Item)seedJob, generatedJob.getJobName(), Item.class);
            if (item == null) continue;
            SeedReference newSeedReference = new SeedReference(seedJob.getFullName());
            if (generatedJob.getTemplateName() != null && (template = this.getLookupStrategy().getItem((Item)seedJob, generatedJob.getTemplateName(), Item.class)) != null) {
                newSeedReference.setTemplateJobName(template.getFullName());
            }
            newSeedReference.setDigest(Util.getDigestOf((File)Items.getConfigFile((Item)item).getFile()));
            SeedReference oldSeedReference = generatedJobMap.get(item.getFullName());
            if (((Object)newSeedReference).equals(oldSeedReference)) continue;
            generatedJobMap.put(item.getFullName(), newSeedReference);
            descriptorMutated = true;
        }
        for (GeneratedJob removedJob : removedJobs) {
            Item removedItem = this.getLookupStrategy().getItem((Item)seedJob, removedJob.getJobName(), Item.class);
            if (removedItem == null) continue;
            generatedJobMap.remove(removedItem.getFullName());
            descriptorMutated = true;
        }
        if (descriptorMutated) {
            descriptor.save();
        }
    }

    private void updateGeneratedViews(Job seedJob, TaskListener listener, Set<GeneratedView> freshViews) throws IOException {
        Set generatedViews = GeneratedObjectsAction.extractGeneratedObjects(seedJob, GeneratedViewsAction.class);
        Sets.SetView added = Sets.difference(freshViews, generatedViews);
        Sets.SetView existing = Sets.intersection(generatedViews, freshViews);
        Sets.SetView unreferenced = Sets.difference(generatedViews, freshViews);
        HashSet<GeneratedView> removed = new HashSet<GeneratedView>();
        ExecuteDslScripts.logItems(listener, "Added views", added);
        ExecuteDslScripts.logItems(listener, "Existing views", existing);
        ExecuteDslScripts.logItems(listener, "Unreferenced views", unreferenced);
        if (this.removedViewAction == RemovedViewAction.DELETE) {
            for (GeneratedView unreferencedView : unreferenced) {
                String viewName = unreferencedView.getName();
                ItemGroup parent = this.getLookupStrategy().getParent((Item)seedJob, viewName);
                if (parent instanceof ViewGroup) {
                    View view = ((ViewGroup)parent).getView(FilenameUtils.getName((String)viewName));
                    if (view == null) continue;
                    view.checkPermission(View.DELETE);
                    ((ViewGroup)parent).deleteView(view);
                    removed.add(unreferencedView);
                    continue;
                }
                if (parent == null) {
                    LOGGER.log(Level.FINE, "Parent ViewGroup seems to have been already deleted");
                    continue;
                }
                LOGGER.log(Level.WARNING, String.format("Could not delete view within %s", parent.getClass()));
            }
        }
        ExecuteDslScripts.logItems(listener, "Removed views", removed);
    }

    private void updateGeneratedConfigFiles(Job seedJob, TaskListener listener, Set<GeneratedConfigFile> freshConfigFiles) {
        Set generatedConfigFiles = GeneratedObjectsAction.extractGeneratedObjects(seedJob, GeneratedConfigFilesAction.class);
        Sets.SetView added = Sets.difference(freshConfigFiles, generatedConfigFiles);
        Sets.SetView existing = Sets.intersection(generatedConfigFiles, freshConfigFiles);
        Sets.SetView unreferenced = Sets.difference(generatedConfigFiles, freshConfigFiles);
        ExecuteDslScripts.logItems(listener, "Added config files", added);
        ExecuteDslScripts.logItems(listener, "Existing config files", existing);
        ExecuteDslScripts.logItems(listener, "Unreferenced config files", unreferenced);
        if (this.removedConfigFilesAction == RemovedConfigFilesAction.DELETE && Jenkins.get().getPluginManager().getPlugin("config-file-provider") != null) {
            GlobalConfigFiles globalConfigFiles = GlobalConfigFiles.get();
            for (GeneratedConfigFile unreferencedConfigFile : unreferenced) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
                globalConfigFiles.remove(unreferencedConfigFile.getId());
            }
        }
    }

    private void updateGeneratedUserContents(Job seedJob, TaskListener listener, Set<GeneratedUserContent> freshUserContents) {
        Set generatedUserContents = GeneratedObjectsAction.extractGeneratedObjects(seedJob, GeneratedUserContentsAction.class);
        Sets.SetView added = Sets.difference(freshUserContents, generatedUserContents);
        Sets.SetView existing = Sets.intersection(generatedUserContents, freshUserContents);
        Sets.SetView unreferenced = Sets.difference(generatedUserContents, freshUserContents);
        ExecuteDslScripts.logItems(listener, "Adding user content", added);
        ExecuteDslScripts.logItems(listener, "Existing user content", existing);
        ExecuteDslScripts.logItems(listener, "Unreferenced user content", unreferenced);
    }

    private static void logItems(TaskListener listener, String message, Collection<?> collection) {
        if (!collection.isEmpty()) {
            listener.getLogger().println(message + ":");
            for (Object item : collection) {
                listener.getLogger().println("    " + item.toString());
            }
        }
    }

    private static Set<String> getTemplates(Collection<GeneratedJob> jobs) {
        Collection templateNames = Collections2.transform(jobs, GeneratedJob::getTemplateName);
        return new LinkedHashSet<String>(Collections2.filter((Collection)templateNames, (Predicate)Predicates.notNull()));
    }

    static {
        ExtensionList.lookup(Descriptor.class).addListener(new ExtensionListListener(){

            public void onChange() {
                rebootRequired = true;
            }
        });
    }

    private static class SeedNamePredicate
    implements Predicate<SeedReference> {
        private final String seedJobName;

        SeedNamePredicate(String seedJobName) {
            this.seedJobName = seedJobName;
        }

        public boolean apply(SeedReference input) {
            return this.seedJobName.equals(input.getSeedJobName());
        }
    }
}

