/*
 * Decompiled with CFR 0.152.
 */
package javaposse.jobdsl.plugin;

import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.thoughtworks.xstream.io.xml.XppDriver;
import groovy.util.Node;
import groovy.util.XmlParser;
import hudson.FilePath;
import hudson.Plugin;
import hudson.XmlFile;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.ModifiableViewGroup;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.slaves.Cloud;
import hudson.util.VersionNumber;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javaposse.jobdsl.dsl.AbstractJobManagement;
import javaposse.jobdsl.dsl.DslException;
import javaposse.jobdsl.dsl.DslScriptException;
import javaposse.jobdsl.dsl.ExtensibleContext;
import javaposse.jobdsl.dsl.Item;
import javaposse.jobdsl.dsl.JobConfigurationNotFoundException;
import javaposse.jobdsl.dsl.JobManagement;
import javaposse.jobdsl.dsl.NameNotProvidedException;
import javaposse.jobdsl.dsl.UserContent;
import javaposse.jobdsl.plugin.ContextExtensionPoint;
import javaposse.jobdsl.plugin.DescriptorImpl;
import javaposse.jobdsl.plugin.DslEnvironment;
import javaposse.jobdsl.plugin.DslEnvironmentImpl;
import javaposse.jobdsl.plugin.ExtensionPointHelper;
import javaposse.jobdsl.plugin.LookupStrategy;
import javaposse.jobdsl.plugin.Messages;
import javaposse.jobdsl.plugin.PermissionsHelper;
import javaposse.jobdsl.plugin.SeedReference;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import jenkins.model.DirectlyModifiableTopLevelItemGroup;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import org.apache.commons.io.FilenameUtils;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.jenkinsci.plugins.vSphereCloud;

public class JenkinsJobManagement
extends AbstractJobManagement {
    private static final Logger LOGGER = Logger.getLogger(JenkinsJobManagement.class.getName());
    private final Map<String, ?> envVars;
    private final Run<?, ?> run;
    private final FilePath workspace;
    private final hudson.model.Item project;
    private final LookupStrategy lookupStrategy;
    private final Map<Item, DslEnvironment> environments = new HashMap<Item, DslEnvironment>();
    private boolean failOnMissingPlugin;
    private boolean failOnSeedCollision;
    private boolean unstableOnDeprecation;

    public JenkinsJobManagement(PrintStream outputLogger, Map<String, ?> envVars, Run<?, ?> run, FilePath workspace, LookupStrategy lookupStrategy) {
        super(outputLogger);
        this.envVars = envVars;
        this.run = run;
        this.workspace = workspace;
        this.project = run == null ? null : run.getParent();
        this.lookupStrategy = lookupStrategy;
    }

    public JenkinsJobManagement(PrintStream outputLogger, Map<String, ?> envVars, File workspace) {
        this(outputLogger, envVars, null, new FilePath(workspace.getAbsoluteFile()), LookupStrategy.JENKINS_ROOT);
    }

    public void setFailOnMissingPlugin(boolean failOnMissingPlugin) {
        this.failOnMissingPlugin = failOnMissingPlugin;
    }

    void setFailOnSeedCollision(boolean failOnSeedCollision) {
        this.failOnSeedCollision = failOnSeedCollision;
    }

    void setUnstableOnDeprecation(boolean unstableOnDeprecation) {
        this.unstableOnDeprecation = unstableOnDeprecation;
    }

    public String getConfig(String path) throws JobConfigurationNotFoundException {
        String xml;
        LOGGER.log(Level.INFO, String.format("Getting config for Job %s", path));
        if (path.isEmpty()) {
            throw new JobConfigurationNotFoundException(path);
        }
        try {
            xml = this.lookupJob(path);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, String.format("Named Job Config not found: %s", path));
            throw new JobConfigurationNotFoundException(path);
        }
        LOGGER.log(Level.FINE, String.format("Job config %s", xml));
        return xml;
    }

    public boolean createOrUpdateConfig(Item dslItem, boolean ignoreExisting) throws NameNotProvidedException {
        String path = dslItem.getName();
        LOGGER.log(Level.INFO, String.format("createOrUpdateConfig for %s", path));
        JenkinsJobManagement.validateNameArg((String)path);
        AbstractItem item = this.lookupStrategy.getItem(this.project, path, AbstractItem.class);
        String jobName = FilenameUtils.getName((String)path);
        Jenkins.checkGoodName((String)jobName);
        if (item == null) {
            this.createNewItem(path, dslItem);
            return true;
        }
        if (!ignoreExisting) {
            String existingSeedJobName;
            DescriptorImpl descriptor;
            SeedReference seedReference;
            String seedJobName;
            if (this.failOnSeedCollision && (seedJobName = this.project.getFullName()) != null && (seedReference = (descriptor = (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class)).getGeneratedJobMap().get(item.getFullName())) != null && !seedJobName.equals(existingSeedJobName = seedReference.getSeedJobName()) && Jenkins.get().getItemByFullName(existingSeedJobName) != null) {
                throw new DslException(String.format(Messages.CreateOrUpdateConfigFile_SeedCollision(), path, existingSeedJobName));
            }
            return this.updateExistingItem(item, dslItem);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createOrUpdateView(String path, String config, boolean ignoreExisting) {
        JenkinsJobManagement.validateUpdateArgs((String)path, (String)config);
        String viewBaseName = FilenameUtils.getName((String)path);
        Jenkins.checkGoodName((String)viewBaseName);
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(config.getBytes(StandardCharsets.UTF_8));
            ItemGroup parent = this.lookupStrategy.getParent(this.project, path);
            if (parent instanceof ViewGroup) {
                ViewGroup parentGroup = (ViewGroup)parent;
                View view = parentGroup.getView(viewBaseName);
                if (view != null && this.viewTypeChanged(view, inputStream)) {
                    parentGroup.deleteView(view);
                    view = null;
                }
                if (view == null) {
                    if (!(parent instanceof ModifiableViewGroup)) throw new DslException(String.format(Messages.CreateView_UnsupportedParent(), parent.getFullName(), parent.getClass()));
                    ((ModifiableViewGroup)parent).checkPermission(View.CREATE);
                    ((ModifiableViewGroup)parent).addView(View.createViewFromXML((String)viewBaseName, (InputStream)inputStream));
                    return;
                } else {
                    if (ignoreExisting) return;
                    ((InputStream)inputStream).reset();
                    view.updateByXml((Source)new StreamSource(inputStream));
                    return;
                }
            }
            if (parent != null) throw new DslException(String.format(Messages.CreateView_UnsupportedParent(), parent.getFullName(), parent.getClass()));
            throw new DslException(String.format(Messages.CreateView_UnknownParent(), path));
        }
        catch (IOException e) {
            throw new DslException((Throwable)e);
        }
    }

    public void createOrUpdateUserContent(UserContent userContent, boolean ignoreExisting) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        try {
            FilePath file = Jenkins.get().getRootPath().child("userContent").child(userContent.getPath());
            if (!file.exists() || !ignoreExisting) {
                file.getParent().mkdirs();
                file.copyFrom(userContent.getContent());
            }
        }
        catch (Exception e) {
            throw new DslException(String.format(Messages.CreateOrUpdateUserContent_Exception(), userContent.getPath(), e.getMessage()));
        }
    }

    public Map<String, Object> getParameters() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.envVars);
        if (this.project != null && !result.containsKey("SEED_JOB")) {
            result.put("SEED_JOB", this.project);
        }
        return result;
    }

    public void queueJob(String path) throws NameNotProvidedException {
        JenkinsJobManagement.validateNameArg((String)path);
        BuildableItem project = this.lookupStrategy.getItem(this.project, path, BuildableItem.class);
        project.checkPermission(hudson.model.Item.BUILD);
        LOGGER.log(Level.INFO, String.format("Scheduling build of %s from %s", path, project.getName()));
        project.scheduleBuild((Cause)(this.run == null ? new JobDslCause() : new Cause.UpstreamCause(this.run)));
    }

    public InputStream streamFileInWorkspace(String relLocation) throws IOException, InterruptedException {
        if (this.project != null) {
            this.project.checkPermission(hudson.model.Item.WORKSPACE);
        }
        FilePath filePath = this.locateValidFileInWorkspace(this.workspace, relLocation);
        return filePath.read();
    }

    public String readFileInWorkspace(String relLocation) throws IOException, InterruptedException {
        if (this.project != null) {
            this.project.checkPermission(hudson.model.Item.WORKSPACE);
        }
        FilePath filePath = this.locateValidFileInWorkspace(this.workspace, relLocation);
        return filePath.readToString();
    }

    public String readFileInWorkspace(String jobName, String relLocation) throws IOException, InterruptedException {
        hudson.model.Item item = Jenkins.get().getItemByFullName(jobName);
        if (item instanceof AbstractProject) {
            item.checkPermission(hudson.model.Item.WORKSPACE);
            FilePath workspace = ((AbstractProject)item).getSomeWorkspace();
            if (workspace != null) {
                try {
                    return this.locateValidFileInWorkspace(workspace, relLocation).readToString();
                }
                catch (DslScriptException e) {
                    this.logWarning(String.format(Messages.ReadFileFromWorkspace_JobFileNotFound(), relLocation, jobName));
                }
            } else {
                this.logWarning(String.format(Messages.ReadFileFromWorkspace_WorkspaceNotFound(), relLocation, jobName));
            }
        } else {
            this.logWarning(String.format(Messages.ReadFileFromWorkspace_JobNotFound(), relLocation, jobName));
        }
        return null;
    }

    public void logPluginDeprecationWarning(String pluginShortName, String minimumVersion) {
        Plugin plugin = Jenkins.get().getPlugin(pluginShortName);
        if (plugin != null && plugin.getWrapper().getVersionNumber().isOlderThan(new VersionNumber(minimumVersion))) {
            this.logDeprecationWarning("support for " + plugin.getWrapper().getDisplayName() + " versions older than " + minimumVersion);
        }
    }

    protected void logDeprecationWarning(String subject, String details) {
        super.logDeprecationWarning(subject, details);
        if (this.unstableOnDeprecation && this.run != null) {
            this.run.setResult(Result.UNSTABLE);
        }
    }

    public void requirePlugin(String pluginShortName) {
        this.requirePlugin(pluginShortName, false);
    }

    public void requirePlugin(String pluginShortName, boolean failIfMissing) {
        Plugin plugin = Jenkins.get().getPlugin(pluginShortName);
        if (plugin == null) {
            this.failOrMarkBuildAsUnstable("plugin '" + pluginShortName + "' needs to be installed", failIfMissing || this.failOnMissingPlugin);
        }
    }

    public void requireMinimumPluginVersion(String pluginShortName, String version) {
        this.requireMinimumPluginVersion(pluginShortName, version, false);
    }

    public void requireMinimumPluginVersion(String pluginShortName, String version, boolean failIfMissing) {
        Plugin plugin = Jenkins.get().getPlugin(pluginShortName);
        if (plugin == null) {
            this.failOrMarkBuildAsUnstable("version " + version + " or later of plugin '" + pluginShortName + "' needs to be installed", failIfMissing || this.failOnMissingPlugin);
        } else if (plugin.getWrapper().getVersionNumber().isOlderThan(new VersionNumber(version))) {
            this.failOrMarkBuildAsUnstable("plugin '" + pluginShortName + "' needs to be updated to version " + version + " or later", failIfMissing || this.failOnMissingPlugin);
        }
    }

    public void requireMinimumCoreVersion(String version) {
        if (!this.isMinimumCoreVersion(version)) {
            this.failOrMarkBuildAsUnstable("Jenkins needs to be updated to version " + version + " or later", false);
        }
    }

    public boolean isMinimumPluginVersionInstalled(String pluginShortName, String version) {
        Plugin plugin = Jenkins.get().getPlugin(pluginShortName);
        return plugin != null && !plugin.getWrapper().getVersionNumber().isOlderThan(new VersionNumber(version));
    }

    public boolean isMinimumCoreVersion(String version) {
        return !Jenkins.getVersion().isOlderThan(new VersionNumber(version));
    }

    public Integer getVSphereCloudHash(String name) {
        Jenkins jenkins = Jenkins.get();
        if (jenkins.getPlugin("vsphere-cloud") != null) {
            for (Cloud cloud : jenkins.clouds) {
                if (!(cloud instanceof vSphereCloud) || !((vSphereCloud)cloud).getVsDescription().equals(name)) continue;
                return ((vSphereCloud)cloud).getHash();
            }
        }
        return null;
    }

    public void renameJobMatching(String previousNames, String destination) throws IOException {
        ItemGroup context = this.lookupStrategy.getContext(this.project);
        List items = Jenkins.get().getAllItems(Job.class);
        Collection matchingJobs = Collections2.filter((Collection)items, topLevelItem -> topLevelItem.getRelativeNameFrom(context).matches(previousNames));
        if (matchingJobs.size() == 1) {
            this.renameJob((Job)matchingJobs.iterator().next(), destination);
        } else if (matchingJobs.size() > 1) {
            throw new DslException(String.format(Messages.RenameJobMatching_MultipleJobsFound(), matchingJobs));
        }
    }

    public Set<String> getPermissions(String descriptorId) {
        return PermissionsHelper.getPermissions(descriptorId);
    }

    public Node callExtension(String name, Item item, Class<? extends ExtensibleContext> contextType, Object ... args) throws Throwable {
        Set<ExtensionPointHelper.DslExtension> candidates = ExtensionPointHelper.findExtensionPoints(name, contextType, args);
        if (candidates.isEmpty()) {
            LOGGER.fine("Found no extension which provides method " + name + " with arguments " + Arrays.toString(args));
            return null;
        }
        if (candidates.size() > 1) {
            throw new DslException(String.format(Messages.CallExtension_MultipleCandidates(), name, Arrays.toString(args), Arrays.toString(candidates.toArray())));
        }
        try {
            Object result;
            ExtensionPointHelper.DslExtension extension = (ExtensionPointHelper.DslExtension)Iterables.getOnlyElement(candidates);
            if (extension.isDeprecated()) {
                this.logDeprecationWarning(name);
            }
            return (result = extension.call(this.getSession(item), (JobManagement)this, args)) == null ? NO_VALUE : new XmlParser().parseText(Items.XSTREAM2.toXML(result));
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private void failOrMarkBuildAsUnstable(String message, boolean fail) {
        if (fail) {
            throw new DslScriptException(message);
        }
        this.logWarning(message);
        if (this.run != null) {
            this.run.setResult(Result.UNSTABLE);
        }
    }

    private FilePath locateValidFileInWorkspace(FilePath workspace, String relLocation) throws IOException, InterruptedException {
        FilePath filePath = workspace.child(relLocation);
        if (!filePath.exists()) {
            throw new DslScriptException(String.format("File %s does not exist in workspace", relLocation));
        }
        return filePath;
    }

    private String lookupJob(String path) throws IOException {
        LOGGER.log(Level.FINE, String.format("Looking up item %s", path));
        AbstractItem item = this.lookupStrategy.getItem(this.project, path, AbstractItem.class);
        if (item != null) {
            item.checkPermission(hudson.model.Item.EXTENDED_READ);
            XmlFile xmlFile = item.getConfigFile();
            String jobXml = xmlFile.asString();
            LOGGER.log(Level.FINE, String.format("Looked up item with config %s", jobXml));
            return jobXml;
        }
        LOGGER.log(Level.WARNING, String.format("No item called %s could be found.", path));
        throw new IOException(String.format("No item called %s could be found.", path));
    }

    private boolean updateExistingItem(AbstractItem item, Item dslItem) {
        String config = dslItem.getXml();
        item.checkPermission(hudson.model.Item.EXTENDED_READ);
        try {
            String oldJob = item.getConfigFile().asString();
            Diff diff = XMLUnit.compareXML((String)oldJob, (String)config);
            if (diff.identical()) {
                LOGGER.log(Level.FINE, String.format("Item %s is identical", item.getName()));
                this.notifyItemUpdated((hudson.model.Item)item, dslItem);
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.warning(e.getMessage());
        }
        this.checkItemType(item, dslItem);
        LOGGER.log(Level.FINE, String.format("Updating item %s as %s", item.getName(), config));
        StreamSource streamSource = new StreamSource(new StringReader(config));
        try {
            item.updateByXml((Source)streamSource);
            this.notifyItemUpdated((hudson.model.Item)item, dslItem);
        }
        catch (IOException e) {
            throw new DslException((Throwable)e);
        }
        return true;
    }

    private void checkItemType(AbstractItem item, Item dslItem) {
        Node oldConfig;
        item.checkPermission(hudson.model.Item.EXTENDED_READ);
        try {
            oldConfig = new XmlParser().parse(item.getConfigFile().getFile());
        }
        catch (Exception e) {
            throw new DslException(String.format(Messages.UpdateExistingItem_CouldNotReadConfig(), item.getConfigFile().getFile().getAbsolutePath(), item.getFullName()), (Throwable)e);
        }
        if (!oldConfig.name().equals(dslItem.getNode().name())) {
            throw new DslException(String.format(Messages.UpdateExistingItem_ItemTypeDoesNotMatch(), item.getFullName()));
        }
    }

    private boolean viewTypeChanged(View view, InputStream config) throws IOException {
        Class viewType = Jenkins.XSTREAM2.getMapper().realClass(new XppDriver().createReader(config).getNodeName());
        config.reset();
        return !viewType.equals(view.getClass());
    }

    private void createNewItem(String path, Item dslItem) {
        String config = dslItem.getXml();
        LOGGER.log(Level.FINE, String.format("Creating item as %s", config));
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes(StandardCharsets.UTF_8));
            ItemGroup parent = this.lookupStrategy.getParent(this.project, path);
            String itemName = FilenameUtils.getName((String)path);
            if (!(parent instanceof ModifiableTopLevelItemGroup)) {
                if (parent == null) {
                    throw new DslException(String.format(Messages.CreateItem_UnknownParent(), path));
                }
                throw new DslException(String.format(Messages.CreateItem_UnsupportedParent(), parent.getFullName(), parent.getClass()));
            }
            TopLevelItem project = ((ModifiableTopLevelItemGroup)parent).createProjectFromXML(itemName, (InputStream)is);
            this.notifyItemCreated((hudson.model.Item)project, dslItem);
        }
        catch (IOException e) {
            throw new DslException((Throwable)e);
        }
    }

    private void notifyItemCreated(hudson.model.Item item, Item dslItem) {
        DslEnvironment session = this.getSession(dslItem);
        for (ContextExtensionPoint extensionPoint : ContextExtensionPoint.all()) {
            extensionPoint.notifyItemCreated(item, session);
        }
    }

    private void notifyItemUpdated(hudson.model.Item item, Item dslItem) {
        DslEnvironment session = this.getSession(dslItem);
        for (ContextExtensionPoint extensionPoint : ContextExtensionPoint.all()) {
            extensionPoint.notifyItemUpdated(item, session);
        }
    }

    private DslEnvironment getSession(Item item) {
        if (item == null) {
            return null;
        }
        DslEnvironment session = this.environments.get(item);
        if (session == null) {
            session = new DslEnvironmentImpl((JobManagement)this, item);
            this.environments.put(item, session);
        }
        return session;
    }

    private void renameJob(Job from, String to) throws IOException {
        LOGGER.info(String.format("Renaming job %s to %s", from.getFullName(), to));
        ItemGroup fromParent = from.getParent();
        ItemGroup toParent = this.lookupStrategy.getParent(this.project, to);
        if (toParent == null) {
            throw new DslException(String.format(Messages.RenameJobMatching_UnknownParent(), from.getFullName(), to));
        }
        if (fromParent != toParent) {
            LOGGER.info(String.format("Moving Job %s to folder %s", fromParent.getFullName(), toParent.getFullName()));
            if (toParent instanceof DirectlyModifiableTopLevelItemGroup) {
                DirectlyModifiableTopLevelItemGroup itemGroup = (DirectlyModifiableTopLevelItemGroup)toParent;
                JenkinsJobManagement.move((hudson.model.Item)from, itemGroup);
            } else {
                throw new DslException(String.format(Messages.RenameJobMatching_DestinationNotFolder(), from.getFullName(), toParent.getFullName()));
            }
        }
        from.renameTo(FilenameUtils.getName((String)to));
    }

    private static <I extends AbstractItem> void move(hudson.model.Item item, DirectlyModifiableTopLevelItemGroup destination) throws IOException {
        Items.move((AbstractItem)((AbstractItem)item), (DirectlyModifiableTopLevelItemGroup)destination);
    }

    private static class JobDslCause
    extends Cause {
        private JobDslCause() {
        }

        public String getShortDescription() {
            return "Started by a Job DSL script";
        }
    }
}

