/*
 * Decompiled with CFR 0.152.
 */
package javaposse.jobdsl.plugin;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.listeners.ItemListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.util.Map;
import javaposse.jobdsl.plugin.ExecuteDslScripts;
import javaposse.jobdsl.plugin.GlobalJobDslSecurityConfiguration;
import javaposse.jobdsl.plugin.LookupStrategy;
import javaposse.jobdsl.plugin.Messages;
import javaposse.jobdsl.plugin.RemovedConfigFilesAction;
import javaposse.jobdsl.plugin.RemovedJobAction;
import javaposse.jobdsl.plugin.RemovedViewAction;
import javaposse.jobdsl.plugin.SeedReference;
import javaposse.jobdsl.plugin.actions.GeneratedConfigFilesBuildAction;
import javaposse.jobdsl.plugin.actions.GeneratedJobsBuildAction;
import javaposse.jobdsl.plugin.actions.GeneratedViewsBuildAction;
import jenkins.YesNoMaybe;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.StaplerRequest;

@Extension(dynamicLoadable=YesNoMaybe.YES)
@Symbol(value={"jobDsl"})
public class DescriptorImpl
extends BuildStepDescriptor<Builder> {
    private Multimap<String, SeedReference> templateJobMap;
    private Map<String, SeedReference> generatedJobMap;

    public DescriptorImpl() {
        super(ExecuteDslScripts.class);
        this.load();
    }

    public String getDisplayName() {
        return "Process Job DSLs";
    }

    public Multimap<String, SeedReference> getTemplateJobMap() {
        if (this.templateJobMap == null) {
            this.templateJobMap = HashMultimap.create();
        }
        return this.templateJobMap;
    }

    public Map<String, SeedReference> getGeneratedJobMap() {
        if (this.generatedJobMap == null) {
            this.generatedJobMap = Maps.newConcurrentMap();
        }
        return this.generatedJobMap;
    }

    public void setTemplateJobMap(Multimap<String, SeedReference> templateJobMap) {
        this.templateJobMap = templateJobMap;
    }

    public ListBoxModel doFillRemovedJobActionItems() {
        ListBoxModel items = new ListBoxModel();
        for (RemovedJobAction action : RemovedJobAction.values()) {
            items.add(action.getDisplayName(), action.name());
        }
        return items;
    }

    public ListBoxModel doFillRemovedViewActionItems() {
        ListBoxModel items = new ListBoxModel();
        for (RemovedViewAction action : RemovedViewAction.values()) {
            items.add(action.getDisplayName(), action.name());
        }
        return items;
    }

    public ListBoxModel doFillRemovedConfigFilesActionItems() {
        ListBoxModel items = new ListBoxModel();
        for (RemovedConfigFilesAction action : RemovedConfigFilesAction.values()) {
            items.add(action.getDisplayName(), action.name());
        }
        return items;
    }

    public ListBoxModel doFillLookupStrategyItems() {
        ListBoxModel items = new ListBoxModel();
        for (LookupStrategy item : LookupStrategy.values()) {
            items.add(item.getDisplayName(), item.name());
        }
        return items;
    }

    public Builder newInstance(@CheckForNull StaplerRequest req, @NonNull JSONObject formData) throws Descriptor.FormException {
        ExecuteDslScripts builder = (ExecuteDslScripts)super.newInstance(req, formData);
        builder.configure((Item)req.findAncestorObject(Item.class));
        return builder;
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public String getScriptApprovalWarning() {
        return this.isSecurityEnabled() && !Jenkins.get().hasPermission(Jenkins.RUN_SCRIPTS) ? Messages.ScriptSecurity_ScriptApprovalWarning() : "";
    }

    @Initializer(before=InitMilestone.PLUGINS_STARTED)
    public static void addAliases() {
        Run.XSTREAM2.addCompatibilityAlias("javaposse.jobdsl.plugin.GeneratedConfigFilesBuildAction", GeneratedConfigFilesBuildAction.class);
        Run.XSTREAM2.addCompatibilityAlias("javaposse.jobdsl.plugin.GeneratedJobsBuildAction", GeneratedJobsBuildAction.class);
        Run.XSTREAM2.addCompatibilityAlias("javaposse.jobdsl.plugin.GeneratedViewsBuildAction", GeneratedViewsBuildAction.class);
    }

    public boolean isSecurityEnabled() {
        Jenkins jenkins = Jenkins.get();
        return jenkins.isUseSecurity() && ((GlobalJobDslSecurityConfiguration)jenkins.getDescriptorByType(GlobalJobDslSecurityConfiguration.class)).isUseScriptSecurity();
    }

    private static void removeSeedReference(String key) {
        DescriptorImpl descriptor = (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
        SeedReference seedReference = descriptor.getGeneratedJobMap().remove(key);
        if (seedReference != null) {
            descriptor.save();
        }
    }

    @Extension
    public static class GeneratedJobMapItemListener
    extends ItemListener {
        public void onDeleted(Item item) {
            DescriptorImpl.removeSeedReference(item.getFullName());
        }

        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            DescriptorImpl.removeSeedReference(oldFullName);
        }
    }
}

