/*
 * Decompiled with CFR 0.152.
 */
package javaposse.jobdsl.plugin;

import hudson.model.Item;
import hudson.model.ItemGroup;
import java.util.function.Function;
import jenkins.model.Jenkins;
import org.apache.commons.io.FilenameUtils;

public enum LookupStrategy {
    JENKINS_ROOT("Jenkins Root", seedJob -> Jenkins.get()),
    SEED_JOB("Seed Job", Item::getParent);

    private final String displayName;
    private final Function<Item, ItemGroup> context;

    private LookupStrategy(String displayName, Function<Item, ItemGroup> context) {
        this.displayName = displayName;
        this.context = context;
    }

    public <T extends Item> T getItem(Item seedJob, String path, Class<T> type) {
        String fullName = path.startsWith("/") ? path : this.getContext(seedJob).getFullName() + "/" + path;
        String normalizePath = LookupStrategy.normalizePath(fullName);
        if (normalizePath == null) {
            return null;
        }
        return (T)Jenkins.get().getItemByFullName(normalizePath, type);
    }

    protected ItemGroup getContext(Item seedJob) {
        return this.context.apply(seedJob);
    }

    public ItemGroup getParent(Item seedJob, String path) {
        String contextPath;
        Jenkins jenkins = Jenkins.get();
        String absolutePath = path.startsWith("/") ? path.substring(1) : ((contextPath = this.getContext(seedJob).getFullName()).length() == 0 ? path : contextPath + "/" + path);
        int i = absolutePath.lastIndexOf(47);
        if (i > -1) {
            return LookupStrategy.getItemGroup(absolutePath.substring(0, i));
        }
        return jenkins;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    private static ItemGroup getItemGroup(String path) {
        Jenkins instance = Jenkins.get();
        String normalizedPath = LookupStrategy.normalizePath(path);
        if (normalizedPath == null) {
            return null;
        }
        if (normalizedPath.isEmpty() || normalizedPath.equals("/")) {
            return instance;
        }
        Item item = instance.getItemByFullName(normalizedPath);
        return item instanceof ItemGroup ? (ItemGroup)item : null;
    }

    private static String normalizePath(String path) {
        return FilenameUtils.normalize((String)path, (boolean)true);
    }
}

