/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth.inheritance;

import hudson.Extension;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.security.Permission;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategy;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategyDescriptor;
import org.jenkinsci.plugins.matrixauth.inheritance.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class InheritGlobalStrategy
extends InheritanceStrategy {
    @DataBoundConstructor
    public InheritGlobalStrategy() {
    }

    @Override
    protected boolean hasPermission(@Nonnull Authentication a, @Nonnull Permission permission, ACL child, @CheckForNull ACL parent, ACL root) {
        if (a.equals(ACL.SYSTEM)) {
            return true;
        }
        if (InheritGlobalStrategy.isParentReadPermissionRequired() && parent != null && (Item.READ.equals((Object)permission) || Item.DISCOVER.equals((Object)permission))) {
            boolean grantedViaChild = child.hasPermission(a, permission);
            boolean grantedGlobally = root.hasPermission(a, permission);
            boolean grantedInParent = parent.hasPermission(a, permission);
            return (grantedViaChild || grantedGlobally) && grantedInParent;
        }
        return child.hasPermission(a, permission) || root.hasPermission(a, permission);
    }

    @Symbol(value={"inheritingGlobal"})
    @Extension
    public static class DescriptorImpl
    extends InheritanceStrategyDescriptor {
        @Override
        public boolean isApplicable(Class<?> clazz) {
            return true;
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.InheritGlobalStrategy_DisplayName();
        }
    }
}

