/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth.inheritance;

import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.security.Permission;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategy;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategyDescriptor;
import org.jenkinsci.plugins.matrixauth.inheritance.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class InheritParentStrategy
extends InheritanceStrategy {
    @DataBoundConstructor
    public InheritParentStrategy() {
    }

    @Override
    protected boolean hasPermission(@Nonnull Authentication a, @Nonnull Permission permission, ACL child, @CheckForNull ACL parent, ACL root) {
        if (a.equals(ACL.SYSTEM)) {
            return true;
        }
        if (InheritParentStrategy.isParentReadPermissionRequired() && parent != null && (Item.READ.equals((Object)permission) || Item.DISCOVER.equals((Object)permission))) {
            return parent.hasPermission(a, permission);
        }
        if (parent == null) {
            return root.hasPermission(a, permission) || child.hasPermission(a, permission);
        }
        return parent.hasPermission(a, permission) || child.hasPermission(a, permission);
    }

    @Symbol(value={"inheriting"})
    @Extension(ordinal=100.0)
    public static class DescriptorImpl
    extends InheritanceStrategyDescriptor {
        @Override
        public boolean isApplicable(Class<?> clazz) {
            return AbstractItem.class.isAssignableFrom(clazz);
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.InheritParentStrategy_DisplayName();
        }
    }
}

