/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth.inheritance;

import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractItem;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.AuthorizationMatrixProperty;
import hudson.security.Permission;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategyDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class InheritanceStrategy
extends AbstractDescribableImpl<InheritanceStrategy>
implements ExtensionPoint {
    @Restricted(value={NoExternalUse.class})
    static boolean isParentReadPermissionRequired() {
        String propertyName = AuthorizationMatrixProperty.class.getName() + ".checkParentPermissions";
        String value = System.getProperty(propertyName);
        if (value == null) {
            return true;
        }
        return Boolean.parseBoolean(value);
    }

    public InheritanceStrategyDescriptor getDescriptor() {
        return (InheritanceStrategyDescriptor)super.getDescriptor();
    }

    @CheckForNull
    private ACL getParentItemACL(AccessControlled accessControlled) {
        AbstractItem item;
        ItemGroup parent;
        ACL parentACL = null;
        if (accessControlled instanceof AbstractItem && (parent = (item = (AbstractItem)accessControlled).getParent()) instanceof AbstractItem) {
            parentACL = Jenkins.get().getAuthorizationStrategy().getACL((AbstractItem)parent);
        }
        return parentACL;
    }

    public ACL getEffectiveACL(ACL acl, AccessControlled subject) {
        return ACL.lambda((a, p) -> this.hasPermission((Authentication)a, (Permission)p, acl, this.getParentItemACL(subject), Jenkins.get().getAuthorizationStrategy().getRootACL()));
    }

    protected abstract boolean hasPermission(@Nonnull Authentication var1, @Nonnull Permission var2, ACL var3, @CheckForNull ACL var4, ACL var5);
}

