/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth.inheritance;

import hudson.Extension;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.security.Permission;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategy;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategyDescriptor;
import org.jenkinsci.plugins.matrixauth.inheritance.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class NonInheritingStrategy
extends InheritanceStrategy {
    @DataBoundConstructor
    public NonInheritingStrategy() {
    }

    @Override
    protected boolean hasPermission(@Nonnull Authentication a, @Nonnull Permission permission, ACL child, @CheckForNull ACL parent, ACL root) {
        if (a.equals(ACL.SYSTEM)) {
            return true;
        }
        if (NonInheritingStrategy.isUltimatelyImpliedByAdminister(permission) && root.hasPermission(a, Jenkins.ADMINISTER)) {
            return true;
        }
        if (NonInheritingStrategy.isParentReadPermissionRequired() && parent != null && (Item.READ.equals((Object)permission) || Item.DISCOVER.equals((Object)permission))) {
            return parent.hasPermission(a, permission) && child.hasPermission(a, permission);
        }
        return child.hasPermission(a, permission);
    }

    private static boolean isUltimatelyImpliedByAdminister(Permission permission) {
        while (permission.impliedBy != null) {
            permission = permission.impliedBy;
        }
        return permission == Jenkins.ADMINISTER;
    }

    @Symbol(value={"nonInheriting"})
    @Extension(ordinal=-100.0)
    public static class DescriptorImpl
    extends InheritanceStrategyDescriptor {
        @Override
        public boolean isApplicable(Class<?> clazz) {
            return true;
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.NonInheritingStrategy_DisplayName();
        }
    }
}

