/*
 * Decompiled with CFR 0.152.
 */
package hudson.matrix;

import hudson.matrix.Axis;
import hudson.matrix.AxisList;
import hudson.matrix.Combination;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Layouter<T> {
    public final List<Axis> x;
    public final List<Axis> y;
    public final List<Axis> z;
    private final List<Axis> trivial = new ArrayList<Axis>();
    private int xSize;
    private int ySize;
    private int zSize;

    public Layouter(List<Axis> x, List<Axis> y, List<Axis> z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.init();
    }

    public Layouter(AxisList axisList) {
        this.x = new ArrayList<Axis>();
        this.y = new ArrayList<Axis>();
        this.z = new ArrayList<Axis>();
        ArrayList<Axis> nonTrivialAxes = new ArrayList<Axis>();
        for (Axis a : axisList) {
            if (a.size() > 1) {
                nonTrivialAxes.add(a);
                continue;
            }
            this.trivial.add(a);
        }
        switch (nonTrivialAxes.size()) {
            case 0: {
                break;
            }
            case 1: {
                this.z.add((Axis)nonTrivialAxes.get(0));
                break;
            }
            case 2: {
                Axis a = (Axis)nonTrivialAxes.get(0);
                Axis b = (Axis)nonTrivialAxes.get(1);
                this.x.add(a.size() > b.size() ? b : a);
                this.y.add(a.size() > b.size() ? a : b);
                break;
            }
            default: {
                for (int i = 0; i < nonTrivialAxes.size(); ++i) {
                    (i % 3 == 1 ? this.x : this.y).add((Axis)nonTrivialAxes.get(i));
                }
            }
        }
        this.init();
    }

    private void init() {
        this.xSize = this.calc(this.x, -1);
        this.ySize = this.calc(this.y, -1);
        this.zSize = this.calc(this.z, -1);
    }

    public int width(int n) {
        return this.calc(this.x, n);
    }

    public int repeatX(int n) {
        int w = 1;
        --n;
        while (n >= 0) {
            w *= this.x.get(n).size();
            --n;
        }
        return w;
    }

    public int height(int n) {
        return this.calc(this.y, n);
    }

    private int calc(List<Axis> l, int n) {
        int w = 1;
        ++n;
        while (n < l.size()) {
            w *= l.get(n).size();
            ++n;
        }
        return w;
    }

    public List<Row> getRows() {
        return new AbstractList<Row>(){
            final Row row;
            {
                this.row = new Row();
            }

            @Override
            public Row get(int index) {
                this.row.index = index;
                return this.row;
            }

            @Override
            public int size() {
                return Layouter.this.ySize;
            }
        };
    }

    protected abstract T getT(Combination var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Column
    extends AbstractList<T> {
        private int xp;
        private int yp;
        private final Map<String, String> m = new HashMap<String, String>();

        @Override
        public T get(int zp) {
            this.m.clear();
            this.buildMap(this.xp, Layouter.this.x);
            this.buildMap(this.yp, Layouter.this.y);
            this.buildMap(zp, Layouter.this.z);
            for (Axis a : Layouter.this.trivial) {
                if (a.size() <= 0) continue;
                this.m.put(a.name, a.value(0));
            }
            return Layouter.this.getT(new Combination(this.m));
        }

        private void buildMap(int p, List<Axis> axes) {
            int n = p;
            for (int i = axes.size() - 1; i >= 0; --i) {
                Axis a = axes.get(i);
                this.m.put(a.name, a.value(n % a.size()));
                n /= a.size();
            }
        }

        @Override
        public int size() {
            return Layouter.this.zSize;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Row
    extends AbstractList<Column> {
        private int index;
        final Column col;

        public Row() {
            this.col = new Column();
        }

        @Override
        public Column get(int index) {
            this.col.xp = index;
            this.col.yp = this.index;
            return this.col;
        }

        @Override
        public int size() {
            return Layouter.this.xSize;
        }

        public String drawYHeader(int n) {
            int base = Layouter.this.calc(Layouter.this.y, n);
            if (this.index / base == (this.index - 1) / base && this.index != 0) {
                return null;
            }
            Axis axis = Layouter.this.y.get(n);
            return axis.value(this.index / base % axis.getValues().size());
        }
    }
}

