/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.parsers;

import hudson.Extension;
import hudson.plugins.performance.data.HttpSample;
import hudson.plugins.performance.descriptors.PerformanceReportParserDescriptor;
import hudson.plugins.performance.parsers.AbstractParser;
import hudson.plugins.performance.parsers.JMeterCsvParser;
import hudson.plugins.performance.reports.PerformanceReport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.xml.parsers.SAXParserFactory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JMeterParser
extends AbstractParser {
    public JMeterParser(String glob, String percentiles) {
        super(glob, percentiles, PerformanceReport.INCLUDE_ALL);
    }

    @DataBoundConstructor
    public JMeterParser(String glob, String percentiles, String filterRegex) {
        super(glob, percentiles, filterRegex);
    }

    @Override
    public String getDefaultGlobPattern() {
        return "**/*.jtl";
    }

    @Override
    PerformanceReport parse(File reportFile) throws Exception {
        boolean isXml = JMeterParser.isXmlFile(reportFile);
        if (isXml) {
            return this.parseXml(reportFile);
        }
        return this.parseCsv(reportFile);
    }

    public static boolean isXmlFile(File file) throws IOException {
        try (FileReader fr = new FileReader(file, StandardCharsets.UTF_8);){
            boolean bl;
            try (BufferedReader reader = new BufferedReader(fr);){
                String line;
                boolean isXml = false;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().length() == 0) continue;
                    if (!line.toLowerCase().trim().startsWith("<?xml ")) break;
                    isXml = true;
                    break;
                }
                bl = isXml;
            }
            return bl;
        }
    }

    PerformanceReport parseXml(File reportFile) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        final PerformanceReport report = this.createPerformanceReport();
        report.setExcludeResponseTime(this.excludeResponseTime);
        report.setShowTrendGraphs(this.showTrendGraphs);
        report.setReportFileName(reportFile.getName());
        factory.newSAXParser().parse(reportFile, new DefaultHandler(){
            HttpSample currentSample;
            int counter = 0;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (!"httpSample".equalsIgnoreCase(qName) && !"sample".equalsIgnoreCase(qName)) {
                    return;
                }
                HttpSample sample = new HttpSample();
                String dateValue = attributes.getValue("ts") != null ? attributes.getValue("ts") : attributes.getValue("timeStamp");
                sample.setDate(new Date(Long.parseLong(dateValue)));
                String durationValue = attributes.getValue("t") != null ? attributes.getValue("t") : attributes.getValue("time");
                sample.setDuration(Long.parseLong(durationValue));
                String successfulValue = attributes.getValue("s") != null ? attributes.getValue("s") : attributes.getValue("success");
                sample.setSuccessful(Boolean.parseBoolean(successfulValue));
                String uriValue = attributes.getValue("lb") != null ? attributes.getValue("lb") : attributes.getValue("label");
                sample.setUri(uriValue);
                String httpCodeValue = attributes.getValue("rc") != null && attributes.getValue("rc").length() <= 3 ? attributes.getValue("rc") : "0";
                sample.setHttpCode(httpCodeValue);
                String sizeInKbValue = attributes.getValue("by") != null ? attributes.getValue("by") : "0";
                sample.setSizeInKb(Double.parseDouble(sizeInKbValue) / 1024.0);
                if (this.counter == 0) {
                    this.currentSample = sample;
                }
                ++this.counter;
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                if ("httpSample".equalsIgnoreCase(qName) || "sample".equalsIgnoreCase(qName)) {
                    if (this.counter == 1) {
                        report.addSample(this.currentSample);
                    }
                    --this.counter;
                }
            }
        });
        return report;
    }

    PerformanceReport parseCsv(File reportFile) throws Exception {
        JMeterCsvParser delegate = new JMeterCsvParser(this.glob, this.percentiles, this.filterRegex);
        return delegate.parse(reportFile);
    }

    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "JMeter";
        }
    }
}

