/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.build;

import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ItemVisitor;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.support.steps.build.BuildTriggerStepExecution;
import org.jenkinsci.plugins.workflow.support.steps.build.Messages;
import org.jenkinsci.plugins.workflow.util.StaplerReferer;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class BuildTriggerStep
extends AbstractStepImpl {
    private final String job;
    private List<ParameterValue> parameters;
    private boolean wait = true;
    private boolean propagate = true;
    private Integer quietPeriod;

    @DataBoundConstructor
    public BuildTriggerStep(String job) {
        this.job = job;
    }

    public String getJob() {
        return this.job;
    }

    public List<ParameterValue> getParameters() {
        return this.parameters;
    }

    @DataBoundSetter
    public void setParameters(List<ParameterValue> parameters) {
        this.parameters = parameters;
    }

    public boolean getWait() {
        return this.wait;
    }

    @DataBoundSetter
    public void setWait(boolean wait) {
        this.wait = wait;
    }

    public Integer getQuietPeriod() {
        return this.quietPeriod;
    }

    @DataBoundSetter
    public void setQuietPeriod(Integer quietPeriod) {
        this.quietPeriod = quietPeriod;
    }

    public boolean isPropagate() {
        return this.propagate;
    }

    @DataBoundSetter
    public void setPropagate(boolean propagate) {
        this.propagate = propagate;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(BuildTriggerStepExecution.class);
        }

        public Step newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JSONArray params;
            BuildTriggerStep step = (BuildTriggerStep)super.newInstance(req, formData);
            Object parameter = formData.get("parameter");
            JSONArray jSONArray = params = parameter != null ? JSONArray.fromObject((Object)parameter) : null;
            if (params != null) {
                ParametersDefinitionProperty pdp;
                Job context = (Job)StaplerReferer.findItemFromRequest(Job.class);
                Job job = (Job)Jenkins.getActiveInstance().getItem(step.getJob(), (Item)context, Job.class);
                if (job != null && (pdp = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class)) != null) {
                    ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
                    for (Object o : params) {
                        JSONObject jo = (JSONObject)o;
                        String name = jo.getString("name");
                        ParameterDefinition d = pdp.getParameterDefinition(name);
                        if (d == null) {
                            throw new IllegalArgumentException("No such parameter definition: " + name);
                        }
                        ParameterValue parameterValue = d.createValue(req, jo);
                        if (parameterValue != null) {
                            values.add(parameterValue);
                            continue;
                        }
                        throw new IllegalArgumentException("Cannot retrieve the parameter value: " + name);
                    }
                    step.setParameters(values);
                }
            }
            return step;
        }

        public String getFunctionName() {
            return "build";
        }

        public String getDisplayName() {
            return "Build a job";
        }

        public AutoCompletionCandidates doAutoCompleteJob(@AncestorInPath ItemGroup<?> container, final @QueryParameter String value) {
            class Visitor
            extends ItemVisitor {
                String prefix;

                Visitor(String prefix) {
                    this.prefix = prefix;
                }

                public void onItem(Item i) {
                    String n = this.contextualNameOf(i);
                    if ((n.startsWith(value) || value.startsWith(n)) && (value.length() > n.length() || !n.substring(value.length()).contains("/")) && i.hasPermission(Item.READ)) {
                        if (i instanceof Queue.Task && n.startsWith(value)) {
                            candidates.add(n);
                        }
                        String oldPrefix = this.prefix;
                        this.prefix = n;
                        super.onItem(i);
                        this.prefix = oldPrefix;
                    }
                }

                private String contextualNameOf(Item i) {
                    if (this.prefix.endsWith("/") || this.prefix.length() == 0) {
                        return this.prefix + i.getName();
                    }
                    return this.prefix + '/' + i.getName();
                }
            }
            final AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            if (container == null || container == Jenkins.getInstance()) {
                new Visitor("").onItemGroup((ItemGroup)Jenkins.getInstance());
            } else {
                new Visitor("").onItemGroup(container);
                if (value.startsWith("/")) {
                    new Visitor("/").onItemGroup((ItemGroup)Jenkins.getInstance());
                }
                StringBuilder p = new StringBuilder("../");
                while (value.startsWith(p.toString())) {
                    container = ((Item)container).getParent();
                    new Visitor(p.toString()).onItemGroup(container);
                    p.append("../");
                }
            }
            return candidates;
        }

        @Restricted(value={DoNotUse.class})
        public String getContext() {
            Job job = (Job)StaplerReferer.findItemFromRequest(Job.class);
            return job != null ? job.getFullName() : null;
        }

        public FormValidation doCheckPropagate(@QueryParameter boolean value, @QueryParameter boolean wait) {
            if (!value && !wait) {
                return FormValidation.warningWithMarkup((String)Messages.BuildTriggerStep_explicitly_disabling_both_propagate_and_wait());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckWait(@AncestorInPath ItemGroup<?> context, @QueryParameter boolean value, @QueryParameter String job) {
            if (!value) {
                return FormValidation.ok();
            }
            Item item = Jenkins.getActiveInstance().getItem(job, context, Item.class);
            if (item == null) {
                return FormValidation.ok();
            }
            if (item instanceof Job) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.BuildTriggerStep_no_wait_for_non_jobs());
        }

        public FormValidation doCheckJob(@AncestorInPath ItemGroup<?> context, @QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.warning((String)Messages.BuildTriggerStep_no_job_configured());
            }
            Item item = Jenkins.getActiveInstance().getItem(value, context, Item.class);
            if (item == null) {
                return FormValidation.error((String)Messages.BuildTriggerStep_cannot_find(value));
            }
            if (item instanceof Queue.Task) {
                return FormValidation.ok();
            }
            if (item instanceof Describable) {
                return FormValidation.error((String)Messages.BuildTriggerStep_unsupported(((Describable)item).getDescriptor().getDisplayName()));
            }
            return FormValidation.error((String)Messages.BuildTriggerStep_unsupported(item.getClass().getName()));
        }
    }
}

