/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.build;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.Describable;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.QueueTaskFuture;
import hudson.model.queue.ScheduleResult;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jenkinsci.plugins.workflow.support.steps.build.BuildTriggerAction;
import org.jenkinsci.plugins.workflow.support.steps.build.BuildTriggerCancelledCause;
import org.jenkinsci.plugins.workflow.support.steps.build.BuildTriggerStep;
import org.jenkinsci.plugins.workflow.support.steps.build.BuildUpstreamNodeAction;
import org.jenkinsci.plugins.workflow.support.steps.build.Messages;

public class BuildTriggerStepExecution
extends AbstractStepExecutionImpl {
    private static final Logger LOGGER = Logger.getLogger(BuildTriggerStepExecution.class.getName());
    @StepContextParameter
    private transient TaskListener listener;
    @StepContextParameter
    private transient Run<?, ?> invokingRun;
    @StepContextParameter
    private transient FlowNode node;
    @Inject(optional=true)
    transient BuildTriggerStep step;
    private static final long serialVersionUID = 1L;

    public boolean start() throws Exception {
        String job = this.step.getJob();
        Item item = Jenkins.getActiveInstance().getItem(job, (Item)this.invokingRun.getParent(), Item.class);
        if (item == null) {
            throw new AbortException("No item named " + job + " found");
        }
        item.checkPermission(Item.BUILD);
        if (this.step.getWait() && !(item instanceof Job)) {
            throw new AbortException("Waiting for non-job items is not supported");
        }
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(new CauseAction((Cause)new Cause.UpstreamCause(this.invokingRun)));
        actions.add((Object)new BuildUpstreamNodeAction(this.node, this.invokingRun));
        if (item instanceof ParameterizedJobMixIn.ParameterizedJob) {
            QueueTaskFuture f;
            Integer quietPeriod;
            List<ParameterValue> parameters;
            final ParameterizedJobMixIn.ParameterizedJob project = (ParameterizedJobMixIn.ParameterizedJob)item;
            this.listener.getLogger().println("Scheduling project: " + ModelHyperlinkNote.encodeTo((Item)project));
            this.node.addAction((Action)new LabelAction(Messages.BuildTriggerStepExecution_building_(project.getFullDisplayName())));
            if (this.step.getWait()) {
                StepContext context = this.getContext();
                actions.add((Object)new BuildTriggerAction(context, this.step.isPropagate()));
                LOGGER.log(Level.FINER, "scheduling a build of {0} from {1}", new Object[]{project, context});
            }
            if ((parameters = this.step.getParameters()) != null) {
                parameters = this.completeDefaultParameters(parameters, (Job)project);
                actions.add(new ParametersAction(parameters));
            }
            if ((quietPeriod = this.step.getQuietPeriod()) == null) {
                quietPeriod = project.getQuietPeriod();
            }
            if ((f = new ParameterizedJobMixIn(){

                protected Job asJob() {
                    return (Job)project;
                }
            }.scheduleBuild2(quietPeriod.intValue(), actions.toArray(new Action[actions.size()]))) == null) {
                throw new AbortException("Failed to trigger build of " + project.getFullName());
            }
        } else if (item instanceof Queue.Task) {
            ScheduleResult scheduleResult;
            Integer quietPeriod;
            if (this.step.getParameters() != null && !this.step.getParameters().isEmpty()) {
                throw new AbortException("Item type does not support parameters");
            }
            Queue.Task task = (Queue.Task)item;
            this.listener.getLogger().println("Scheduling item: " + ModelHyperlinkNote.encodeTo((Item)item));
            this.node.addAction((Action)new LabelAction(Messages.BuildTriggerStepExecution_building_(task.getFullDisplayName())));
            if (this.step.getWait()) {
                StepContext context = this.getContext();
                actions.add((Object)new BuildTriggerAction(context, this.step.isPropagate()));
                LOGGER.log(Level.FINER, "scheduling a build of {0} from {1}", new Object[]{task, context});
            }
            if ((quietPeriod = this.step.getQuietPeriod()) == null) {
                try {
                    Method getQuietPeriod = task.getClass().getMethod("getQuietPeriod", new Class[0]);
                    if (getQuietPeriod.getReturnType().equals(Integer.TYPE)) {
                        quietPeriod = (Integer)getQuietPeriod.invoke((Object)task, new Object[0]);
                    }
                }
                catch (NoSuchMethodException getQuietPeriod) {
                }
                catch (IllegalAccessError | IllegalArgumentException | InvocationTargetException e) {
                    LOGGER.log(Level.WARNING, "Could not determine quiet period of " + item.getFullName(), e);
                }
            }
            if (quietPeriod == null) {
                quietPeriod = Jenkins.getActiveInstance().getQuietPeriod();
            }
            if ((scheduleResult = Jenkins.getActiveInstance().getQueue().schedule2(task, quietPeriod.intValue(), actions)).isRefused()) {
                throw new AbortException("Failed to trigger build of " + item.getFullName());
            }
        } else {
            throw new AbortException("The item named " + job + " is a " + (item instanceof Describable ? ((Describable)item).getDescriptor().getDisplayName() : item.getClass().getName()) + " which is not something that can be built");
        }
        if (this.step.getWait()) {
            return false;
        }
        this.getContext().onSuccess(null);
        return true;
    }

    private List<ParameterValue> completeDefaultParameters(List<ParameterValue> parameters, Job<?, ?> project) throws AbortException {
        ParametersDefinitionProperty pdp;
        HashMap<String, ParameterValue> allParameters = new HashMap<String, ParameterValue>();
        for (ParameterValue pv : parameters) {
            allParameters.put(pv.getName(), pv);
        }
        if (project != null && (pdp = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class)) != null) {
            for (ParameterDefinition pDef : pdp.getParameterDefinitions()) {
                if (!allParameters.containsKey(pDef.getName())) {
                    ParameterValue defaultP = pDef.getDefaultParameterValue();
                    if (defaultP == null) continue;
                    allParameters.put(defaultP.getName(), defaultP);
                    continue;
                }
                if (pDef instanceof ChoiceParameterDefinition) {
                    ParameterValue pv = (ParameterValue)allParameters.get(pDef.getName());
                    if (!((ChoiceParameterDefinition)pDef).getChoices().contains(pv.getValue())) {
                        throw new AbortException("Value for choice parameter '" + pDef.getName() + "' is '" + pv.getValue() + "', but valid choices are " + ((ChoiceParameterDefinition)pDef).getChoices());
                    }
                }
                ((ParameterValue)allParameters.get(pDef.getName())).setDescription(pDef.getDescription());
            }
        }
        return Lists.newArrayList(allParameters.values());
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="TODO 1.653+ switch to Jenkins.getInstanceOrNull")
    public void stop(Throwable cause) throws Exception {
        StepContext context = this.getContext();
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            context.onFailure(cause);
            return;
        }
        boolean interrupted = false;
        Queue q = jenkins.getQueue();
        for (Queue.Item item : q.getItems()) {
            for (BuildTriggerAction.Trigger trigger : BuildTriggerAction.triggersFor((Actionable)item)) {
                if (!trigger.context.equals((Object)context)) continue;
                q.cancel(item);
                interrupted = true;
            }
        }
        for (Queue.Item item : jenkins.getComputers()) {
            for (Executor e : item.getExecutors()) {
                interrupted |= BuildTriggerStepExecution.maybeInterrupt(e, cause, context);
            }
            for (Executor e : item.getOneOffExecutors()) {
                interrupted |= BuildTriggerStepExecution.maybeInterrupt(e, cause, context);
            }
        }
        if (!interrupted) {
            super.stop(cause);
        }
    }

    private static boolean maybeInterrupt(Executor e, Throwable cause, StepContext context) {
        boolean interrupted = false;
        Queue.Executable exec = e.getCurrentExecutable();
        if (exec instanceof Run) {
            for (BuildTriggerAction.Trigger trigger : BuildTriggerAction.triggersFor((Actionable)((Run)exec))) {
                if (!trigger.context.equals((Object)context)) continue;
                e.interrupt(Result.ABORTED, new CauseOfInterruption[]{new BuildTriggerCancelledCause(cause)});
                trigger.interruption = cause;
                try {
                    ((Run)exec).save();
                }
                catch (IOException x) {
                    LOGGER.log(Level.WARNING, "failed to save interrupt cause on " + exec, x);
                }
                interrupted = true;
            }
        }
        return interrupted;
    }

    public String getStatus() {
        for (Queue.Item item : Queue.getInstance().getItems()) {
            for (BuildTriggerAction.Trigger trigger : BuildTriggerAction.triggersFor((Actionable)item)) {
                if (!trigger.context.equals((Object)this.getContext())) continue;
                return "waiting to schedule " + item.task.getFullDisplayName() + "; blocked: " + item.getWhy();
            }
        }
        for (Queue.Item item : Jenkins.getActiveInstance().getComputers()) {
            String r;
            for (Executor e : item.getExecutors()) {
                r = this.running(e);
                if (r == null) continue;
                return r;
            }
            for (Executor e : item.getOneOffExecutors()) {
                r = this.running(e);
                if (r == null) continue;
                return r;
            }
        }
        return "unsure what happened to downstream build";
    }

    @CheckForNull
    private String running(@Nonnull Executor e) {
        Queue.Executable exec = e.getCurrentExecutable();
        if (exec instanceof Run) {
            Run run = (Run)exec;
            for (BuildTriggerAction.Trigger trigger : BuildTriggerAction.triggersFor((Actionable)run)) {
                if (!trigger.context.equals((Object)this.getContext())) continue;
                return "running " + run;
            }
        }
        return null;
    }
}

