/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileCallable;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileDecompressStep;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public abstract class DecompressStepExecution
extends SynchronousNonBlockingStepExecution<Object> {
    private transient AbstractFileCallable<? extends Object> callable;
    private final transient AbstractFileDecompressStep step;

    protected DecompressStepExecution(@NonNull AbstractFileDecompressStep step, @NonNull StepContext context) {
        super(context);
        this.step = step;
    }

    protected void setCallable(AbstractFileCallable<? extends Object> callable) {
        this.callable = callable;
    }

    protected Object run() throws IOException, InterruptedException {
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        assert (listener != null);
        FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
        assert (workspace != null);
        if (this.step.isTest()) {
            return this.test(listener, workspace);
        }
        FilePath source = workspace.child(this.step.getFile());
        if (!source.exists()) {
            throw new IOException(source.getRemote() + " does not exist.");
        }
        if (source.isDirectory()) {
            throw new IOException(source.getRemote() + " is a directory.");
        }
        FilePath destination = workspace;
        if (!StringUtils.isBlank((String)this.step.getDir())) {
            destination = workspace.child(this.step.getDir());
        }
        this.callable.setDestination(destination);
        return source.act(this.callable);
    }

    private Object test(TaskListener listener, FilePath workspace) throws IOException, InterruptedException {
        FilePath source = workspace.child(this.step.getFile());
        if (!source.exists()) {
            listener.error(source.getRemote() + " does not exist.");
            return Boolean.FALSE;
        }
        if (source.isDirectory()) {
            listener.error(source.getRemote() + " is a directory.");
            return Boolean.FALSE;
        }
        return source.act(this.callable);
    }
}

