/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.conf;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.util.LinkedList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileOrTextStep;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileOrTextStepDescriptorImpl;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileOrTextStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.reader.UnicodeReader;

public class ReadYamlStep
extends AbstractFileOrTextStep {
    @DataBoundConstructor
    public ReadYamlStep() {
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public static class Execution
    extends AbstractFileOrTextStepExecution<Object> {
        private static final long serialVersionUID = 1L;
        private transient ReadYamlStep step;

        protected Execution(@NonNull ReadYamlStep step, @NonNull StepContext context) {
            super(step, context);
            this.step = step;
        }

        @Override
        protected Object doRun() throws Exception {
            String yamlText = "";
            if (!StringUtils.isBlank((String)this.step.getFile())) {
                FilePath path = this.ws.child(this.step.getFile());
                if (!path.exists()) {
                    throw new FileNotFoundException(path.getRemote() + " does not exist.");
                }
                if (path.isDirectory()) {
                    throw new FileNotFoundException(path.getRemote() + " is a directory.");
                }
                UnicodeReader reader = new UnicodeReader(path.read());
                Object object = null;
                try {
                    yamlText = IOUtils.toString((Reader)reader);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (reader != null) {
                        if (object != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            if (!StringUtils.isBlank((String)this.step.getText())) {
                yamlText = yamlText + System.getProperty("line.separator") + this.step.getText();
            }
            Iterable yaml = new Yaml((BaseConstructor)new SafeConstructor()).loadAll(yamlText);
            LinkedList result = new LinkedList();
            for (Object data : yaml) {
                result.add(data);
            }
            try (ObjectOutputStream out = new ObjectOutputStream(new ByteArrayOutputStream());){
                out.writeObject(result);
            }
            if (result.size() == 1) {
                return result.get(0);
            }
            return result;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractFileOrTextStepDescriptorImpl {
        public String getFunctionName() {
            return "readYaml";
        }

        @NonNull
        public String getDisplayName() {
            return "Read yaml from files in the workspace or text.";
        }
    }
}

