/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.csv;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileOrTextStep;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileOrTextStepDescriptorImpl;
import org.jenkinsci.plugins.pipeline.utility.steps.csv.Messages;
import org.jenkinsci.plugins.pipeline.utility.steps.csv.ReadCSVStepExecution;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.GroovyShellDecorator;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ReadCSVStep
extends AbstractFileOrTextStep {
    private static final String ORG_APACHE_COMMONS_CSV = "org.apache.commons.csv";
    private CSVFormat format = CSVFormat.DEFAULT;

    @DataBoundConstructor
    public ReadCSVStep() {
    }

    public CSVFormat getFormat() {
        return this.format;
    }

    @DataBoundSetter
    public void setFormat(CSVFormat format) {
        this.format = format;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new ReadCSVStepExecution(this, context);
    }

    @Extension
    public static class WhiteLister
    extends Whitelist {
        public boolean permitsMethod(Method method, Object receiver, Object[] args) {
            if (receiver == null) {
                return false;
            }
            Class<?> aClass = receiver.getClass();
            Package aPackage = aClass.getPackage();
            if (aPackage == null) {
                return false;
            }
            if (!aPackage.getName().equals(ReadCSVStep.ORG_APACHE_COMMONS_CSV)) {
                return false;
            }
            if (aClass == CSVFormat.class) {
                return method.getName().startsWith("with");
            }
            return aClass == CSVRecord.class;
        }

        public boolean permitsConstructor(@NonNull Constructor<?> constructor, @NonNull Object[] args) {
            return false;
        }

        public boolean permitsStaticMethod(@NonNull Method method, @NonNull Object[] args) {
            Class<?> aClass = method.getDeclaringClass();
            Package aPackage = aClass.getPackage();
            if (aPackage == null) {
                return false;
            }
            if (!aPackage.getName().equals(ReadCSVStep.ORG_APACHE_COMMONS_CSV)) {
                return false;
            }
            if (aClass == CSVFormat.class) {
                return method.getName().equals("newFormat") || method.getName().equals("valueOf");
            }
            return false;
        }

        public boolean permitsFieldGet(@NonNull Field field, @NonNull Object receiver) {
            return false;
        }

        public boolean permitsFieldSet(@NonNull Field field, @NonNull Object receiver, Object value) {
            return false;
        }

        public boolean permitsStaticFieldGet(@NonNull Field field) {
            Class<?> aClass = field.getDeclaringClass();
            Package aPackage = aClass.getPackage();
            if (aPackage == null) {
                return false;
            }
            if (!aPackage.getName().equals(ReadCSVStep.ORG_APACHE_COMMONS_CSV)) {
                return false;
            }
            return aClass == CSVFormat.class;
        }

        public boolean permitsStaticFieldSet(@NonNull Field field, Object value) {
            return false;
        }
    }

    @Extension(optional=true)
    public static class PackageAutoImporter
    extends GroovyShellDecorator {
        public void customizeImports(CpsFlowExecution context, ImportCustomizer ic) {
            ic.addStarImports(new String[]{ReadCSVStep.ORG_APACHE_COMMONS_CSV});
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractFileOrTextStepDescriptorImpl {
        public String getFunctionName() {
            return "readCSV";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.ReadCSVStep_DescriptorImpl_displayName();
        }
    }
}

