/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.json;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.json.Messages;
import org.jenkinsci.plugins.pipeline.utility.steps.json.WriteJSONStepExecution;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class WriteJSONStep
extends Step {
    private String file;
    private final Object json;
    private int pretty = 0;
    private boolean returnText;

    @DataBoundConstructor
    public WriteJSONStep(Object json) {
        this.json = json;
    }

    @Deprecated
    public WriteJSONStep(String file, Object json) {
        this.file = Util.fixNull((String)file);
        this.json = json;
    }

    public String getFile() {
        return this.file;
    }

    @DataBoundSetter
    public void setFile(String file) {
        this.file = file;
    }

    public Object getJson() {
        return this.json;
    }

    public int getPretty() {
        return this.pretty;
    }

    @DataBoundSetter
    void setPretty(int pretty) {
        this.pretty = pretty;
    }

    public boolean isReturnText() {
        return this.returnText;
    }

    @DataBoundSetter
    public void setReturnText(boolean returnText) {
        this.returnText = returnText;
    }

    public StepExecution start(StepContext context) throws Exception {
        if (this.json == null) {
            throw new IllegalArgumentException(Messages.WriteJSONStepExecution_missingJSON(this.getDescriptor().getFunctionName()));
        }
        if (this.returnText) {
            if (this.file != null) {
                throw new IllegalArgumentException(Messages.WriteJSONStepExecution_bothReturnTextAndFile(this.getDescriptor().getFunctionName()));
            }
            return new ReturnTextExecution(this, context);
        }
        if (StringUtils.isBlank((String)this.file)) {
            throw new IllegalArgumentException(Messages.WriteJSONStepExecution_missingReturnTextAndFile(this.getDescriptor().getFunctionName()));
        }
        return new WriteJSONStepExecution(this, context);
    }

    void execute(Writer writer) throws IOException {
        JSON jsonObject = this.json instanceof JSON ? (JSON)this.json : JSONSerializer.toJSON((Object)this.json);
        if (this.pretty > 0) {
            writer.write(jsonObject.toString(this.pretty));
        } else {
            jsonObject.write(writer);
        }
    }

    private static class ReturnTextExecution
    extends SynchronousNonBlockingStepExecution<String> {
        private static final long serialVersionUID = 1L;
        private transient WriteJSONStep step;

        protected ReturnTextExecution(WriteJSONStep step, @NonNull StepContext context) {
            super(context);
            this.step = step;
        }

        protected String run() throws Exception {
            StringWriter w = new StringWriter();
            this.step.execute(w);
            return w.toString();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class);
        }

        public String getFunctionName() {
            return "writeJSON";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.WriteJSONStep_DescriptorImpl_displayName();
        }
    }
}

