// CHECKSTYLE:OFF

package org.jenkinsci.plugins.pipeline.utility.steps;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code
     * AbstractFileOrTextStepDescriptorImpl.missingRequiredArgument}: {@code
     * At least one of file or text needs to be provided to {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code At least one of file or text needs to be provided to {0}.}
     */
    public static String AbstractFileOrTextStepDescriptorImpl_missingRequiredArgument(Object arg0) {
        return holder.format("AbstractFileOrTextStepDescriptorImpl.missingRequiredArgument", arg0);
    }

    /**
     * Key {@code
     * AbstractFileOrTextStepDescriptorImpl.missingRequiredArgument}: {@code
     * At least one of file or text needs to be provided to {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code At least one of file or text needs to be provided to {0}.}
     */
    public static Localizable _AbstractFileOrTextStepDescriptorImpl_missingRequiredArgument(Object arg0) {
        return new Localizable(holder, "AbstractFileOrTextStepDescriptorImpl.missingRequiredArgument", arg0);
    }

    /**
     * Key {@code NodesByLabelStep.displayName}: {@code List of nodes by
     * Label, by default excludes offline nodes.}.
     * 
     * @return
     *     {@code List of nodes by Label, by default excludes offline nodes.}
     */
    public static String NodesByLabelStep_displayName() {
        return holder.format("NodesByLabelStep.displayName");
    }

    /**
     * Key {@code NodesByLabelStep.displayName}: {@code List of nodes by
     * Label, by default excludes offline nodes.}.
     * 
     * @return
     *     {@code List of nodes by Label, by default excludes offline nodes.}
     */
    public static Localizable _NodesByLabelStep_displayName() {
        return new Localizable(holder, "NodesByLabelStep.displayName");
    }

}
