/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.conf.mf;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileOrTextStepExecution;
import org.jenkinsci.plugins.pipeline.utility.steps.conf.mf.ReadManifestStep;
import org.jenkinsci.plugins.pipeline.utility.steps.conf.mf.SimpleManifest;
import org.jenkinsci.plugins.pipeline.utility.steps.zip.UnZipStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class ReadManifestStepExecution
extends AbstractFileOrTextStepExecution<SimpleManifest> {
    private static final long serialVersionUID = 1L;
    private transient ReadManifestStep step;

    protected ReadManifestStepExecution(@Nonnull ReadManifestStep step, @Nonnull StepContext context) {
        super(step, context);
        this.step = step;
    }

    @Override
    protected SimpleManifest doRun() throws Exception {
        if (!StringUtils.isBlank((String)this.step.getFile()) && !StringUtils.isBlank((String)this.step.getText())) {
            throw new IllegalArgumentException("Need to specify either file or text to readManifest, can't do both.");
        }
        if (!StringUtils.isBlank((String)this.step.getFile())) {
            return this.parseFile(this.step.getFile());
        }
        if (!StringUtils.isBlank((String)this.step.getText())) {
            return this.parseText(this.step.getText());
        }
        throw new IllegalStateException("A somewhat strange combination appeared.");
    }

    private SimpleManifest parseText(String text) throws IOException {
        Manifest manifest = new Manifest(new ByteArrayInputStream(text.getBytes("UTF-8")));
        return new SimpleManifest(manifest);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE"}, justification="I don't understand what/where it is.")
    private SimpleManifest parseFile(String file) throws IOException, InterruptedException {
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        FilePath path = this.ws.child(file);
        if (!path.exists()) {
            throw new FileNotFoundException(path.getRemote() + " does not exist.");
        }
        if (path.isDirectory()) {
            throw new FileNotFoundException(path.getRemote() + " is a directory.");
        }
        String lcName = path.getName().toLowerCase();
        if (lcName.endsWith(".jar") || lcName.endsWith(".war") || lcName.endsWith(".ear")) {
            Map mf = (Map)path.act((FilePath.FileCallable)new UnZipStepExecution.UnZipFileCallable(listener, this.ws, "META-INF/MANIFEST.MF", true, "UTF-8", false));
            String text = (String)mf.get("META-INF/MANIFEST.MF");
            if (StringUtils.isBlank((String)text)) {
                throw new FileNotFoundException(path.getRemote() + " does not seem to contain a manifest.");
            }
            return this.parseText(text);
        }
        try (InputStream is = path.read();){
            Manifest manifest = new Manifest(is);
            SimpleManifest simpleManifest = new SimpleManifest(manifest);
            return simpleManifest;
        }
    }
}

