/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.fs;

import hudson.FilePath;
import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;

public class FileWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final String name;
    @Nonnull
    private final String path;
    private final boolean directory;
    private final long length;
    private final long lastModified;

    public FileWrapper(@Nonnull String name, @Nonnull String path, boolean directory, long length, long lastModified) {
        this.name = name;
        this.directory = directory;
        this.length = length;
        this.lastModified = lastModified;
        this.path = directory && !path.endsWith("/") ? path + "/" : path;
    }

    protected FileWrapper(@Nonnull FilePath base, @Nonnull FilePath file) throws IOException, InterruptedException {
        this(file.getName(), file.getRemote().substring(base.getRemote().length() + 1), file.isDirectory(), file.length(), file.lastModified());
    }

    protected FileWrapper(@Nonnull FilePath file) throws IOException, InterruptedException {
        this(file.getName(), file.getRemote(), file.isDirectory(), file.length(), file.lastModified());
    }

    @Whitelisted
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Whitelisted
    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Whitelisted
    public boolean isDirectory() {
        return this.directory;
    }

    @Whitelisted
    public long getLength() {
        return this.length;
    }

    @Whitelisted
    public long getLastModified() {
        return this.lastModified;
    }

    @Whitelisted
    @Nonnull
    public String toString() {
        return this.getPath();
    }

    @Whitelisted
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileWrapper)) {
            return false;
        }
        FileWrapper that = (FileWrapper)o;
        return this.getPath().equals(that.getPath());
    }

    @Whitelisted
    public int hashCode() {
        return this.getPath().hashCode();
    }
}

