/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pluginusage.analyzer;

import hudson.PluginWrapper;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobPropertyDescriptor;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.plugins.promoted_builds.PromotedProjectAction;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.scm.SCM;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.DescribableList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.plugins.conditionalbuildstep.ConditionalBuilder;
import org.jenkinsci.plugins.conditionalbuildstep.singlestep.SingleConditionalBuilder;

abstract class AbstractProjectAnalyzer {
    AbstractProjectAnalyzer() {
    }

    protected PluginWrapper getPluginFromClass(Class<?> clazz) {
        return Jenkins.get().getPluginManager().whichPlugin(clazz);
    }

    @Deprecated
    protected PluginWrapper getUsedPlugin(Class<?> clazz) {
        return this.getPluginFromClass(clazz);
    }

    protected Set<PluginWrapper> getPlugins() {
        HashSet<PluginWrapper> plugins = new HashSet<PluginWrapper>();
        for (Descriptor b : Builder.all()) {
            plugins.add(this.getPluginFromClass(b.clazz));
        }
        for (Descriptor b : BuildWrapper.all()) {
            plugins.add(this.getPluginFromClass(b.clazz));
        }
        for (Descriptor b : Publisher.all()) {
            plugins.add(this.getPluginFromClass(b.clazz));
        }
        for (Descriptor b : SCM.all()) {
            plugins.add(this.getPluginFromClass(b.clazz));
        }
        for (Descriptor b : Trigger.all()) {
            plugins.add(this.getPluginFromClass(b.clazz));
        }
        return plugins;
    }

    protected Set<PluginWrapper> getPluginsFromItem(Item item) {
        HashSet<PluginWrapper> plugins = new HashSet<PluginWrapper>();
        plugins.addAll(this.getPluginsFromBuilders(item));
        plugins.addAll(this.getPluginsFromProperties(item));
        plugins.addAll(this.getPluginsFromScm(item));
        plugins.addAll(this.getPluginsFromTriggers(item));
        plugins.addAll(this.getPluginsFromPublishers(item));
        plugins.addAll(this.getPluginsFromParameters(item));
        plugins.addAll(this.getPluginsFromPromotedBuilds(item));
        return plugins;
    }

    protected boolean ignoreJob(Item item) {
        return false;
    }

    protected abstract Set<PluginWrapper> getPluginsFromBuilders(Item var1);

    protected Set<PluginWrapper> getPluginsFromPromotedBuilds(Item item) {
        PromotedProjectAction action;
        HashSet<PluginWrapper> plugins = new HashSet<PluginWrapper>();
        if (Jenkins.get().getPlugin("promoted-builds") == null) {
            return plugins;
        }
        if (item instanceof Job && (action = (PromotedProjectAction)((Job)item).getAction(PromotedProjectAction.class)) != null) {
            List processes = action.getProcesses();
            for (PromotionProcess process : processes) {
                List buildSteps = process.getBuildSteps();
                for (BuildStep buildStep : buildSteps) {
                    if (buildStep instanceof Builder) {
                        Builder innerBuilder = (Builder)buildStep;
                        plugins.add(this.getPluginFromClass(innerBuilder.getDescriptor().clazz));
                    }
                    if (!(buildStep instanceof Publisher)) continue;
                    Publisher innerPublisher = (Publisher)buildStep;
                    plugins.add(this.getPluginFromClass(innerPublisher.getDescriptor().clazz));
                }
            }
        }
        return plugins;
    }

    protected Set<PluginWrapper> getPluginsFromParameters(Item item) {
        ParametersDefinitionProperty parameters;
        HashSet<PluginWrapper> plugins = new HashSet<PluginWrapper>();
        if (item instanceof Job && (parameters = (ParametersDefinitionProperty)((Job)item).getAction(ParametersDefinitionProperty.class)) != null) {
            List parameterDefinitions = parameters.getParameterDefinitions();
            for (ParameterDefinition parameterDefinition : parameterDefinitions) {
                plugins.add(this.getPluginFromClass(parameterDefinition.getDescriptor().clazz));
            }
        }
        return plugins;
    }

    protected Set<PluginWrapper> getPluginsFromScm(Item item) {
        HashSet<PluginWrapper> plugins = new HashSet<PluginWrapper>();
        if (item instanceof AbstractProject) {
            plugins.add(this.getPluginFromClass(((AbstractProject)item).getScm().getDescriptor().clazz));
        }
        return plugins;
    }

    protected Set<PluginWrapper> getPluginsFromPublishers(Item item) {
        HashSet<PluginWrapper> plugins = new HashSet<PluginWrapper>();
        if (item instanceof AbstractProject) {
            DescribableList publisherList = ((AbstractProject)item).getPublishersList();
            Map map = publisherList.toMap();
            for (Map.Entry entry : map.entrySet()) {
                plugins.add(this.getPluginFromClass(((Descriptor)entry.getKey()).clazz));
            }
        }
        return plugins;
    }

    protected Set<PluginWrapper> getPluginsFromTriggers(Item item) {
        HashSet<PluginWrapper> plugins = new HashSet<PluginWrapper>();
        if (item instanceof ParameterizedJobMixIn.ParameterizedJob) {
            Map triggers = ((ParameterizedJobMixIn.ParameterizedJob)item).getTriggers();
            for (Map.Entry entry : triggers.entrySet()) {
                plugins.add(this.getPluginFromClass(((TriggerDescriptor)entry.getKey()).clazz));
            }
        }
        return plugins;
    }

    protected Set<PluginWrapper> getPluginsFromProperties(Item item) {
        HashSet<PluginWrapper> plugins = new HashSet<PluginWrapper>();
        if (item instanceof Job) {
            Map properties = ((Job)item).getProperties();
            for (Map.Entry entry : properties.entrySet()) {
                plugins.add(this.getPluginFromClass(((JobPropertyDescriptor)entry.getKey()).clazz));
            }
        }
        return plugins;
    }

    protected Set<PluginWrapper> getPluginsFromBuilder(Builder builder) {
        SingleConditionalBuilder singleConditionalBuilder;
        BuildStep buildStep;
        HashSet<PluginWrapper> plugins = new HashSet<PluginWrapper>();
        plugins.add(this.getPluginFromClass(builder.getDescriptor().clazz));
        if (Jenkins.get().getPlugin("conditional-buildstep") == null) {
            return plugins;
        }
        if (builder instanceof ConditionalBuilder) {
            ConditionalBuilder conditionalBuilder = (ConditionalBuilder)builder;
            List conditionalBuilders = conditionalBuilder.getConditionalbuilders();
            for (Builder innerBuilder : conditionalBuilders) {
                plugins.add(this.getPluginFromClass(innerBuilder.getDescriptor().clazz));
            }
        }
        if (builder instanceof SingleConditionalBuilder && (buildStep = (singleConditionalBuilder = (SingleConditionalBuilder)builder).getBuildStep()) instanceof Builder) {
            Builder innerBuilder = (Builder)buildStep;
            plugins.add(this.getPluginFromClass(innerBuilder.getDescriptor().clazz));
        }
        return plugins;
    }
}

