/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pluginusage.analyzer;

import hudson.PluginWrapper;
import hudson.model.Item;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.pluginusage.JobsPerPlugin;
import org.jenkinsci.plugins.pluginusage.analyzer.AbstractProjectAnalyzer;
import org.jenkinsci.plugins.pluginusage.analyzer.ComputedFolderAnalyzer;
import org.jenkinsci.plugins.pluginusage.analyzer.MatrixProjectAnalyzer;
import org.jenkinsci.plugins.pluginusage.analyzer.MavenProjectAnalyzer;
import org.jenkinsci.plugins.pluginusage.analyzer.PipelineLastBuildAnalyzer;
import org.jenkinsci.plugins.pluginusage.analyzer.PipelineProjectAnalyzer;
import org.jenkinsci.plugins.pluginusage.analyzer.ProjectAnalyzer;
import org.jenkinsci.plugins.pluginusage.analyzer.SCMSourceAnalyzer;

public class JobCollector {
    private static final Logger LOGGER = Logger.getLogger(JobCollector.class.getName());

    public Map<PluginWrapper, JobsPerPlugin> getJobsPerPlugin() {
        HashMap<PluginWrapper, JobsPerPlugin> mapJobsPerPlugin = new HashMap<PluginWrapper, JobsPerPlugin>();
        List<AbstractProjectAnalyzer> analyzers = Arrays.asList(new ProjectAnalyzer(), new MavenProjectAnalyzer(), new PipelineProjectAnalyzer(), new MatrixProjectAnalyzer(), new ComputedFolderAnalyzer(), new PipelineLastBuildAnalyzer(), new SCMSourceAnalyzer());
        for (AbstractProjectAnalyzer analyzer : analyzers) {
            try {
                for (PluginWrapper plugin : analyzer.getPlugins()) {
                    if (plugin == null || mapJobsPerPlugin.get(plugin) != null) continue;
                    mapJobsPerPlugin.put(plugin, new JobsPerPlugin(plugin));
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception caught: " + e, e);
            }
        }
        List items = Jenkins.get().getAllItems().stream().filter(job -> analyzers.stream().map(analyzer -> analyzer.ignoreJob((Item)job)).reduce(false, (a, b) -> a != false || b != false) == false).collect(Collectors.toList());
        for (Item item : items) {
            for (AbstractProjectAnalyzer analyzer : analyzers) {
                try {
                    for (PluginWrapper plugin : analyzer.getPluginsFromItem(item)) {
                        this.addItem(mapJobsPerPlugin, item, plugin);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Exception caught in job " + item.getFullName() + ": " + e, e);
                }
                catch (Throwable e) {
                    LOGGER.log(Level.SEVERE, "Exception caught in job " + item.getFullName() + ": " + e, e);
                }
            }
        }
        return mapJobsPerPlugin;
    }

    protected void addItem(Map<PluginWrapper, JobsPerPlugin> mapJobsPerPlugin, Item item, PluginWrapper usedPlugin) {
        if (usedPlugin != null) {
            JobsPerPlugin jobsPerPlugin = mapJobsPerPlugin.get(usedPlugin);
            if (jobsPerPlugin != null) {
                jobsPerPlugin.addProject(item);
            } else {
                JobsPerPlugin jobsPerPlugin2 = new JobsPerPlugin(usedPlugin);
                jobsPerPlugin2.addProject(item);
                mapJobsPerPlugin.put(usedPlugin, jobsPerPlugin2);
            }
        }
    }
}

