/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds;

import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.listeners.ItemListener;
import hudson.plugins.promoted_builds.JobPropertyImpl;
import java.io.File;
import java.io.FileFilter;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public class CopyListener
extends ItemListener {
    public void onCopied(Item src, Item item) {
        File[] subdirs;
        JobPropertyImpl prop;
        if (src instanceof Job && (prop = (JobPropertyImpl)((Job)src).getProperty(JobPropertyImpl.class)) != null && (subdirs = prop.getRootDir().listFiles(new FileFilter(){

            @Override
            public boolean accept(File child) {
                return child.isDirectory();
            }
        })) != null) {
            prop = (JobPropertyImpl)((Job)item).getProperty(JobPropertyImpl.class);
            for (File subdir : subdirs) {
                try {
                    Util.copyFile((File)new File(subdir, "config.xml"), (File)new File(prop.getRootDirFor(subdir.getName()), "config.xml"));
                }
                catch (Exception e) {
                    Logger.getLogger(CopyListener.class.getName()).log(Level.WARNING, "Failed to copy/load promotion " + subdir + " into new job", e);
                }
            }
            prop.setOwner(prop.getOwner());
        }
    }
}

