/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ItemGroupMixIn;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.listeners.ItemListener;
import hudson.plugins.promoted_builds.PromotedBuildAction;
import hudson.plugins.promoted_builds.PromotedProjectAction;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.remoting.Callable;
import hudson.util.Function1;
import hudson.util.IOUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.StaplerRequest;

public final class JobPropertyImpl
extends JobProperty<AbstractProject<?, ?>>
implements ItemGroup<PromotionProcess> {
    private transient List<PromotionProcess> processes = new ArrayList<PromotionProcess>();
    private transient List<PromotionProcess> activeProcesses;
    private final Set<String> activeProcessNames = new HashSet<String>();
    private static final Logger LOGGER = Logger.getLogger(JobPropertyImpl.class.getName());

    public JobPropertyImpl(AbstractProject<?, ?> owner) throws Descriptor.FormException, IOException {
        this.owner = owner;
        this.init();
    }

    public JobPropertyImpl(JobPropertyImpl other, AbstractProject<?, ?> owner) throws Descriptor.FormException, IOException {
        this.owner = owner;
        this.activeProcessNames.addAll(other.activeProcessNames);
        this.loadAllProcesses(other.getRootDir());
    }

    @Restricted(value={NoExternalUse.class})
    public JobPropertyImpl(Set<String> activeProcessNames) {
        this.activeProcessNames.addAll(activeProcessNames);
    }

    private JobPropertyImpl(StaplerRequest req, JSONObject json) throws Descriptor.FormException, IOException {
        List ancs = req.getAncestors();
        Object ancestor = ((Ancestor)ancs.get(ancs.size() - 1)).getObject();
        if (!(ancestor instanceof AbstractProject)) {
            if (ancestor == null) {
                throw new Descriptor.FormException("Cannot retrieve the ancestor item in the request", "owner");
            }
            throw new Descriptor.FormException("Cannot create Promoted Builds Job Property for " + ancestor.getClass() + ". Currently the plugin supports instances of AbstractProject only." + ". Other job types are not supported, submit a bug to the plugin, which provides the job type" + ". If you use Multi-Branch Project plugin, see https://issues.jenkins-ci.org/browse/JENKINS-32237", "owner");
        }
        this.owner = (AbstractProject)ancestor;
        if (json.has("promotions")) {
            json = json.getJSONObject("promotions");
        }
        for (Object o : JSONArray.fromObject((Object)json.get("activeItems"))) {
            PromotionProcess p;
            JSONObject c = (JSONObject)o;
            String name = c.getString("name");
            try {
                Hudson.checkGoodName((String)name);
            }
            catch (Failure f) {
                throw new Descriptor.FormException(f.getMessage(), name);
            }
            this.activeProcessNames.add(name);
            try {
                p = (PromotionProcess)Items.load((ItemGroup)this, (File)this.getRootDirFor(name));
            }
            catch (IOException e) {
                p = new PromotionProcess(this, name);
            }
            p.configure(req, c);
            this.safeAddToProcessesList(p);
        }
        this.init();
    }

    private void loadAllProcesses(File rootDir) throws IOException {
        File[] subdirs = rootDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File child) {
                return child.isDirectory();
            }
        });
        this.loadProcesses(subdirs);
    }

    private void init() throws IOException {
        File[] subdirs = this.getRootDir().listFiles(new FileFilter(){

            @Override
            public boolean accept(File child) {
                return child.isDirectory() && !JobPropertyImpl.this.isActiveProcessNameIgnoreCase(child.getName());
            }
        });
        this.loadProcesses(subdirs);
    }

    private void loadProcesses(File[] subdirs) throws IOException {
        if (subdirs != null) {
            for (File subdir : subdirs) {
                try {
                    PromotionProcess p = (PromotionProcess)Items.load((ItemGroup)this, (File)subdir);
                    this.safeAddToProcessesList(p);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to load promotion process in " + subdir, e);
                }
            }
        }
        this.buildActiveProcess();
    }

    public synchronized PromotionProcess addProcess(String name) throws IOException {
        PromotionProcess p = new PromotionProcess(this, name);
        this.activeProcessNames.add(name);
        this.safeAddToProcessesList(p);
        this.buildActiveProcess();
        p.onCreatedFromScratch();
        return p;
    }

    private synchronized void safeAddToProcessesList(PromotionProcess p) {
        int index = 0;
        boolean found = false;
        ListIterator<PromotionProcess> i = this.processes.listIterator();
        while (i.hasNext()) {
            PromotionProcess process = i.next();
            if (p.getName().equalsIgnoreCase(process.getName())) {
                found = true;
                try {
                    i.set(p);
                }
                catch (UnsupportedOperationException e) {
                    this.processes.set(index, p);
                }
                break;
            }
            ++index;
        }
        if (!found) {
            this.processes.add(p);
        }
    }

    protected synchronized void setOwner(AbstractProject<?, ?> owner) {
        super.setOwner(owner);
        this.processes = new ArrayList(ItemGroupMixIn.loadChildren((ItemGroup)this, (File)this.getRootDir(), (Function1)ItemGroupMixIn.KEYED_BY_NAME).values());
        try {
            this.buildActiveProcess();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private void buildActiveProcess() throws IOException {
        this.activeProcesses = new ArrayList<PromotionProcess>();
        Iterator<PromotionProcess> i$ = this.processes.iterator();
        while (i$.hasNext()) {
            String processName;
            String activeProcessName;
            PromotionProcess p;
            boolean active = this.isActiveProcessNameIgnoreCase((p = i$.next()).getName());
            p.makeDisabled(!active);
            if (active) {
                this.activeProcesses.add(p);
            }
            if ((activeProcessName = this.getActiveProcessName(processName = p.getName())).equals(processName)) continue;
            p.renameTo(activeProcessName);
        }
    }

    private synchronized String getActiveProcessName(String s) {
        for (String n : this.activeProcessNames) {
            if (!n.equalsIgnoreCase(s)) continue;
            return n;
        }
        return s;
    }

    private synchronized boolean isActiveProcessNameIgnoreCase(String s) {
        for (String n : this.activeProcessNames) {
            if (!n.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public synchronized List<PromotionProcess> getItems() {
        return this.processes;
    }

    public List<PromotionProcess> getActiveItems() {
        return this.activeProcesses;
    }

    public PromotionProcess createProcessFromXml(final String name, InputStream xml) throws IOException {
        ((AbstractProject)this.owner).checkPermission(Item.CONFIGURE);
        Jenkins.getInstance().getProjectNamingStrategy().checkName(name);
        if (this.getItem(name) != null) {
            throw new IllegalArgumentException(((AbstractProject)this.owner).getDisplayName() + " already contains an item '" + name + "'");
        }
        File configXml = Items.getConfigFile((File)this.getRootDirFor(name)).getFile();
        File dir = configXml.getParentFile();
        if (!dir.mkdirs()) {
            throw new IOException("Cannot create directories for " + dir);
        }
        try {
            IOUtils.copy((InputStream)xml, (File)configXml);
            PromotionProcess result = (PromotionProcess)((Object)Items.whileUpdatingByXml((Callable)new Callable<PromotionProcess, IOException>(){

                public PromotionProcess call() throws IOException {
                    JobPropertyImpl.this.setOwner((AbstractProject)JobPropertyImpl.this.owner);
                    return JobPropertyImpl.this.getItem(name);
                }
            }));
            if (result == null) {
                throw new IOException("failed to load from " + configXml);
            }
            ItemListener.fireOnCreated((Item)result);
            return result;
        }
        catch (IOException e) {
            Util.deleteRecursive((File)dir);
            throw e;
        }
    }

    public synchronized AbstractProject<?, ?> getOwner() {
        return (AbstractProject)this.owner;
    }

    @CheckForNull
    public synchronized PromotionProcess getItem(String name) {
        if (this.processes == null) {
            return null;
        }
        for (PromotionProcess c : this.processes) {
            if (!StringUtils.equals((String)c.getName(), (String)name)) continue;
            return c;
        }
        return null;
    }

    public File getRootDir() {
        return new File(this.getOwner().getRootDir(), "promotions");
    }

    public void save() throws IOException {
    }

    public void onDeleted(PromotionProcess process) {
        this.setOwner((AbstractProject)this.owner);
        ItemListener.fireOnDeleted((Item)process);
    }

    public void onRenamed(PromotionProcess item, String oldName, String newName) throws IOException {
        this.setOwner((AbstractProject)this.owner);
    }

    public String getUrl() {
        return this.getOwner().getUrl() + "promotion/";
    }

    public String getFullName() {
        return this.getOwner().getFullName() + "/promotion";
    }

    public String getFullDisplayName() {
        return this.getOwner().getFullDisplayName() + " \u00bb promotion";
    }

    public String getUrlChildPrefix() {
        return "";
    }

    public File getRootDirFor(PromotionProcess child) {
        return this.getRootDirFor(child.getName());
    }

    File getRootDirFor(String name) {
        return new File(this.getRootDir(), name);
    }

    public String getDisplayName() {
        return "promotion";
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        build.addAction((Action)new PromotedBuildAction(build));
        return true;
    }

    @Deprecated
    public Action getJobAction(AbstractProject<?, ?> job) {
        return new PromotedProjectAction(job, this);
    }

    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public DescriptorImpl() {
        }

        public DescriptorImpl(Class<? extends JobProperty<?>> clazz) {
            super(clazz);
        }

        public String getDisplayName() {
            return "Promote Builds When...";
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return AbstractProject.class.isAssignableFrom(jobType);
        }

        public JobPropertyImpl newInstance(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            try {
                if (json.has("promotions")) {
                    return new JobPropertyImpl(req, json);
                }
                return null;
            }
            catch (IOException e) {
                throw new Descriptor.FormException("Failed to create", (Throwable)e, null);
            }
        }
    }
}

