/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.console.HyperlinkNote;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Environment;
import hudson.model.Node;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.User;
import hudson.plugins.promoted_builds.GlobalBuildPromotedBuilds;
import hudson.plugins.promoted_builds.Messages;
import hudson.plugins.promoted_builds.PromotedBuildAction;
import hudson.plugins.promoted_builds.PromotionBadge;
import hudson.plugins.promoted_builds.PromotionCause;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.plugins.promoted_builds.PromotionTargetAction;
import hudson.plugins.promoted_builds.PromotionTrigger;
import hudson.plugins.promoted_builds.Status;
import hudson.plugins.promoted_builds.conditions.ManualCondition;
import hudson.plugins.promoted_builds.util.JenkinsHelper;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import hudson.slaves.WorkspaceList;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildTrigger;
import hudson.tasks.BuildWrapper;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.export.Exported;

public class Promotion
extends AbstractBuild<PromotionProcess, Promotion> {
    public static final PermissionGroup PERMISSIONS = new PermissionGroup(Promotion.class, Messages._Promotion_Permissions_Title());
    public static final Permission PROMOTE = new Permission(PERMISSIONS, "Promote", Messages._Promotion_PromotePermission_Description(), Jenkins.ADMINISTER, PermissionScope.RUN);
    private static final Logger LOGGER = Logger.getLogger(Promotion.class.getName());

    public Promotion(PromotionProcess job) throws IOException {
        super((AbstractProject)job);
    }

    public Promotion(PromotionProcess job, Calendar timestamp) {
        super((AbstractProject)job, timestamp);
    }

    public Promotion(PromotionProcess project, File buildDir) throws IOException {
        super((AbstractProject)project, buildDir);
    }

    @Exported
    public AbstractBuild<?, ?> getTarget() {
        PromotionTargetAction pta = (PromotionTargetAction)this.getAction(PromotionTargetAction.class);
        return pta.resolve(this);
    }

    public AbstractBuild<?, ?> getRootBuild() {
        return this.getTarget().getRootBuild();
    }

    public String getUrl() {
        return this.getTarget().getUrl() + "promotion/" + ((PromotionProcess)this.getParent()).getName() + "/promotionBuild/" + this.getNumber() + "/";
    }

    public Status getStatus() {
        return ((PromotedBuildAction)this.getTarget().getAction(PromotedBuildAction.class)).getPromotion(((PromotionProcess)this.getParent()).getName());
    }

    public EnvVars getEnvironment(TaskListener listener) throws IOException, InterruptedException {
        EnvVars e = super.getEnvironment(listener);
        String rootUrl = JenkinsHelper.getInstance().getRootUrl();
        AbstractBuild<?, ?> target = this.getTarget();
        if (rootUrl != null) {
            e.put("PROMOTED_URL", rootUrl + target.getUrl());
        }
        e.put("PROMOTED_JOB_NAME", ((AbstractProject)target.getParent()).getName());
        e.put("PROMOTED_JOB_FULL_NAME", ((AbstractProject)target.getParent()).getFullName());
        e.put("PROMOTED_NUMBER", Integer.toString(target.getNumber()));
        e.put("PROMOTED_ID", target.getId());
        GlobalBuildPromotedBuilds globalBuildPromotedBuilds = GlobalBuildPromotedBuilds.get();
        String dateFormat = globalBuildPromotedBuilds.getDateFormat();
        String timeZone = globalBuildPromotedBuilds.getTimeZone();
        SimpleDateFormat format = null;
        TimeZone tz = null;
        if (dateFormat != null && !StringUtils.isBlank((String)dateFormat)) {
            try {
                format = new SimpleDateFormat(dateFormat);
            }
            catch (IllegalArgumentException e1) {
                LOGGER.log(Level.WARNING, String.format("An illegal date format was introduced: %s. Default ISO 8601 yyyy-MM-dd'T'HH:mmZ will be used", dateFormat), e1);
                format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
            }
        } else {
            format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
        }
        if (timeZone != null && !StringUtils.isBlank((String)timeZone)) {
            try {
                tz = TimeZone.getTimeZone(timeZone);
            }
            catch (IllegalArgumentException e2) {
                LOGGER.log(Level.WARNING, String.format("An illegal time zone was introduced: %s. Default GMT time zone will be used", timeZone), e2);
                tz = TimeZone.getTimeZone("GMT");
            }
        } else {
            tz = TimeZone.getTimeZone("GMT");
        }
        format.setTimeZone(tz);
        e.put("PROMOTED_TIMESTAMP", format.format(new Date()));
        e.put("PROMOTED_DISPLAY_NAME", target.getDisplayName());
        e.put("PROMOTED_USER_NAME", this.getUserName());
        e.put("PROMOTED_USER_ID", this.getUserId());
        EnvVars envScm = new EnvVars();
        target.getProject().getScm().buildEnvVars(target, (Map)envScm);
        for (Map.Entry entry : envScm.entrySet()) {
            e.put("PROMOTED_" + (String)entry.getKey(), (String)entry.getValue());
        }
        this.getStatus().buildEnvVars(this, e);
        return e;
    }

    @Nonnull
    public String getUserName() {
        String nameFromUserIdCause;
        String nameFromUserCause;
        Cause.UserCause userCause = (Cause.UserCause)this.getCause(Cause.UserCause.class);
        String string = nameFromUserCause = userCause != null ? userCause.getUserName() : null;
        if (nameFromUserCause != null) {
            return nameFromUserCause;
        }
        Cause.UserIdCause userIdCause = (Cause.UserIdCause)this.getCause(Cause.UserIdCause.class);
        String string2 = nameFromUserIdCause = userIdCause != null ? userIdCause.getUserName() : null;
        if (nameFromUserIdCause != null) {
            return nameFromUserIdCause;
        }
        for (PromotionBadge badget : this.getStatus().getBadges()) {
            String nameFromBadge;
            if (!(badget instanceof ManualCondition.Badge) || (nameFromBadge = ((ManualCondition.Badge)badget).getUserName()).equals("N/A")) continue;
            return nameFromBadge;
        }
        return Jenkins.ANONYMOUS.getName();
    }

    @Nonnull
    public String getUserId() {
        String idFromUserIdCause;
        User user;
        Cause.UserCause userCause = (Cause.UserCause)this.getCause(Cause.UserCause.class);
        String nameFromUserCause = userCause != null ? userCause.getUserName() : null;
        User user2 = user = nameFromUserCause != null ? User.get((String)nameFromUserCause, (boolean)false, null) : null;
        if (user != null) {
            return user.getId();
        }
        Cause.UserIdCause userIdCause = (Cause.UserIdCause)this.getCause(Cause.UserIdCause.class);
        String string = idFromUserIdCause = userIdCause != null ? userIdCause.getUserId() : null;
        if (idFromUserIdCause != null) {
            return idFromUserIdCause;
        }
        for (PromotionBadge badget : this.getStatus().getBadges()) {
            String idFromBadge;
            if (!(badget instanceof ManualCondition.Badge) || (idFromBadge = ((ManualCondition.Badge)badget).getUserId()).equals("N/A")) continue;
            return idFromBadge;
        }
        return User.getUnknown().getId();
    }

    public List<ParameterValue> getParameterValues() {
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        ParametersAction parametersAction = Promotion.getParametersActions(this);
        if (parametersAction != null) {
            ManualCondition manualCondition = (ManualCondition)((PromotionProcess)this.getProject()).getPromotionCondition(ManualCondition.class.getName());
            if (manualCondition != null) {
                for (ParameterValue pvalue : parametersAction.getParameters()) {
                    if (manualCondition.getParameterDefinition(pvalue.getName()) == null) continue;
                    values.add(pvalue);
                }
            }
            return values;
        }
        for (PromotionBadge badget : this.getStatus().getBadges()) {
            if (!(badget instanceof ManualCondition.Badge)) continue;
            return ((ManualCondition.Badge)badget).getParameterValues();
        }
        return Collections.emptyList();
    }

    @Nonnull
    public List<ParameterDefinition> getParameterDefinitionsWithValue() {
        ArrayList<ParameterDefinition> definitions = new ArrayList<ParameterDefinition>();
        ManualCondition manualCondition = (ManualCondition)((PromotionProcess)this.getProject()).getPromotionCondition(ManualCondition.class.getName());
        if (manualCondition == null) {
            return definitions;
        }
        for (ParameterValue pvalue : this.getParameterValues()) {
            ParameterDefinition pdef = manualCondition.getParameterDefinition(pvalue.getName());
            if (pdef == null) continue;
            definitions.add(pdef.copyWithDefaultValue(pvalue));
        }
        return definitions;
    }

    public void run() {
        this.getStatus().addPromotionAttempt(this);
        this.run((Run.Runner)new RunnerImpl(this));
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Promotion other = (Promotion)((Object)obj);
        return this.getId().equals(other.getId());
    }

    public static ParametersAction createParametersAction(List<ParameterValue> parameters) {
        return new ParametersAction(parameters);
    }

    public static ParametersAction getParametersActions(Promotion build) {
        return (ParametersAction)build.getAction(ParametersAction.class);
    }

    @Deprecated
    public static void buildParametersAction(@Nonnull List<Action> actions, @Nonnull AbstractBuild<?, ?> build, @CheckForNull List<ParameterValue> promotionParams) {
        actions.add((Action)PromotionParametersAction.buildFor(build, promotionParams));
    }

    @Restricted(value={NoExternalUse.class})
    public static class PromotionParametersAction
    extends ParametersAction {
        private List<ParameterValue> unfilteredParameters;

        private PromotionParametersAction(List<ParameterValue> params) {
            super(params);
            this.unfilteredParameters = params;
        }

        public List<ParameterValue> getParameters() {
            return Collections.unmodifiableList(this.filter(this.unfilteredParameters));
        }

        private List<ParameterValue> filter(List<ParameterValue> params) {
            return params;
        }

        public static PromotionParametersAction buildFor(@Nonnull AbstractBuild<?, ?> buildToBePromoted, @CheckForNull List<ParameterValue> promotionParams) {
            if (promotionParams == null) {
                promotionParams = new ArrayList<ParameterValue>();
            }
            ArrayList<ParameterValue> params = new ArrayList<ParameterValue>();
            List parameters = buildToBePromoted.getActions(ParametersAction.class);
            for (ParametersAction paramAction : parameters) {
                for (ParameterValue pvalue : paramAction.getParameters()) {
                    if (promotionParams.contains(pvalue)) continue;
                    params.add(pvalue);
                }
            }
            params.addAll(promotionParams);
            return new PromotionParametersAction(params);
        }
    }

    protected class RunnerImpl
    extends AbstractBuild.AbstractRunner {
        final Promotion promotionRun;

        RunnerImpl(Promotion promotionRun) {
            super((AbstractBuild)Promotion.this);
            this.promotionRun = promotionRun;
        }

        protected WorkspaceList.Lease decideWorkspace(Node n, WorkspaceList wsl) throws InterruptedException, IOException {
            String customWorkspace = ((PromotionProcess)Promotion.this.getProject()).getCustomWorkspace();
            if (customWorkspace != null) {
                FilePath rootPath = n.getRootPath();
                if (rootPath == null) {
                    throw new IOException("Cannot retrieve the root path of the node " + n);
                }
                return WorkspaceList.Lease.createDummyLease((FilePath)rootPath.child(Promotion.this.getEnvironment((TaskListener)this.listener).expand(customWorkspace)));
            }
            TopLevelItem item = (TopLevelItem)Promotion.this.getTarget().getProject();
            FilePath workspace = n.getWorkspaceFor(item);
            if (workspace == null) {
                throw new IOException("Cannot retrieve workspace for " + item + " on the node " + n);
            }
            return wsl.allocate(workspace, (Object)this.promotionRun);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Result doRun(BuildListener listener) throws Exception {
            AbstractBuild<?, ?> target = Promotion.this.getTarget();
            listener.getLogger().println(Messages.Promotion_RunnerImpl_Promoting(HyperlinkNote.encodeTo((String)('/' + target.getUrl()), (String)target.getFullDisplayName())));
            Promotion.this.setResult(Result.SUCCESS);
            if (!this.preBuild(listener, ((PromotionProcess)Promotion.this.project).getBuildSteps())) {
                return Result.FAILURE;
            }
            try {
                Result result;
                List<ParameterValue> params = Promotion.this.getParameterValues();
                if (params != null) {
                    for (ParameterValue value : params) {
                        BuildWrapper wrapper = value.createBuildWrapper((AbstractBuild)Promotion.this);
                        if (wrapper == null) continue;
                        BuildWrapper.Environment e = wrapper.setUp((AbstractBuild)Promotion.this, this.launcher, listener);
                        if (e == null) {
                            Result result2 = Result.FAILURE;
                            return result2;
                        }
                        Promotion.this.buildEnvironments.add(e);
                    }
                }
                if (!this.build(listener, ((PromotionProcess)Promotion.this.project).getBuildSteps(), (Run)target)) {
                    result = Result.FAILURE;
                    return result;
                }
                result = null;
                return result;
            }
            finally {
                boolean failed = false;
                for (int i = Promotion.this.buildEnvironments.size() - 1; i >= 0; --i) {
                    if (((Environment)Promotion.this.buildEnvironments.get(i)).tearDown((AbstractBuild)Promotion.this, listener)) continue;
                    failed = true;
                }
                if (failed) {
                    return Result.FAILURE;
                }
            }
        }

        protected void post2(BuildListener listener) throws Exception {
            if (Promotion.this.getResult() == Result.SUCCESS) {
                Promotion.this.getStatus().onSuccessfulPromotion(Promotion.this);
            }
            Promotion.this.getTarget().save();
            if (Promotion.this.getResult() == Result.SUCCESS) {
                PromotedBuildAction pba = (PromotedBuildAction)Promotion.this.getTarget().getAction(PromotedBuildAction.class);
                for (PromotionProcess pp : pba.getPendingPromotions()) {
                    pp.considerPromotion2(Promotion.this.getTarget());
                }
                for (AbstractProject p : JenkinsHelper.getInstance().getAllItems(AbstractProject.class)) {
                    PromotionTrigger pt = (PromotionTrigger)p.getTrigger(PromotionTrigger.class);
                    if (pt == null) continue;
                    pt.consider(Promotion.this);
                }
            }
        }

        private boolean build(BuildListener listener, List<BuildStep> steps, Run promotedBuild) throws IOException, InterruptedException {
            for (BuildStep bs : steps) {
                if (bs instanceof BuildTrigger) {
                    BuildTrigger bt = (BuildTrigger)bs;
                    for (AbstractProject p : bt.getChildProjects()) {
                        listener.getLogger().println(Messages.Promotion_RunnerImpl_SchedulingBuild(HyperlinkNote.encodeTo((String)('/' + p.getUrl()), (String)p.getDisplayName())));
                        p.scheduleBuild(0, (Cause)new PromotionCause(this.promotionRun, promotedBuild));
                    }
                    continue;
                }
                if (!bs.perform((AbstractBuild)Promotion.this, this.launcher, listener)) {
                    listener.getLogger().println("failed build " + bs + " " + Promotion.this.getResult());
                    return false;
                }
                listener.getLogger().println("build " + bs + " " + Promotion.this.getResult());
            }
            return true;
        }

        private boolean preBuild(BuildListener listener, List<BuildStep> steps) {
            for (BuildStep bs : steps) {
                if (bs.prebuild((AbstractBuild)Promotion.this, listener)) continue;
                listener.getLogger().println("failed pre build " + bs + " " + Promotion.this.getResult());
                return false;
            }
            return true;
        }
    }
}

