/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.InvisibleAction;
import hudson.plugins.promoted_builds.Promotion;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.plugins.promoted_builds.util.JenkinsHelper;
import javax.annotation.CheckForNull;

public class PromotionTargetAction
extends InvisibleAction {
    private final String jobName;
    private final int number;

    public PromotionTargetAction(AbstractBuild<?, ?> build) {
        this.jobName = ((AbstractProject)build.getParent()).getFullName();
        this.number = build.getNumber();
    }

    @CheckForNull
    public AbstractBuild<?, ?> resolve() {
        AbstractProject j = (AbstractProject)JenkinsHelper.getInstance().getItemByFullName(this.jobName, AbstractProject.class);
        if (j == null) {
            return null;
        }
        return j.getBuildByNumber(this.number);
    }

    @CheckForNull
    public AbstractBuild<?, ?> resolve(PromotionProcess parent) {
        AbstractBuild<?, ?> build = this.resolve();
        if (build != null) {
            return build;
        }
        AbstractProject<?, ?> j = parent.getOwner();
        if (j == null) {
            return null;
        }
        return j.getBuildByNumber(this.number);
    }

    public AbstractBuild<?, ?> resolve(Promotion parent) {
        return this.resolve((PromotionProcess)parent.getParent());
    }
}

