/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds.parameters;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.Run;
import hudson.model.SimpleParameterDefinition;
import hudson.plugins.promoted_builds.JobPropertyImpl;
import hudson.plugins.promoted_builds.Messages;
import hudson.plugins.promoted_builds.PromotedBuildAction;
import hudson.plugins.promoted_builds.PromotedProjectAction;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.plugins.promoted_builds.parameters.PromotedBuildParameterValue;
import hudson.plugins.promoted_builds.util.ItemPathResolver;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class PromotedBuildParameterDefinition
extends SimpleParameterDefinition {
    private final String projectName;
    private final String promotionProcessName;

    @DataBoundConstructor
    public PromotedBuildParameterDefinition(String name, String jobName, String process, String description) {
        super(name, description);
        this.projectName = jobName;
        this.promotionProcessName = process;
    }

    public PromotedBuildParameterValue createValue(StaplerRequest req, JSONObject jo) {
        PromotedBuildParameterValue value = (PromotedBuildParameterValue)((Object)req.bindJSON(PromotedBuildParameterValue.class, jo));
        value.setPromotionProcessName(this.promotionProcessName);
        value.setDescription(this.getDescription());
        return value;
    }

    public PromotedBuildParameterValue createValue(String value) {
        PromotedBuildParameterValue p = new PromotedBuildParameterValue(this.getName(), value, this.getDescription());
        p.setPromotionProcessName(this.promotionProcessName);
        return p;
    }

    public PromotedBuildParameterValue getDefaultParameterValue() {
        List builds = this.getBuilds();
        if (builds.isEmpty()) {
            return null;
        }
        return this.createValue(((Run)builds.get(0)).getExternalizableId());
    }

    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        if (defaultValue instanceof PromotedBuildParameterValue) {
            PromotedBuildParameterValue value = (PromotedBuildParameterValue)defaultValue;
            return new PromotedBuildParameterDefinition(this.getName(), value.getRunId(), value.getPromotionProcessName(), this.getDescription());
        }
        return this;
    }

    @Exported
    public String getJobName() {
        return this.projectName;
    }

    @Exported
    public String getProcess() {
        return this.promotionProcessName;
    }

    @Nonnull
    @Deprecated
    public List getBuilds() {
        StaplerRequest currentRequest = Stapler.getCurrentRequest();
        Item item = currentRequest != null ? (Item)currentRequest.findAncestorObject(Item.class) : null;
        return this.getRuns(item);
    }

    @Nonnull
    public List<Run<?, ?>> getRuns(@CheckForNull Item base) {
        ArrayList runs = new ArrayList();
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            return runs;
        }
        AbstractProject job = ItemPathResolver.getByPath(this.projectName, base, AbstractProject.class);
        if (job == null) {
            return runs;
        }
        PromotedProjectAction promotedProjectAction = (PromotedProjectAction)job.getAction(PromotedProjectAction.class);
        if (promotedProjectAction == null) {
            return runs;
        }
        block0: for (Run run : job.getBuilds()) {
            List actions = run.getActions(PromotedBuildAction.class);
            for (PromotedBuildAction buildAction : actions) {
                if (!buildAction.contains(this.promotionProcessName)) continue;
                runs.add(run);
                continue block0;
            }
        }
        return runs;
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Promoted Build Parameter";
        }

        public String getHelpFile() {
            return "/plugin/promoted-builds/parameter/promotion.html";
        }

        public ParameterDefinition newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (ParameterDefinition)req.bindJSON(PromotedBuildParameterDefinition.class, formData);
        }

        public FormValidation doCheckJobName(@AncestorInPath Item project, @QueryParameter String value) {
            AbstractProject p;
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                return FormValidation.error((String)"Jenkins instance is not ready");
            }
            if (!project.hasPermission(Item.CONFIGURE) && project.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.ok();
            }
            project.checkPermission(Item.CONFIGURE);
            if (StringUtils.isNotBlank((String)value) && (p = ItemPathResolver.getByPath(value, project, AbstractProject.class)) == null) {
                AbstractProject nearest = AbstractProject.findNearest((String)value, (ItemGroup)project.getParent());
                return FormValidation.error((String)(nearest != null ? hudson.tasks.Messages.BuildTrigger_NoSuchProject((Object)value, (Object)nearest.getFullName()) : Messages.Shared_noSuchProject(value)));
            }
            return FormValidation.ok();
        }

        @Restricted(value={NoExternalUse.class})
        public AutoCompletionCandidates doAutoCompleteJobName(@AncestorInPath @CheckForNull Item project, @QueryParameter String value) {
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null || project == null || !project.hasPermission(Item.CONFIGURE)) {
                return candidates;
            }
            for (AbstractProject job : jenkins.getAllItems(AbstractProject.class)) {
                if (!job.getFullName().contains(value) || !job.hasPermission(Item.READ)) continue;
                candidates.add(job.getFullName());
            }
            return candidates;
        }

        public ListBoxModel doFillProcessItems(@AncestorInPath Job defaultJob, @QueryParameter(value="jobName") String jobName) {
            JobPropertyImpl pp;
            ListBoxModel r = new ListBoxModel();
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                return r;
            }
            if (!defaultJob.hasPermission(Item.CONFIGURE) && defaultJob.hasPermission(Item.EXTENDED_READ)) {
                return r;
            }
            defaultJob.checkPermission(Item.CONFIGURE);
            AbstractProject j = null;
            if (jobName != null) {
                j = ItemPathResolver.getByPath(jobName, (Item)defaultJob, AbstractProject.class);
            }
            if (j != null && (pp = (JobPropertyImpl)j.getProperty(JobPropertyImpl.class)) != null) {
                for (PromotionProcess proc : pp.getActiveItems()) {
                    r.add((Object)new ListBoxModel.Option(proc.getDisplayName(), proc.getName()));
                }
            }
            return r;
        }
    }
}

