/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_ssh;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

class BapSshTransferCacheRow {
    public byte[] HashValue;
    public long LastModified;

    public BapSshTransferCacheRow() {
    }

    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Backwards compatibility")
    public BapSshTransferCacheRow(File fileRef) {
        this.HashValue = this.getHashValue(fileRef);
        try {
            this.LastModified = Files.getLastModifiedTime(fileRef.toPath(), new LinkOption[0]).toMillis();
        }
        catch (IOException ex) {
            this.LastModified = 0L;
        }
    }

    private byte[] getHashValue(File fileRef) {
        try {
            byte[] tmpBuffer = new byte[8192];
            MessageDigest md = MessageDigest.getInstance("MD5");
            try (InputStream is = Files.newInputStream(fileRef.toPath(), new OpenOption[0]);
                 DigestInputStream dis = new DigestInputStream(is, md);){
                while (dis.available() > 0) {
                    dis.read(tmpBuffer, 0, 8192);
                }
            }
            return md.digest();
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            return null;
        }
    }

    public boolean mustUpdateWith(File fileRef) {
        try {
            long newModifiedTime = Files.getLastModifiedTime(fileRef.toPath(), new LinkOption[0]).toMillis();
            if (newModifiedTime <= this.LastModified) {
                return false;
            }
        }
        catch (IOException ex) {
            return false;
        }
        byte[] newHashValue = this.getHashValue(fileRef);
        if (Arrays.equals(this.HashValue, newHashValue)) {
            return false;
        }
        try {
            this.LastModified = Files.getLastModifiedTime(fileRef.toPath(), new LinkOption[0]).toMillis();
        }
        catch (IOException ex) {
            this.LastModified = 0L;
        }
        this.HashValue = newHashValue;
        return true;
    }
}

