/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot.model;

import hudson.model.Run;
import hudson.plugins.robot.RobotConfig;
import hudson.plugins.robot.graph.RobotGraph;
import hudson.plugins.robot.graph.RobotGraphHelper;
import hudson.plugins.robot.model.RobotSuiteResult;
import hudson.plugins.robot.model.RobotTestObject;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class RobotCaseResult
extends RobotTestObject {
    private static final long serialVersionUID = -8075680639442547520L;
    private static final Logger LOGGER = Logger.getLogger((String)RobotCaseResult.class.getName());
    private boolean passed;
    private boolean skipped;
    private boolean critical;
    private String errorMsg;
    private String name;
    private String description;
    private String starttime;
    private String endtime;
    private double elapsedtime;
    private List<String> tags;
    private String stackTrace;
    private RobotSuiteResult parent;
    private int failedSince;

    public static long timeDifference(String time1, String time2) throws ParseException {
        long difference = 0L;
        String dateFormat = "yyyyMMdd HH:mm:ss.SS";
        SimpleDateFormat format = new SimpleDateFormat(dateFormat);
        Date startDate = format.parse(time1);
        Date endDate = format.parse(time2);
        difference = endDate.getTime() - startDate.getTime();
        return difference;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public RobotTestObject getParent() {
        return this.parent;
    }

    public void setParent(RobotSuiteResult parent) {
        this.parent = parent;
    }

    @Override
    public long getDuration() {
        if (this.duration != 0L) {
            return this.duration;
        }
        if (this.elapsedtime != 0.0) {
            return Double.valueOf(this.elapsedtime * 1000.0).longValue();
        }
        try {
            return RobotCaseResult.timeDifference(this.starttime, this.endtime);
        }
        catch (ParseException e) {
            LOGGER.warn((Object)("Couldn't parse duration for test case " + this.name));
            return 0L;
        }
    }

    public String getStarttime() {
        return this.starttime;
    }

    public void setStarttime(String starttime) {
        this.starttime = starttime;
    }

    public String getEndtime() {
        return this.endtime;
    }

    public void setEndtime(String endtime) {
        this.endtime = endtime;
    }

    public double getElapsedtime() {
        return this.elapsedtime;
    }

    public void setElapsedTime(String elapsed) {
        this.elapsedtime = Double.parseDouble(elapsed);
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public void setPassed(boolean passed) {
        this.passed = passed;
    }

    public void setSkipped(boolean skipped) {
        this.skipped = skipped;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getSearchUrl() {
        return this.getName();
    }

    public boolean isPassed() {
        return this.passed;
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public List<String> getTags() {
        if (this.tags == null) {
            return new ArrayList<String>();
        }
        return this.tags;
    }

    public String getCommaSeparatedTags() {
        List<String> tags = this.getTags();
        if (tags.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (String tag : tags) {
            buf.append(tag + ", ");
        }
        String result = buf.toString();
        return result.substring(0, result.length() - 2);
    }

    public void addTags(List<String> taglist) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.addAll(taglist);
    }

    public int getFailedSince() {
        if (this.failedSince == 0 && !this.isPassed() && !this.isSkipped()) {
            RobotCaseResult previous = this.getPreviousResult();
            if (previous != null && !previous.isPassed()) {
                this.failedSince = previous.getFailedSince();
            } else if (this.getOwner() != null) {
                this.failedSince = this.getOwner().getNumber();
            } else {
                LOGGER.warn((Object)"trouble calculating getFailedSince. We've got prev, but no owner.");
            }
        }
        return this.failedSince;
    }

    public void setFailedSince(int failedSince) {
        this.failedSince = failedSince;
    }

    @Override
    public RobotCaseResult getPreviousResult() {
        if (this.parent == null) {
            return null;
        }
        RobotSuiteResult prevParent = this.parent.getPreviousResult();
        if (prevParent == null) {
            return null;
        }
        RobotCaseResult result = prevParent.getCase(this.getDuplicateSafeName());
        if (result == null) {
            result = prevParent.getCase(this.getOldFormatName());
        }
        return result;
    }

    public Run<?, ?> getFailedSinceRun() {
        return this.getOwner().getParent().getBuildByNumber(this.getFailedSince());
    }

    public int getAge() {
        if (this.isPassed()) {
            return 0;
        }
        Run<?, ?> owner = this.getOwner();
        if (owner != null) {
            return this.getOwner().getNumber() - this.getFailedSince() + 1;
        }
        return 0;
    }

    @Override
    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (!this.isNeedToGenerate(req, rsp)) {
            return;
        }
        String label = this.getParentAction().getxAxisLabel();
        String labelFormat = StringUtils.isBlank((String)label) ? RobotConfig.getInstance().getXAxisLabelFormat() : label;
        RobotGraph g = RobotGraphHelper.createTestResultsGraphForTestObject(this, false, true, Boolean.parseBoolean(req.getParameter("hd")), false, false, labelFormat, Integer.parseInt(req.getParameter("maxBuildsToShow")));
        g.doPng(req, rsp);
    }

    @Override
    public int getFailed() {
        if (this.isPassed() || this.isSkipped()) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getPassed() {
        if (this.isPassed()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getSkipped() {
        if (this.isSkipped()) {
            return 1;
        }
        return 0;
    }

    @Override
    public long getCriticalFailed() {
        if (!this.isPassed() && !this.isSkipped() && this.isCritical()) {
            return 1L;
        }
        return 0L;
    }

    @Override
    public long getCriticalPassed() {
        if (this.isPassed() && this.isCritical()) {
            return 1L;
        }
        return 0L;
    }
}

