/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot.view;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.robot.RobotBuildAction;
import hudson.plugins.robot.RobotConfig;
import hudson.plugins.robot.model.RobotResult;
import hudson.views.ListViewColumn;
import javax.inject.Inject;
import org.kohsuke.stapler.DataBoundConstructor;

public class RobotListViewColumn
extends ListViewColumn {
    @DataBoundConstructor
    public RobotListViewColumn() {
    }

    public String getColumnCaption() {
        return this.getDescriptor().getDisplayName();
    }

    public long getPass(Item job) {
        RobotResult lastRobotResult = this.getLastRobotResult(job);
        return lastRobotResult != null ? lastRobotResult.getOverallPassed() : 0L;
    }

    public long getTotal(Item job) {
        RobotResult lastRobotResult = this.getLastRobotResult(job);
        return lastRobotResult != null ? lastRobotResult.getOverallTotal() : 0L;
    }

    public long getSkipped(Item job) {
        RobotResult lastRobotResult = this.getLastRobotResult(job);
        return lastRobotResult != null ? lastRobotResult.getOverallSkipped() : 0L;
    }

    public double getPassPercent(Item job) {
        RobotResult lastRobotResult = this.getLastRobotResult(job);
        return lastRobotResult != null ? lastRobotResult.getPassPercentage() : 100.0;
    }

    public double getSkipPercent(Item job) {
        RobotResult lastRobotResult = this.getLastRobotResult(job);
        return lastRobotResult != null ? lastRobotResult.getSkipPercentage() : 0.0;
    }

    public String getRobotPath(Item job) {
        if (job instanceof Job) {
            Run build = ((Job)job).getLastCompletedBuild();
            int lastBuildNr = build == null ? 1 : build.number;
            return job.getShortUrl() + lastBuildNr + "/robot/";
        }
        return null;
    }

    public String getLogUrl(Item job) {
        return this.getRobotPath(job) + "report/log.html";
    }

    public String getTrendUrl(Item job) {
        return this.getRobotPath(job) + "durationGraph?maxBuildsToShow=" + this.getBuildsToShowInResultsColumn();
    }

    public String getTrendHdUrl(Item job) {
        return this.getTrendUrl(job) + "&hd";
    }

    public String getTrendPreviewUrl(Item job) {
        return this.getTrendUrl(job) + "&preview";
    }

    private RobotResult getLastRobotResult(Item job) {
        RobotBuildAction action;
        Run build;
        if (job instanceof Job && (build = ((Job)job).getLastCompletedBuild()) != null && (action = (RobotBuildAction)build.getAction(RobotBuildAction.class)) != null) {
            return action.getResult();
        }
        return null;
    }

    public int getBuildsToShowInResultsColumn() {
        return ((DescriptorImpl)this.getDescriptor()).getBuildsToShowInResultsColumn();
    }

    public boolean isRobotResultsColumnEnabled() {
        return ((DescriptorImpl)this.getDescriptor()).isRobotResultsColumnEnabled();
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<ListViewColumn> {
        @Inject
        private RobotConfig globalConfig;

        public String getDisplayName() {
            return "Robot pass/fail";
        }

        public boolean isRobotResultsColumnEnabled() {
            return this.globalConfig.isRobotResultsColumnEnabled();
        }

        public int getBuildsToShowInResultsColumn() {
            return this.globalConfig.getBuildsToShowInResultsColumn();
        }
    }
}

