/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot.graph;

import hudson.model.Run;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

public class RobotGraph
extends Graph {
    private final String yLabel;
    private final String xLabel;
    private final CategoryDataset categoryDataset;
    private Color[] colors;
    private boolean binaryData;
    private double lowerBound;
    private double upperBound;
    private int fontSize;
    private boolean preview;
    public static final int DEFAULT_CHART_WIDTH = 500;
    public static final int DEFAULT_CHART_HEIGHT = 200;
    public static final int DEFAULT_FONT_SIZE = 12;

    public static RobotGraph getRobotGraph(Run<?, ?> owner, CategoryDataset categoryDataset, String yLabel, String xLabel, double scale, boolean preview, boolean binaryData, double lowerBound, double upperBound, Color ... colors) {
        int width = (int)(scale * 500.0);
        int heigth = (int)(scale * 200.0);
        int fontSize = (int)(Math.sqrt(scale) * 12.0);
        return new RobotGraph(owner, categoryDataset, yLabel, xLabel, width, heigth, fontSize, preview, binaryData, lowerBound, upperBound, colors);
    }

    private RobotGraph(Run<?, ?> owner, CategoryDataset categoryDataset, String yLabel, String xLabel, int chartWidth, int chartHeight, int fontSize, boolean preview, boolean binaryData, double lowerBound, double upperBound, Color ... colors) {
        super(owner.getTimestamp(), chartWidth, chartHeight);
        this.yLabel = yLabel;
        this.xLabel = xLabel;
        this.categoryDataset = categoryDataset;
        this.colors = colors;
        this.binaryData = binaryData;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.fontSize = fontSize;
        this.preview = preview;
    }

    public CategoryDataset getDataset() {
        return this.categoryDataset;
    }

    protected JFreeChart createGraph() {
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)(this.preview ? null : this.yLabel), (CategoryDataset)this.categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (!this.preview ? 1 : 0) != 0, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        Font font = new Font("Dialog", 0, this.fontSize);
        this.setLegend(chart, font);
        CategoryPlot plot = this.initPlot(chart);
        this.setXaxis(font, plot);
        this.setYaxis(font, plot);
        CategoryItemRenderer renderer = plot.getRenderer();
        for (int i = 0; i < this.colors.length; ++i) {
            renderer.setSeriesPaint(i, (Paint)this.colors[i]);
        }
        RectangleInsets bounds = this.preview ? RectangleInsets.ZERO_INSETS : new RectangleInsets(15.0, 0.0, 0.0, 5.0);
        plot.setInsets(bounds);
        return chart;
    }

    private CategoryPlot initPlot(JFreeChart chart) {
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setForegroundAlpha(0.7f);
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.darkGray);
        plot.setRangeGridlinesVisible(!this.preview);
        plot.setOutlineVisible(!this.preview);
        return plot;
    }

    private void setLegend(JFreeChart chart, Font font) {
        if (this.preview) {
            chart.clearSubtitles();
        } else {
            LegendTitle legend = chart.getLegend();
            legend.setPosition(RectangleEdge.RIGHT);
            legend.setItemFont(font);
        }
    }

    private void setYaxis(Font font, CategoryPlot plot) {
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        if (this.preview) {
            rangeAxis.setVisible(false);
        } else {
            rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            if (this.binaryData) {
                rangeAxis.setUpperBound(1.0);
            } else if (this.upperBound != 0.0) {
                rangeAxis.setUpperBound(this.upperBound);
            } else {
                rangeAxis.setAutoRange(true);
            }
            rangeAxis.setLowerBound(this.lowerBound);
            rangeAxis.setLabelFont(font);
            rangeAxis.setTickLabelFont(font);
        }
    }

    private void setXaxis(Font font, CategoryPlot plot) {
        CategoryAxis domainAxis;
        if (this.preview) {
            domainAxis = new CategoryAxis();
            domainAxis.setVisible(false);
        } else {
            domainAxis = new ShiftedCategoryAxis(this.xLabel);
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
            domainAxis.setLowerMargin(0.0);
            domainAxis.setUpperMargin(0.0);
            domainAxis.setCategoryMargin(0.0);
            domainAxis.setLabelFont(font);
            domainAxis.setTickLabelFont(font);
        }
        plot.setDomainAxis(domainAxis);
    }
}

