/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.core;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.util.regex.Pattern;
import org.jenkins_ci.plugins.run_condition.Messages;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.jenkins_ci.plugins.run_condition.common.AlwaysPrebuildRunCondition;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BooleanCondition
extends AlwaysPrebuildRunCondition {
    private static final Pattern RUN_REGEX = Pattern.compile("^(1|y|yes|t|true|on|run)$");
    final String token;

    @DataBoundConstructor
    public BooleanCondition(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    @Override
    public boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        String expandedToken = Util.fixEmptyAndTrim((String)TokenMacro.expandAll(build, (TaskListener)listener, (String)this.token));
        if (expandedToken == null) {
            return false;
        }
        return RUN_REGEX.matcher(expandedToken.toLowerCase()).matches();
    }

    @Extension
    public static class BooleanConditionDescriptor
    extends RunCondition.RunConditionDescriptor {
        public String getDisplayName() {
            return Messages.booleanCondition_displayName();
        }

        public FormValidation doCheckToken(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }
    }
}

