/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import jenkins.scm.api.SCMCategory;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.mixin.ChangeRequestSCMHead;
import jenkins.scm.api.mixin.TagSCMHead;
import jenkins.scm.impl.ChangeRequestSCMHeadCategory;
import jenkins.scm.impl.TagSCMHeadCategory;
import jenkins.scm.impl.UncategorizedSCMHeadCategory;
import jenkins.util.NonLocalizable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.jvnet.localizer.Localizable;

public class SCMCategoryTest {
    @Test
    public void toDisplayName() throws Exception {
        Assert.assertThat((Object)SCMCategory.toDisplayName((SCMCategory[])new SCMHeadCategory[]{UncategorizedSCMHeadCategory.DEFAULT, ChangeRequestSCMHeadCategory.DEFAULT, TagSCMHeadCategory.DEFAULT}).toString(Locale.ENGLISH), (Matcher)Matchers.is((Object)"Branches / Change requests / Tags"));
        Assert.assertThat((Object)SCMCategory.toDisplayName((SCMCategory[])new SCMHeadCategory[]{UncategorizedSCMHeadCategory.DEFAULT, TagSCMHeadCategory.DEFAULT}).toString(Locale.ENGLISH), (Matcher)Matchers.is((Object)"Branches / Tags"));
        Assert.assertThat((Object)SCMCategory.toDisplayName((SCMCategory[])new UncategorizedSCMHeadCategory[]{UncategorizedSCMHeadCategory.DEFAULT}).toString(Locale.ENGLISH), (Matcher)Matchers.is((Object)"Branches"));
    }

    @Test
    public void toDisplayName1() throws Exception {
        Assert.assertThat((Object)SCMCategory.toDisplayName(Arrays.asList(ChangeRequestSCMHeadCategory.DEFAULT, TagSCMHeadCategory.DEFAULT, UncategorizedSCMHeadCategory.DEFAULT)).toString(Locale.ENGLISH), (Matcher)Matchers.is((Object)"Branches / Change requests / Tags"));
    }

    @Test
    public void toShortUrl() throws Exception {
        Assert.assertThat((Object)SCMCategory.toShortUrl((SCMCategory[])new SCMHeadCategory[]{UncategorizedSCMHeadCategory.DEFAULT, ChangeRequestSCMHeadCategory.DEFAULT, TagSCMHeadCategory.DEFAULT}), (Matcher)Matchers.is((Object)"change-requests_default_tags"));
    }

    @Test
    public void toShortUrl1() throws Exception {
        Assert.assertThat((Object)SCMCategory.toShortUrl(Arrays.asList(ChangeRequestSCMHeadCategory.DEFAULT, TagSCMHeadCategory.DEFAULT, UncategorizedSCMHeadCategory.DEFAULT)), (Matcher)Matchers.is((Object)"change-requests_default_tags"));
        Assert.assertThat((Object)SCMCategory.toShortUrl(Arrays.asList(TagSCMHeadCategory.DEFAULT, UncategorizedSCMHeadCategory.DEFAULT)), (Matcher)Matchers.is((Object)"default_tags"));
        Assert.assertThat((Object)SCMCategory.toShortUrl(Collections.singletonList(TagSCMHeadCategory.DEFAULT)), (Matcher)Matchers.is((Object)"tags"));
    }

    @Test
    public void group() throws Exception {
        UncategorizedSCMHeadCategory u1 = UncategorizedSCMHeadCategory.DEFAULT;
        UncategorizedSCMHeadCategory u2 = new UncategorizedSCMHeadCategory((Localizable)new NonLocalizable("foo"));
        ChangeRequestSCMHeadCategory c1 = ChangeRequestSCMHeadCategory.DEFAULT;
        ChangeRequestSCMHeadCategory c2 = new ChangeRequestSCMHeadCategory((Localizable)new NonLocalizable("bar"));
        ChangeRequestSCMHeadCategory c3 = new ChangeRequestSCMHeadCategory((Localizable)new NonLocalizable("manchu"));
        Map result = SCMCategory.group((SCMCategory[])new SCMHeadCategory[]{u1, c1, c2, c3, u2});
        Assert.assertThat(result.entrySet(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat(result.get("default"), (Matcher)Matchers.containsInAnyOrder((Object[])new SCMCategory[]{u1, u2}));
        Assert.assertThat(result.get("change-requests"), (Matcher)Matchers.containsInAnyOrder((Object[])new SCMCategory[]{c1, c2, c3}));
    }

    @Test
    public void group1() throws Exception {
        UncategorizedSCMHeadCategory u1 = UncategorizedSCMHeadCategory.DEFAULT;
        UncategorizedSCMHeadCategory u2 = new UncategorizedSCMHeadCategory((Localizable)new NonLocalizable("foo"));
        ChangeRequestSCMHeadCategory c1 = ChangeRequestSCMHeadCategory.DEFAULT;
        ChangeRequestSCMHeadCategory c2 = new ChangeRequestSCMHeadCategory((Localizable)new NonLocalizable("bar"));
        ChangeRequestSCMHeadCategory c3 = new ChangeRequestSCMHeadCategory((Localizable)new NonLocalizable("manchu"));
        TagSCMHeadCategory t1 = new TagSCMHeadCategory((Localizable)new NonLocalizable("foomanchu"));
        Map result = SCMCategory.group(Arrays.asList(u1, c1, t1, c2, c3, u2));
        Assert.assertThat(result.entrySet(), (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat(result.get("default"), (Matcher)Matchers.containsInAnyOrder((Object[])new SCMCategory[]{u1, u2}));
        Assert.assertThat(result.get("change-requests"), (Matcher)Matchers.containsInAnyOrder((Object[])new SCMCategory[]{c1, c2, c3}));
        Assert.assertThat(result.get("tags"), (Matcher)Matchers.contains((Object[])new SCMCategory[]{t1}));
    }

    @Test
    public void getName() throws Exception {
        Assert.assertThat((Object)new MySCMCategory("foomanchu", new NonLocalizable("Fu Manchu"), new NonLocalizable("Fu Manchu")).getName(), (Matcher)Matchers.is((Object)"foomanchu"));
    }

    @Test
    public void getDisplayName() throws Exception {
        Assert.assertThat((Object)new MySCMCategory("foomanchu", new NonLocalizable("Fu Manchu"), new NonLocalizable("Fu Manchu")).getDisplayName().toString(Locale.ENGLISH), (Matcher)Matchers.is((Object)"Fu Manchu"));
    }

    @Test
    public void defaultDisplayName() throws Exception {
        Assert.assertThat((Object)new MySCMCategory("foomanchu", null, new NonLocalizable("Fu Manchu")).getDisplayName().toString(Locale.ENGLISH), (Matcher)Matchers.is((Object)"Fu Manchu"));
    }

    @Test
    public void isMatch() throws Exception {
        UncategorizedSCMHeadCategory u = UncategorizedSCMHeadCategory.DEFAULT;
        ChangeRequestSCMHeadCategory c = ChangeRequestSCMHeadCategory.DEFAULT;
        TagSCMHeadCategory t = TagSCMHeadCategory.DEFAULT;
        final SCMHead mh = new SCMHead("basic");
        class TagSCMHeadImpl
        extends SCMHead
        implements TagSCMHead {
            public TagSCMHeadImpl(String name) {
                super(name);
            }

            public long getTimestamp() {
                return 0L;
            }
        }
        TagSCMHeadImpl th = new TagSCMHeadImpl("basic");
        class ChangeRequestSCMHeadImpl
        extends SCMHead
        implements ChangeRequestSCMHead {
            public ChangeRequestSCMHeadImpl(String name) {
                super(name);
            }

            @NonNull
            public String getId() {
                return "mock";
            }

            @NonNull
            public SCMHead getTarget() {
                return mh;
            }
        }
        ChangeRequestSCMHeadImpl ch = new ChangeRequestSCMHeadImpl("basic");
        Assert.assertThat((Object)u.isMatch((Object)mh, Arrays.asList(u, c, t)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)u.isMatch((Object)ch, Arrays.asList(c, u, t)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)u.isMatch((Object)th, Arrays.asList(c, u, t)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)c.isMatch((Object)mh, Arrays.asList(u, c, t)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)c.isMatch((Object)ch, Arrays.asList(c, u, t)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)c.isMatch((Object)th, Arrays.asList(c, u, t)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)t.isMatch((Object)mh, Arrays.asList(u, c, t)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)t.isMatch((Object)ch, Arrays.asList(c, u, t)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)t.isMatch((Object)th, Arrays.asList(c, u, t)), (Matcher)Matchers.is((Object)true));
    }

    private static class MySCMCategory
    extends SCMCategory<Object> {
        private NonLocalizable defaultDisplayName;

        public MySCMCategory(String name, NonLocalizable displayName, NonLocalizable defaultDisplayName) {
            super(name, (Localizable)displayName);
            this.defaultDisplayName = defaultDisplayName;
        }

        @NonNull
        protected Localizable defaultDisplayName() {
            return this.defaultDisplayName;
        }

        public boolean isMatch(@NonNull Object instance) {
            return instance != null && instance.hashCode() % 31 == 7;
        }
    }
}

