/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceObserver;
import jenkins.scm.impl.SingleSCMNavigator;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class SingleSCMNavigatorTest {
    @Test
    public void getName() throws Exception {
        Random entropy = new Random();
        String name = "foo-" + entropy.nextLong();
        SingleSCMNavigator instance = new SingleSCMNavigator(name, Collections.emptyList());
        Assert.assertThat((Object)instance.getName(), (Matcher)org.hamcrest.Matchers.is((Object)name));
    }

    @Test
    public void getSources_empty() throws Exception {
        Assert.assertThat((Object)new SingleSCMNavigator("foo", Collections.emptyList()).getSources(), (Matcher)org.hamcrest.Matchers.emptyCollectionOf(SCMSource.class));
    }

    @Test
    public void getSources_one() throws Exception {
        SCMSource s1 = (SCMSource)Mockito.mock(SCMSource.class);
        Assert.assertThat((Object)new SingleSCMNavigator("foo", Collections.singletonList(s1)).getSources(), (Matcher)org.hamcrest.Matchers.contains((Object[])new SCMSource[]{s1}));
    }

    @Test
    public void getSources_two() throws Exception {
        SCMSource s1 = (SCMSource)Mockito.mock(SCMSource.class);
        SCMSource s2 = (SCMSource)Mockito.mock(SCMSource.class);
        Assert.assertThat((Object)new SingleSCMNavigator("foo", Arrays.asList(s1, s2)).getSources(), (Matcher)org.hamcrest.Matchers.contains((Object[])new SCMSource[]{s1, s2}));
    }

    @Test
    public void visitSources_empty() throws Exception {
        SCMSourceObserver mock = (SCMSourceObserver)Mockito.mock(SCMSourceObserver.class);
        SCMSourceObserver.ProjectObserver observer = (SCMSourceObserver.ProjectObserver)Mockito.mock(SCMSourceObserver.ProjectObserver.class);
        InOrder seq = Mockito.inOrder((Object[])new Object[]{mock, observer});
        Mockito.when((Object)mock.observe("foo")).thenReturn((Object)observer);
        new SingleSCMNavigator("foo", Collections.emptyList()).visitSources(mock);
        ((SCMSourceObserver)seq.verify((Object)mock, Mockito.times((int)1))).observe("foo");
        ((SCMSourceObserver.ProjectObserver)seq.verify((Object)observer, Mockito.never())).addSource((SCMSource)Matchers.any(SCMSource.class));
        ((SCMSourceObserver.ProjectObserver)seq.verify((Object)observer, Mockito.never())).addAttribute(Matchers.anyString(), (Object)Matchers.anyString());
        ((SCMSourceObserver.ProjectObserver)seq.verify((Object)observer, Mockito.times((int)1))).complete();
        seq.verifyNoMoreInteractions();
    }

    @Test
    public void visitSources_one() throws Exception {
        SCMSource s1 = (SCMSource)Mockito.mock(SCMSource.class);
        SCMSourceObserver mock = (SCMSourceObserver)Mockito.mock(SCMSourceObserver.class);
        SCMSourceObserver.ProjectObserver observer = (SCMSourceObserver.ProjectObserver)Mockito.mock(SCMSourceObserver.ProjectObserver.class);
        InOrder seq = Mockito.inOrder((Object[])new Object[]{mock, observer});
        Mockito.when((Object)mock.observe("foo")).thenReturn((Object)observer);
        new SingleSCMNavigator("foo", Collections.singletonList(s1)).visitSources(mock);
        ((SCMSourceObserver)seq.verify((Object)mock, Mockito.times((int)1))).observe("foo");
        ((SCMSourceObserver.ProjectObserver)seq.verify((Object)observer, Mockito.times((int)1))).addSource(s1);
        ((SCMSourceObserver.ProjectObserver)seq.verify((Object)observer, Mockito.never())).addAttribute(Matchers.anyString(), (Object)Matchers.anyString());
        ((SCMSourceObserver.ProjectObserver)seq.verify((Object)observer, Mockito.times((int)1))).complete();
        seq.verifyNoMoreInteractions();
    }

    @Test
    public void visitSources_two() throws Exception {
        SCMSource s1 = (SCMSource)Mockito.mock(SCMSource.class);
        SCMSource s2 = (SCMSource)Mockito.mock(SCMSource.class);
        SCMSourceObserver mock = (SCMSourceObserver)Mockito.mock(SCMSourceObserver.class);
        SCMSourceObserver.ProjectObserver observer = (SCMSourceObserver.ProjectObserver)Mockito.mock(SCMSourceObserver.ProjectObserver.class);
        InOrder seq = Mockito.inOrder((Object[])new Object[]{mock, observer});
        Mockito.when((Object)mock.observe("foo")).thenReturn((Object)observer);
        new SingleSCMNavigator("foo", Arrays.asList(s1, s2)).visitSources(mock);
        ((SCMSourceObserver)seq.verify((Object)mock, Mockito.times((int)1))).observe("foo");
        ((SCMSourceObserver.ProjectObserver)seq.verify((Object)observer, Mockito.times((int)1))).addSource(s1);
        ((SCMSourceObserver.ProjectObserver)seq.verify((Object)observer, Mockito.times((int)1))).addSource(s2);
        ((SCMSourceObserver.ProjectObserver)seq.verify((Object)observer, Mockito.never())).addAttribute(Matchers.anyString(), (Object)Matchers.anyString());
        ((SCMSourceObserver.ProjectObserver)seq.verify((Object)observer, Mockito.times((int)1))).complete();
        seq.verifyNoMoreInteractions();
    }
}

