/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl;

import hudson.scm.SCM;
import java.util.Collections;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMTrait;
import jenkins.scm.impl.SingleSCMNavigator;
import jenkins.scm.impl.SingleSCMSource;
import jenkins.scm.impl.mock.MockRepositoryFlags;
import jenkins.scm.impl.mock.MockSCM;
import jenkins.scm.impl.mock.MockSCMController;
import jenkins.scm.impl.mock.MockSCMDiscoverBranches;
import jenkins.scm.impl.mock.MockSCMDiscoverChangeRequests;
import jenkins.scm.impl.mock.MockSCMDiscoverTags;
import jenkins.scm.impl.mock.MockSCMHead;
import jenkins.scm.impl.mock.MockSCMNavigator;
import jenkins.scm.impl.mock.MockSCMRevision;
import jenkins.scm.impl.mock.MockSCMSource;
import jenkins.scm.impl.trait.RegexSCMHeadFilterTrait;
import jenkins.scm.impl.trait.RegexSCMSourceFilterTrait;
import jenkins.scm.impl.trait.WildcardSCMHeadFilterTrait;
import jenkins.scm.impl.trait.WildcardSCMSourceFilterTrait;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class SymbolAnnotationsTest {
    @ClassRule
    public static JenkinsRule r = new JenkinsRule();

    @Test
    public void given__mockScm__when__uninstantiating__then__noRaw$class() throws Exception {
        try (MockSCMController c = MockSCMController.create();){
            c.createRepository("test", new MockRepositoryFlags[0]);
            MockSCM instance = new MockSCM(c, "test", new MockSCMHead("master"), new MockSCMRevision(new MockSCMHead("master"), c.getRevision("test", "master")));
            Assert.assertThat((Object)DescribableModel.uninstantiate2_((Object)instance).toString(), (Matcher)Matchers.allOf((Matcher)Matchers.startsWith((String)"@"), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)", $")), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"=$")), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"[$")), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"{$"))));
            Assert.assertThat((Object)DescribableModel.uninstantiate2_((Object)instance).toString(), (Matcher)Matchers.is((Object)("@mockScm(controllerId=" + c.getId() + ",head=master,repository=test,revision=" + c.getRevision("test", "master") + ")")));
        }
    }

    @Test
    public void given__mockScmSource__when__uninstantiating__then__noRaw$class() throws Exception {
        try (MockSCMController c = MockSCMController.create();){
            c.createRepository("test", new MockRepositoryFlags[0]);
            MockSCMSource instance = new MockSCMSource(c, "test", new SCMSourceTrait[]{new MockSCMDiscoverBranches(), new MockSCMDiscoverChangeRequests(new ChangeRequestCheckoutStrategy[0]), new MockSCMDiscoverTags(), new WildcardSCMHeadFilterTrait("*", "ignore"), new RegexSCMHeadFilterTrait("i.*")});
            Assert.assertThat((Object)DescribableModel.uninstantiate2_((Object)((Object)instance)).toString(), (Matcher)Matchers.allOf((Matcher)Matchers.startsWith((String)"@"), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)", $")), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"=$")), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"[$")), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"{$"))));
            Assert.assertThat((Object)DescribableModel.uninstantiate2_((Object)((Object)instance)).toString(), (Matcher)Matchers.is((Object)("@mockScm(controllerId=" + c.getId() + ",id=" + instance.getId() + ",repository=test,traits=[@discoverBranches$MockSCMDiscoverBranches(), @discoverChangeRequests$MockSCMDiscoverChangeRequests(strategiesStr=HEAD, ), @discoverTags$MockSCMDiscoverTags(), @headWildcardFilter$WildcardSCMHeadFilterTrait(excludes=ignore,includes=*), @headRegexFilter$RegexSCMHeadFilterTrait(regex=i.*)])")));
        }
    }

    @Test
    public void given__mockScmNavigator__when__uninstantiating__then__noRaw$class() throws Exception {
        try (MockSCMController c = MockSCMController.create();){
            c.createRepository("test", new MockRepositoryFlags[0]);
            MockSCMNavigator instance = new MockSCMNavigator(c, new SCMTrait[]{new MockSCMDiscoverBranches(), new MockSCMDiscoverChangeRequests(new ChangeRequestCheckoutStrategy[0]), new MockSCMDiscoverTags(), new WildcardSCMHeadFilterTrait("*", "ignore"), new RegexSCMHeadFilterTrait("i.*"), new WildcardSCMSourceFilterTrait("i*", "ignored"), new RegexSCMSourceFilterTrait("ig.*")});
            Assert.assertThat((Object)DescribableModel.uninstantiate2_((Object)((Object)instance)).toString(), (Matcher)Matchers.allOf((Matcher)Matchers.startsWith((String)"@"), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)", $")), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"=$")), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"[$")), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"{$"))));
            Assert.assertThat((Object)DescribableModel.uninstantiate2_((Object)((Object)instance)).toString(), (Matcher)Matchers.is((Object)("@mockScm(controllerId=" + c.getId() + ",traits=[@discoverBranches$MockSCMDiscoverBranches(), @discoverChangeRequests$MockSCMDiscoverChangeRequests(strategiesStr=HEAD, ), @discoverTags$MockSCMDiscoverTags(), @headWildcardFilter$WildcardSCMHeadFilterTrait(excludes=ignore,includes=*), @headRegexFilter$RegexSCMHeadFilterTrait(regex=i.*), @sourceWildcardFilter$WildcardSCMSourceFilterTrait(excludes=ignored,includes=i*), @sourceRegexFilter$RegexSCMSourceFilterTrait(regex=ig.*)])")));
        }
    }

    @Test
    public void given__singleScmNavigator__when__uninstantiating__then__noRaw$class() throws Exception {
        try (MockSCMController c = MockSCMController.create();){
            c.createRepository("test", new MockRepositoryFlags[0]);
            SingleSCMNavigator instance = new SingleSCMNavigator("foo", Collections.singletonList(new MockSCMSource(c, "test", new SCMSourceTrait[0])));
            Assert.assertThat((Object)DescribableModel.uninstantiate2_((Object)instance).toString(), (Matcher)Matchers.allOf((Matcher)Matchers.startsWith((String)"@"), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)", $")), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"=$")), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"[$")), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"{$"))));
            Assert.assertThat((Object)DescribableModel.uninstantiate2_((Object)instance).toString(), (Matcher)Matchers.is((Object)("@fromSource(name=foo,sources=[@mockScm$MockSCMSource(controllerId=" + c.getId() + ",id=" + ((SCMSource)instance.getSources().get(0)).getId() + ",repository=test,traits=[])])")));
        }
    }

    @Test
    public void given__singleScmSource__when__uninstantiating__then__noRaw$class() throws Exception {
        try (MockSCMController c = MockSCMController.create();){
            c.createRepository("test", new MockRepositoryFlags[0]);
            SingleSCMSource instance = new SingleSCMSource("foo", "foo", (SCM)new MockSCM(c, "test", new MockSCMHead("master"), new MockSCMRevision(new MockSCMHead("master"), c.getRevision("test", "master"))));
            Assert.assertThat((Object)DescribableModel.uninstantiate2_((Object)instance).toString(), (Matcher)Matchers.allOf((Matcher)Matchers.startsWith((String)"@"), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)", $")), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"=$")), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"[$")), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"{$"))));
            Assert.assertThat((Object)DescribableModel.uninstantiate2_((Object)instance).toString(), (Matcher)Matchers.is((Object)("@fromScm(id=foo,name=foo,scm=@mockScm$MockSCM(controllerId=" + c.getId() + ",head=master,repository=test,revision=" + c.getRevision("test", "master") + "))")));
        }
    }
}

