/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.trait;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMSourceObserver;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.trait.SCMTrait;
import jenkins.scm.impl.NoOpProjectObserver;
import jenkins.scm.impl.mock.MockRepositoryFlags;
import jenkins.scm.impl.mock.MockSCMController;
import jenkins.scm.impl.mock.MockSCMNavigator;
import jenkins.scm.impl.trait.RegexSCMSourceFilterTrait;
import jenkins.scm.impl.trait.WildcardSCMSourceFilterTrait;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class RegexSCMSourceFilterTraitTest {
    @ClassRule
    public static JenkinsRule r = new JenkinsRule();

    @Test
    public void given_navigatorWithIncludeRegexRule_when_scanning_then_ruleApplied() throws Exception {
        try (MockSCMController c = MockSCMController.create();){
            c.createRepository("foo", new MockRepositoryFlags[0]);
            c.createRepository("bar", new MockRepositoryFlags[0]);
            c.createRepository("manchu", new MockRepositoryFlags[0]);
            MockSCMNavigator src = new MockSCMNavigator(c, new SCMTrait[]{new RegexSCMSourceFilterTrait("[fb].+")});
            SimpleSCMSourceObserver observer = new SimpleSCMSourceObserver();
            src.visitSources(observer);
            Assert.assertThat(observer.getNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"foo", "bar"}));
        }
    }

    private static class SimpleSCMSourceObserver
    extends SCMSourceObserver {
        Set<String> names = new HashSet<String>();
        LogTaskListener listener = new LogTaskListener(Logger.getLogger(WildcardSCMSourceFilterTrait.class.getName()), Level.INFO);

        private SimpleSCMSourceObserver() {
        }

        @NonNull
        public SCMSourceOwner getContext() {
            return null;
        }

        @NonNull
        public TaskListener getListener() {
            return this.listener;
        }

        @NonNull
        public SCMSourceObserver.ProjectObserver observe(@NonNull String projectName) throws IllegalArgumentException, IOException, InterruptedException {
            this.names.add(projectName);
            return NoOpProjectObserver.instance();
        }

        public void addAttribute(@NonNull String key, @Nullable Object value) throws IllegalArgumentException, ClassCastException {
        }

        public Set<String> getNames() {
            return this.names;
        }
    }
}

