/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api.trait;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.WeakHashMap;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMSourceBuilder;
import org.jvnet.tiger_types.Types;

public abstract class SCMSourceDecorator<B extends SCMSourceBuilder<B, S>, S extends SCMSource> {
    private static final WeakHashMap<Class<? extends SCMSourceDecorator>, Class<? extends SCMSourceBuilder>> builders = new WeakHashMap();
    private final Class<B> builderClass;

    protected SCMSourceDecorator() {
        this.builderClass = SCMSourceDecorator.inferBuilderClass(this.getClass());
    }

    protected SCMSourceDecorator(Class<B> builderClass) {
        this.builderClass = builderClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <B extends SCMSourceBuilder<B, S>, S extends SCMSource> Class<B> inferBuilderClass(Class<? extends SCMSourceDecorator> clazz) {
        WeakHashMap<Class<? extends SCMSourceDecorator>, Class<? extends SCMSourceBuilder>> weakHashMap = builders;
        synchronized (weakHashMap) {
            Class result = builders.get(clazz);
            if (result == null) {
                Type bt = Types.getBaseClass(clazz, SCMSourceDecorator.class);
                if (bt instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)bt;
                    result = Types.erasure((Type)pt.getActualTypeArguments()[0]);
                    if (!SCMSourceBuilder.class.isAssignableFrom(result)) {
                        throw new AssertionError((Object)("SCMSourceBuilder inference failed for " + clazz.getName() + ", try using the constructor that takes an explicit class argument"));
                    }
                } else {
                    result = SCMSourceBuilder.class;
                }
                builders.put(clazz, result);
            }
            return result;
        }
    }

    public final void applyTo(SCMSourceBuilder<?, ?> builder, String projectName) {
        if (this.builderClass.isInstance(builder)) {
            this.decorate((SCMSourceBuilder)this.builderClass.cast(builder), projectName);
        }
    }

    protected abstract void decorate(B var1, String var2);
}

