/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.RestrictedSince;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.model.TopLevelItemDescriptor;
import hudson.scm.NullSCM;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.impl.Messages;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;

public class SingleSCMSource
extends SCMSource {
    private final String name;
    private final SCM scm;
    private transient SCMHead head;
    private transient SCMRevisionImpl revisionHash;

    @DataBoundConstructor
    public SingleSCMSource(String name, SCM scm) {
        this.name = name;
        this.scm = scm;
    }

    @Restricted(value={NoExternalUse.class})
    @Deprecated
    @RestrictedSince(value="2.2.0")
    public SingleSCMSource(String id, String name, SCM scm) {
        this.setId(id);
        this.name = name;
        this.scm = scm;
    }

    public String getName() {
        return this.name;
    }

    public SCM getScm() {
        return this.scm;
    }

    @Override
    protected void retrieve(@CheckForNull SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer, @CheckForNull SCMHeadEvent<?> event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        if (this.head == null) {
            this.head = new SCMHead(this.name);
            this.revisionHash = new SCMRevisionImpl(this.head);
        }
        observer.observe(this.head, this.revisionHash);
    }

    @Override
    @NonNull
    public SCM build(@NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        if (this.name.equals(head.getName())) {
            return this.scm;
        }
        return new NullSCM();
    }

    @Override
    public String toString() {
        return "SingleSCMSource{super=" + super.toString() + ", name='" + this.name + '\'' + ", scm=" + this.scm + ", head=" + this.head + ", revisionHash=" + this.revisionHash + '}';
    }

    @Symbol(value={"fromScm"})
    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor {
        public String getDisplayName() {
            return Messages.SingleSCMSource_DisplayName();
        }

        public static List<SCMDescriptor<?>> getSCMDescriptors(@AncestorInPath SCMSourceOwner context) {
            Descriptor descriptor;
            ArrayList result = new ArrayList((Collection<SCMDescriptor<?>>)SCM.all());
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                SCMDescriptor d = (SCMDescriptor)iterator.next();
                if (!NullSCM.class.equals((Object)d.clazz)) continue;
                iterator.remove();
            }
            if (context instanceof Describable && (descriptor = ((Describable)context).getDescriptor()) instanceof TopLevelItemDescriptor) {
                TopLevelItemDescriptor topLevelItemDescriptor = (TopLevelItemDescriptor)descriptor;
                Iterator iterator2 = result.iterator();
                while (iterator2.hasNext()) {
                    SCMDescriptor d = (SCMDescriptor)iterator2.next();
                    if (topLevelItemDescriptor.isApplicable((Descriptor)d)) continue;
                    iterator2.remove();
                }
            }
            return result;
        }
    }

    private static class SCMRevisionImpl
    extends SCMRevision {
        public SCMRevisionImpl(SCMHead head) {
            super(head);
        }

        @Override
        public boolean isDeterministic() {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SCMRevisionImpl that = (SCMRevisionImpl)o;
            return this.getHead().equals(that.getHead());
        }

        @Override
        public int hashCode() {
            return this.getHead().hashCode();
        }
    }
}

