/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ssegateway;

import hudson.Extension;
import hudson.model.RootAction;
import hudson.security.csrf.CrumbExclusion;
import hudson.util.HttpResponses;
import hudson.util.PluginServletFilter;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.ssegateway.EventHistoryStore;
import org.jenkinsci.plugins.ssegateway.SubscriptionConfigQueue;
import org.jenkinsci.plugins.ssegateway.sse.EventDispatcher;
import org.jenkinsci.plugins.ssegateway.sse.EventDispatcherFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(value={NoExternalUse.class})
@Extension
public class Endpoint
extends CrumbExclusion
implements RootAction {
    public static final String SSE_GATEWAY_URL = "/sse-gateway";
    public static final String SSE_LISTEN_URL_PREFIX = "/sse-gateway/listen/";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Endpoint.class.getName());

    public Endpoint() throws ServletException {
        this.init();
    }

    public boolean process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestedResource;
        String contentType = request.getHeader("Content-Type");
        if (contentType != null && contentType.contains("application/json") && (requestedResource = Endpoint.getRequestedResourcePath(request)).equals("/sse-gateway/configure")) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        return false;
    }

    protected void init() throws ServletException {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null) {
            try {
                EventHistoryStore.setHistoryRoot(this.getHistoryDirectory(jenkins));
                EventHistoryStore.enableAutoDeleteOnExpire();
            }
            catch (IOException e) {
                LOGGER.error("Unexpected error setting EventHistoryStore event history root dir.", (Throwable)e);
            }
        }
        PluginServletFilter.addFilter((Filter)new SSEListenChannelFilter());
    }

    private File getHistoryDirectory(Jenkins jenkins) {
        String overriddenLogsRoot = System.getProperty("hudson.triggers.SafeTimerTask.logsTargetDir");
        if (overriddenLogsRoot == null) {
            return new File(jenkins.getRootDir(), "/logs/sse-events");
        }
        return new File(overriddenLogsRoot, "sse-events");
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return SSE_GATEWAY_URL;
    }

    @Restricted(value={DoNotUse.class})
    public HttpResponse doConnect(StaplerRequest request, StaplerResponse response) throws IOException {
        String clientId = request.getParameter("clientId");
        if (clientId == null) {
            throw new IOException("No 'clientId' parameter specified in connect request.");
        }
        HttpSession session = request.getSession();
        EventDispatcher dispatcher = EventDispatcherFactory.getDispatcher(clientId, session);
        if (dispatcher != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("We already have a Dispatcher for clientId {}. Removing all subscriptions on the existing Dispatcher instance and reusing it.", (Object)dispatcher.toString());
            }
            dispatcher.unsubscribeAll();
        } else {
            EventDispatcherFactory.newDispatcher(clientId, session);
        }
        response.setStatus(200);
        JSONObject responseData = new JSONObject();
        responseData.put("jsessionid", (Object)session.getId());
        return HttpResponses.okJSON((JSONObject)responseData);
    }

    @RequirePOST
    @Restricted(value={DoNotUse.class})
    public HttpResponse doConfigure(StaplerRequest request, StaplerResponse response) throws IOException {
        SubscriptionConfigQueue.SubscriptionConfig subscriptionConfig = SubscriptionConfigQueue.SubscriptionConfig.fromRequest(request);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing configuration request. batchId={}", (Object)subscriptionConfig.getBatchId());
        }
        if (subscriptionConfig.getDispatcherId() == null) {
            response.setStatus(400);
            return HttpResponses.errorJSON((String)"'dispatcherId' not specified.");
        }
        if (!subscriptionConfig.hasConfigs()) {
            response.setStatus(400);
            return HttpResponses.errorJSON((String)"No 'subscribe' or 'unsubscribe' configurations provided in configuration request.");
        }
        boolean queuedOkay = SubscriptionConfigQueue.add(subscriptionConfig);
        response.setStatus(200);
        if (queuedOkay) {
            return HttpResponses.okJSON();
        }
        return HttpResponses.errorJSON((String)"Unable to process channel subscription request at this time.");
    }

    @Restricted(value={DoNotUse.class})
    public HttpResponse doPing(StaplerRequest request) throws IOException {
        EventDispatcher dispatcher;
        String dispatcherId = request.getParameter("dispatcherId");
        if (dispatcherId != null && (dispatcher = EventDispatcherFactory.getDispatcher(dispatcherId, request.getSession())) != null) {
            try {
                dispatcher.dispatchEvent("pingback", "ack");
            }
            catch (ServletException e) {
                LOGGER.debug("Failed to send pingback to dispatcher " + dispatcherId + ".", (Throwable)e);
                return HttpResponses.errorJSON((String)("Failed to send pingback to dispatcher " + dispatcherId + "."));
            }
        }
        return HttpResponses.okJSON();
    }

    private static String getRequestedResourcePath(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length());
    }

    private static class SSEListenChannelFilter
    implements Filter {
        private SSEListenChannelFilter() {
        }

        public void init(FilterConfig filterConfig) throws ServletException {
            SubscriptionConfigQueue.start();
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            HttpServletRequest httpServletRequest;
            String requestedResource;
            if (servletRequest instanceof HttpServletRequest && (requestedResource = Endpoint.getRequestedResourcePath(httpServletRequest = (HttpServletRequest)servletRequest)).startsWith(Endpoint.SSE_LISTEN_URL_PREFIX)) {
                HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
                String[] clientTokens = requestedResource.substring(Endpoint.SSE_LISTEN_URL_PREFIX.length()).split(";");
                String clientId = clientTokens[0];
                clientId = URLDecoder.decode(clientId, "UTF-8");
                EventDispatcherFactory.start(clientId, httpServletRequest, httpServletResponse);
                return;
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }

        public void destroy() {
            SubscriptionConfigQueue.stop();
        }
    }
}

