/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ssegateway;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.security.ACL;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.StreamSupport;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.pubsub.ChannelSubscriber;
import org.jenkinsci.plugins.pubsub.Message;
import org.jenkinsci.plugins.pubsub.PubsubBus;
import org.jenkinsci.plugins.ssegateway.Util;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(value={NoExternalUse.class})
public final class EventHistoryStore {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)EventHistoryStore.class.getName());
    private static File historyRoot;
    private static long expiresAfter;
    private static Map<String, File> channelDirs;
    private static Timer autoExpireTimer;
    private static final Map<String, AtomicInteger> channelSubsCounters;
    private static final Map<String, EventHistoryLogger> channelLoggers;

    @SuppressFBWarnings(value={"LI_LAZY_INIT_STATIC"}, justification="internal class (marked @Restricted NoExternalUse + package private methods) - need it this way for testing.")
    static void setHistoryRoot(@Nonnull File historyRoot) throws IOException {
        if (EventHistoryStore.historyRoot != null && !Util.isTestEnv()) {
            LOGGER.warn("Invalid attempt to change historyRoot after it has already been set. Ignoring.");
            return;
        }
        if (!historyRoot.exists() && !historyRoot.mkdirs()) {
            throw new IOException(String.format("Unexpected error creating historyRoot dir %s. Check permissions etc.", historyRoot.getAbsolutePath()));
        }
        EventHistoryStore.historyRoot = historyRoot;
    }

    static void setExpiryMillis(long expiresAfterMillis) {
        if (!Util.isTestEnv()) {
            LOGGER.warn("Invalid attempt to change expiresAfterMillis. Ignoring.");
            return;
        }
        expiresAfter = expiresAfterMillis;
    }

    static void store(@Nonnull Message message) {
        try {
            String channelName = message.getChannelName();
            String eventUUID = message.getEventUUID();
            File channelDir = EventHistoryStore.getChannelDir(channelName);
            File writeEventFile = new File(channelDir, eventUUID + "_WRITE.json");
            File readEventFile = new File(channelDir, eventUUID + ".json");
            FileUtils.writeStringToFile((File)writeEventFile, (String)message.toJSON(), (String)"UTF-8");
            if (!writeEventFile.renameTo(readEventFile)) {
                LOGGER.warn("Unexpected error renaming EventHistoryStore entry file to {}.", (Object)readEventFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error persisting EventHistoryStore entry file.", (Throwable)e);
        }
    }

    @CheckForNull
    public static String getChannelEvent(@Nonnull String channelName, @Nonnull String eventUUID) throws IOException {
        File channelDir = EventHistoryStore.getChannelDir(channelName);
        File eventFile = new File(channelDir, eventUUID + ".json");
        if (eventFile.exists()) {
            return FileUtils.readFileToString((File)eventFile, (String)"UTF-8");
        }
        return null;
    }

    public static void onChannelSubscribe(@Nonnull String channelName) {
        if (historyRoot == null) {
            return;
        }
        EventHistoryStore.getChannelSubsCounter(channelName).incrementAndGet();
    }

    public static void onChannelUnsubscribe(@Nonnull String channelName) {
        if (historyRoot == null) {
            return;
        }
        EventHistoryStore.getChannelSubsCounter(channelName).decrementAndGet();
    }

    static long getChannelEventCount(@Nonnull String channelName) throws IOException {
        Path dirPath = Paths.get(EventHistoryStore.getChannelDir(channelName).toURI());
        try (DirectoryStream<Path> dirStream = EventHistoryStore.createDirectoryStream(dirPath);){
            long l = StreamSupport.stream(dirStream.spliterator(), false).count();
            return l;
        }
    }

    @Nonnull
    private static DirectoryStream<Path> createDirectoryStream(Path dirPath) throws IOException {
        return Files.newDirectoryStream(dirPath);
    }

    static void deleteAllHistory() throws IOException {
        EventHistoryStore.assertHistoryRootSet();
        for (File directory : channelDirs.values()) {
            EventHistoryStore.deleteAllFilesInDir(directory, Long.MAX_VALUE);
        }
        EventHistoryStore.deleteAllFilesInDir(historyRoot, Long.MAX_VALUE);
    }

    static void deleteStaleHistory() throws IOException {
        EventHistoryStore.assertHistoryRootSet();
        long olderThan = System.currentTimeMillis() - expiresAfter;
        EventHistoryStore.deleteAllFilesInDir(historyRoot, olderThan);
    }

    static File getChannelDir(@Nonnull String channelName) throws IOException {
        EventHistoryStore.assertHistoryRootSet();
        File channelDir = channelDirs.get(channelName);
        if (channelDir == null) {
            channelDir = new File(historyRoot, channelName);
            channelDirs.put(channelName, channelDir);
        }
        if (!channelDir.exists() && !channelDir.mkdirs()) {
            throw new IOException(String.format("Unexpected error creating channel event log dir %s.", channelDir.getAbsolutePath()));
        }
        return channelDir;
    }

    private static synchronized void deleteAllFilesInDir(File dir, long olderThan) throws IOException {
        Path dirPath = Paths.get(dir.toURI());
        if (!Files.exists(dirPath, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> dirStream = EventHistoryStore.createDirectoryStream(dirPath);){
            for (Path entry : dirStream) {
                File file = entry.toFile();
                if (file.isDirectory()) {
                    EventHistoryStore.deleteAllFilesInDir(file, olderThan);
                }
                if (file.lastModified() >= olderThan || file.delete()) continue;
                LOGGER.warn("Error deleting file {}", (Object)file.getAbsolutePath());
            }
        }
    }

    private static void assertHistoryRootSet() {
        if (historyRoot == null) {
            throw new IllegalStateException("'historyRoot' not set. Check for earlier initialization errors.");
        }
    }

    public static synchronized void enableAutoDeleteOnExpire() {
        if (autoExpireTimer != null) {
            LOGGER.warn("AutoExpireTimer was already enable.");
            return;
        }
        long taskSchedule = expiresAfter / 3L;
        autoExpireTimer = new Timer("EventHistoryStore.autoExpireTimer");
        autoExpireTimer.schedule((TimerTask)new DeleteStaleHistoryTask(), taskSchedule, taskSchedule);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> EventHistoryStore.disableAutoDeleteOnExpire(), "EventHistoryStore.disableAutoExpireTimer"));
    }

    public static synchronized void disableAutoDeleteOnExpire() {
        if (autoExpireTimer == null) {
            return;
        }
        autoExpireTimer.cancel();
        autoExpireTimer = null;
    }

    private static AtomicInteger getChannelSubsCounter(@Nonnull String channelName) {
        AtomicInteger counter = channelSubsCounters.get(channelName);
        if (counter == null) {
            counter = EventHistoryStore.newChannelSubsCounter(channelName);
        }
        return counter;
    }

    private static synchronized AtomicInteger newChannelSubsCounter(@Nonnull String channelName) {
        AtomicInteger counter = channelSubsCounters.get(channelName);
        if (counter == null) {
            counter = new AtomicInteger(0);
            channelSubsCounters.put(channelName, counter);
            EventHistoryLogger logger = channelLoggers.get(channelName);
            if (logger == null) {
                logger = new EventHistoryLogger(counter);
                PubsubBus.getBus().subscribe(channelName, (ChannelSubscriber)logger, ACL.SYSTEM, null);
                channelLoggers.put(channelName, logger);
            }
        }
        return counter;
    }

    static {
        expiresAfter = 60000L;
        channelDirs = new ConcurrentHashMap<String, File>();
        channelSubsCounters = new ConcurrentHashMap<String, AtomicInteger>();
        channelLoggers = new ConcurrentHashMap<String, EventHistoryLogger>();
    }

    private static class EventHistoryLogger
    implements ChannelSubscriber {
        private final AtomicInteger channelSubsCounter;

        private EventHistoryLogger(AtomicInteger channelSubsCounter) {
            this.channelSubsCounter = channelSubsCounter;
        }

        public void onMessage(@Nonnull Message message) {
            if (this.channelSubsCounter.get() > 0) {
                EventHistoryStore.store(message);
            }
        }
    }

    private static class DeleteStaleHistoryTask
    extends TimerTask {
        private DeleteStaleHistoryTask() {
        }

        @Override
        public void run() {
            try {
                EventHistoryStore.deleteStaleHistory();
            }
            catch (Exception e) {
                LOGGER.warn("Error deleting stale/expired events from EventHistoryStore.", (Throwable)e);
            }
        }
    }
}

