/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ssegateway;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pubsub.EventFilter;
import org.jenkinsci.plugins.ssegateway.EventHistoryStore;
import org.jenkinsci.plugins.ssegateway.Util;
import org.jenkinsci.plugins.ssegateway.sse.EventDispatcher;
import org.jenkinsci.plugins.ssegateway.sse.EventDispatcherFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(value={NoExternalUse.class})
final class SubscriptionConfigQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SubscriptionConfigQueue.class.getName());
    private static BlockingQueue<SubscriptionConfig> queue = null;

    private SubscriptionConfigQueue() {
    }

    static boolean isStarted() {
        return queue != null;
    }

    static synchronized void start() {
        if (queue != null) {
            LOGGER.info("SSE Configure Queue already started. Ignoring unexpected request to start again.");
            return;
        }
        queue = new LinkedBlockingQueue<SubscriptionConfig>();
        new Thread(() -> {
            try {
                while (true) {
                    SubscriptionConfig subscriptionConfig;
                    if ((subscriptionConfig = queue.take()) == SubscriptionConfig.STOP_CONFIG) {
                        return;
                    }
                    try {
                        SubscriptionConfigQueue.doConfigure(subscriptionConfig);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error processing SSE configuration request.", (Throwable)e);
                    }
                    continue;
                    break;
                }
            }
            catch (InterruptedException e) {
                LOGGER.info("SSE configure queue processing interrupted. Stopping.", (Throwable)e);
                return;
            }
            finally {
                queue = null;
            }
        }, "SubscriptionConfigQueue.start").start();
    }

    static synchronized void stop() {
        if (queue == null) {
            LOGGER.info("SSE Configure Queue is not started. Ignoring unexpected request to stop.");
            return;
        }
        try {
            queue.put(SubscriptionConfig.STOP_CONFIG);
        }
        catch (InterruptedException e) {
            LOGGER.error("Unexpected error stopping SSE Configure Queue.", (Throwable)e);
        }
    }

    static boolean add(SubscriptionConfig subscriptionConfig) {
        return queue.offer(subscriptionConfig);
    }

    private static void doConfigure(SubscriptionConfig subscriptionConfig) {
        EventDispatcher dispatcher = EventDispatcherFactory.getDispatcher(subscriptionConfig.dispatcherId, subscriptionConfig.session);
        if (dispatcher == null) {
            LOGGER.warn("Failed Jenkins SSE Gateway configuration request. Unknown SSE event dispatcher " + subscriptionConfig.dispatcherId);
            return;
        }
        if (subscriptionConfig.unsubscribeAll) {
            dispatcher.unsubscribeAll();
        }
        for (EventFilter filter : subscriptionConfig.unsubscribeSet) {
            if (!dispatcher.unsubscribe(filter)) continue;
            EventHistoryStore.onChannelUnsubscribe(filter.getChannelName());
        }
        for (EventFilter filter : subscriptionConfig.subscribeSet) {
            if (!dispatcher.subscribe(filter)) continue;
            EventHistoryStore.onChannelSubscribe(filter.getChannelName());
        }
        if (subscriptionConfig.batchId != null) {
            try {
                JSONObject data = new JSONObject();
                data.put("batchId", (Object)subscriptionConfig.batchId);
                data.put("dispatcherId", (Object)dispatcher.getId());
                data.put("dispatcherInst", (Object)System.identityHashCode(dispatcher));
                dispatcher.dispatchEvent("configure", data.toString());
            }
            catch (Exception e) {
                LOGGER.error("Error sending configuration ACK for batchId=" + subscriptionConfig.batchId, (Throwable)e);
            }
        }
    }

    static class SubscriptionConfig {
        private static final SubscriptionConfig STOP_CONFIG = new SubscriptionConfig();
        private String batchId;
        private String dispatcherId;
        private HttpSession session;
        private List<EventFilter> subscribeSet = Collections.emptyList();
        private List<EventFilter> unsubscribeSet = Collections.emptyList();
        private boolean unsubscribeAll = false;

        SubscriptionConfig() {
        }

        public String getBatchId() {
            return this.batchId;
        }

        String getDispatcherId() {
            return this.dispatcherId;
        }

        static SubscriptionConfig fromRequest(StaplerRequest request) throws IOException {
            JSONObject payload = Util.readJSONPayload(request);
            SubscriptionConfig config = new SubscriptionConfig();
            config.batchId = request.getParameter("batchId");
            config.session = request.getSession();
            config.dispatcherId = payload.optString("dispatcherId", null);
            if (config.dispatcherId != null) {
                String unsubscribe;
                config.subscribeSet = SubscriptionConfig.extractFilterSet(payload, "subscribe");
                config.unsubscribeSet = SubscriptionConfig.extractFilterSet(payload, "unsubscribe");
                if (config.unsubscribeSet.isEmpty() && ("*".equals(unsubscribe = payload.optString("unsubscribe", null)) || "all".equalsIgnoreCase(unsubscribe))) {
                    config.unsubscribeAll = true;
                }
            }
            return config;
        }

        private static List<EventFilter> extractFilterSet(JSONObject payload, String key) {
            JSONArray jsonObjs = payload.optJSONArray(key);
            if (jsonObjs != null && !jsonObjs.isEmpty()) {
                ArrayList<EventFilter> filterSet = new ArrayList<EventFilter>();
                for (int i = 0; i < jsonObjs.size(); ++i) {
                    try {
                        JSONObject jsonObj = jsonObjs.getJSONObject(i);
                        EventFilter filter = (EventFilter)jsonObj.toBean(EventFilter.class);
                        filterSet.add(filter);
                        continue;
                    }
                    catch (JSONException e) {
                        LOGGER.error("Invalid SSE payload. Expecting an array of JSON Objects for property " + key, (Throwable)e);
                    }
                }
                return filterSet;
            }
            return Collections.emptyList();
        }

        public boolean hasConfigs() {
            return !this.subscribeSet.isEmpty() || !this.unsubscribeSet.isEmpty() || this.unsubscribeAll;
        }
    }
}

