/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshcredentials;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticatorFactory;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUser;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.SlaveToMasterCallable;
import net.jcip.annotations.GuardedBy;

public abstract class SSHAuthenticator<C, U extends StandardUsernameCredentials> {
    @NonNull
    private final C connection;
    @NonNull
    private final U user;
    private final String username;
    @NonNull
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    @CheckForNull
    private Boolean authenticated = null;
    @NonNull
    private volatile TaskListener listener = StreamTaskListener.fromStderr();

    @Deprecated
    protected SSHAuthenticator(@NonNull C connection, @NonNull U user) {
        this(connection, user, null);
    }

    protected SSHAuthenticator(@NonNull C connection, @NonNull U user, @CheckForNull String username) {
        connection.getClass();
        user.getClass();
        this.connection = connection;
        this.user = user;
        this.username = username;
    }

    public String getUsername() {
        return this.username == null ? this.getUser().getUsername() : this.username;
    }

    @NonNull
    public TaskListener getListener() {
        return this.listener;
    }

    public void setListener(TaskListener listener) {
        if (listener == null) {
            listener = TaskListener.NULL;
        }
        this.listener = listener;
    }

    @NonNull
    public static <C, U extends StandardUsernameCredentials> SSHAuthenticator<C, U> newInstance(@NonNull C connection, @NonNull U user) throws InterruptedException, IOException {
        return SSHAuthenticator.newInstance(connection, user, null);
    }

    @NonNull
    public static <C, U extends StandardUsernameCredentials> SSHAuthenticator<C, U> newInstance(@NonNull C connection, @NonNull U user, @CheckForNull String username) throws InterruptedException, IOException {
        Collection<SSHAuthenticatorFactory> factories;
        connection.getClass();
        user.getClass();
        try {
            factories = SSHAuthenticator.lookupFactories();
        }
        catch (LinkageError e) {
            factories = null;
        }
        catch (IllegalStateException e) {
            factories = null;
        }
        if (factories == null) {
            Channel channel = Channel.current();
            factories = channel == null ? Collections.emptySet() : (Collection)channel.call((Callable)new NewInstance());
        }
        for (SSHAuthenticatorFactory factory : factories) {
            SSHAuthenticator<C, U> result = factory.newInstance(connection, user, username);
            if (result == null || !result.canAuthenticate()) continue;
            return result;
        }
        return new SSHNonauthenticator<C, U>(connection, user, username);
    }

    private static List<SSHAuthenticatorFactory> lookupFactories() {
        return Jenkins.getInstance() == null ? null : ExtensionList.lookup(SSHAuthenticatorFactory.class);
    }

    @Deprecated
    public static SSHAuthenticator<Object, StandardUsernameCredentials> newInstance(Object connection, SSHUser user) throws InterruptedException, IOException {
        return SSHAuthenticator.newInstance(connection, user, null);
    }

    public static <C, U extends StandardUsernameCredentials> boolean isSupported(@NonNull Class<C> connectionClass, @NonNull Class<U> userClass) {
        connectionClass.getClass();
        userClass.getClass();
        for (SSHAuthenticatorFactory factory : ExtensionList.lookup(SSHAuthenticatorFactory.class)) {
            if (!factory.supports(connectionClass, userClass)) continue;
            return true;
        }
        return false;
    }

    public static List<? extends StandardUsernameCredentials> filter(Iterable<? extends Credentials> credentials, Class<?> connectionClass) {
        ArrayList<StandardUsernameCredentials> result = new ArrayList<StandardUsernameCredentials>();
        CredentialsMatcher matcher = SSHAuthenticator.matcher(connectionClass);
        for (Credentials credentials2 : credentials) {
            if (!(credentials2 instanceof StandardUsernameCredentials) || !matcher.matches(credentials2)) continue;
            result.add((StandardUsernameCredentials)credentials2);
        }
        return result;
    }

    public static CredentialsMatcher matcher() {
        return CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(SSHUserPrivateKey.class)});
    }

    public static CredentialsMatcher matcher(Class<?> connectionClass) {
        return new Matcher(connectionClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAuthenticate() {
        Object object = this.lock;
        synchronized (object) {
            return this.authenticated == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAuthenticated() {
        Object object = this.lock;
        synchronized (object) {
            return this.authenticated != null && this.authenticated != false;
        }
    }

    @NonNull
    protected final C getConnection() {
        return this.connection;
    }

    @NonNull
    public U getUser() {
        return this.user;
    }

    protected abstract boolean doAuthenticate();

    @NonNull
    public Mode getAuthenticationMode() {
        return Mode.AFTER_CONNECT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean authenticate() {
        Object object = this.lock;
        synchronized (object) {
            if (this.canAuthenticate()) {
                try {
                    this.authenticated = this.doAuthenticate();
                }
                catch (Throwable t) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Uncaught exception escaped doAuthenticate method", t);
                    this.authenticated = false;
                }
            }
            return this.isAuthenticated() || Mode.BEFORE_CONNECT.equals((Object)this.getAuthenticationMode());
        }
    }

    public final boolean authenticate(TaskListener listener) {
        this.setListener(listener);
        return this.authenticate();
    }

    public static List<String> getPrivateKeys(SSHUserPrivateKey user) {
        try {
            return user.getPrivateKeys();
        }
        catch (AbstractMethodError x) {
            return Collections.singletonList(user.getPrivateKey());
        }
    }

    private static class SSHNonauthenticator<C, U extends StandardUsernameCredentials>
    extends SSHAuthenticator<C, U> {
        public SSHNonauthenticator(C connection, U user, String username) {
            super(connection, user, username);
        }

        @Override
        protected boolean doAuthenticate() {
            return false;
        }
    }

    private static class NewInstance
    extends SlaveToMasterCallable<Collection<SSHAuthenticatorFactory>, IOException> {
        private static final long serialVersionUID = 1L;

        private NewInstance() {
        }

        public Collection<SSHAuthenticatorFactory> call() throws IOException {
            return new ArrayList<SSHAuthenticatorFactory>((Collection<SSHAuthenticatorFactory>)ExtensionList.lookup(SSHAuthenticatorFactory.class));
        }
    }

    public static enum Mode {
        BEFORE_CONNECT,
        AFTER_CONNECT;

    }

    private static class Matcher
    implements CredentialsMatcher {
        private static final Long serialVersionUID = -5078593817273453864L;
        private final Class<?> connectionClass;

        public Matcher(Class<?> connectionClass) {
            this.connectionClass = connectionClass;
        }

        public boolean matches(@NonNull Credentials item) {
            return item instanceof StandardUsernameCredentials && SSHAuthenticator.isSupported(this.connectionClass, ((StandardUsernameCredentials)StandardUsernameCredentials.class.cast(item)).getClass());
        }
    }
}

